/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.coverage.idea;

import com.intellij.rt.coverage.main.CoveragePremain;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import jetbrains.buildServer.agent.BuildProgressLogger;
import jetbrains.buildServer.coverage.idea.AgentCoverageForAnt;
import jetbrains.buildServer.coverage.idea.CoverageJavaArgsBuilder;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;

public class IDEAAntTaskExtension
extends AgentCoverageForAnt {
    public IDEAAntTaskExtension() {
        super("IDEA");
    }

    public Collection getAntRuntimeClasspathClasses() {
        try {
            ArrayList<Class> classes = new ArrayList<Class>();
            classes.add(CoveragePremain.class);
            classes.add(ClassVisitor.class);
            return classes;
        }
        catch (Throwable e) {
            if (this.myLogger != null) {
                this.myLogger.error(e.toString());
            }
            return null;
        }
    }

    protected String buildArgString(BuildProgressLogger logger) {
        File dataFile = this.getCoverageDataFile();
        if (dataFile.isFile() && dataFile.length() == 0L) {
            logger.warning("Empty coverage.ic file was found. Most likely coverage was not gathered properly during previous tests run, file will be removed.");
            if (!this.deleteFile(dataFile)) {
                logger.warning("Failed to remove coverage.ic file, it can be locked by JVM. Coverage cannot be enabled.");
                return null;
            }
        }
        CoverageJavaArgsBuilder argsBuilder = new CoverageJavaArgsBuilder();
        argsBuilder.setCoverageDataFile(dataFile);
        return argsBuilder.buildArgString(logger);
    }

    private boolean deleteFile(File dataFile) {
        for (int i = 0; i < 10; ++i) {
            if (dataFile.delete()) {
                return true;
            }
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException ignore) {
                return false;
            }
        }
        return false;
    }

    private File getCoverageDataFile() {
        return new File(this.getBaseDir(), "coverage.ic");
    }

    private String getBaseDir() {
        return System.getProperty("teamcity.coverage.idea.baseDir", ".");
    }
}

