/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.coverage.impl;

import jetbrains.buildServer.agent.AgentRunningBuild;
import jetbrains.buildServer.agent.BuildProgressLogger;
import jetbrains.buildServer.agent.CurrentBuildTracker;
import jetbrains.buildServer.coverage.CoverageStatisticsPublisher;
import jetbrains.buildServer.messages.serviceMessages.BuildStatisticValue;
import jetbrains.coverage.report.CoverageStatistics;
import jetbrains.coverage.report.StatEntry;
import org.jetbrains.annotations.NotNull;

public class CoverageStatisticsPublisherImpl
implements CoverageStatisticsPublisher {
    private final CurrentBuildTracker myTracker;

    public CoverageStatisticsPublisherImpl(CurrentBuildTracker tracker) {
        this.myTracker = tracker;
    }

    @Override
    public void publishCoverageStatistics(@NotNull CoverageStatistics stats) {
        if (stats == null) {
            CoverageStatisticsPublisherImpl.$$$reportNull$$$0(0);
        }
        AgentRunningBuild build = this.myTracker.getCurrentBuild();
        BuildProgressLogger logger = build.getBuildLogger();
        StatEntry lineStats = stats.getLineStats();
        StatEntry blockStats = stats.getBlockStats();
        StatEntry methodStats = stats.getMethodStats();
        StatEntry classStats = stats.getClassStats();
        StatEntry statementStats = stats.getStatementStats();
        if (statementStats != null) {
            this.logServiceMessage(logger, "CodeCoverageAbsSCovered", statementStats.getCovered());
            this.logServiceMessage(logger, "CodeCoverageAbsSTotal", statementStats.getTotal());
        }
        if (lineStats != null) {
            this.logServiceMessage(logger, "CodeCoverageAbsLCovered", lineStats.getCovered());
            this.logServiceMessage(logger, "CodeCoverageAbsLTotal", lineStats.getTotal());
        }
        if (blockStats != null) {
            this.logServiceMessage(logger, "CodeCoverageAbsBCovered", blockStats.getCovered());
            this.logServiceMessage(logger, "CodeCoverageAbsBTotal", blockStats.getTotal());
        }
        if (methodStats != null) {
            this.logServiceMessage(logger, "CodeCoverageAbsMCovered", methodStats.getCovered());
            this.logServiceMessage(logger, "CodeCoverageAbsMTotal", methodStats.getTotal());
        }
        if (classStats != null) {
            this.logServiceMessage(logger, "CodeCoverageAbsCCovered", classStats.getCovered());
            this.logServiceMessage(logger, "CodeCoverageAbsCTotal", classStats.getTotal());
        }
    }

    private void logServiceMessage(BuildProgressLogger logger, @NotNull String key, float value) {
        if (key == null) {
            CoverageStatisticsPublisherImpl.$$$reportNull$$$0(1);
        }
        if (value >= 0.0f) {
            logger.message(new BuildStatisticValue(key, value).asString());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stats";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/coverage/impl/CoverageStatisticsPublisherImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "publishCoverageStatistics";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "logServiceMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

