/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.coverage.jacoco;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import jetbrains.buildServer.agent.BuildProgressLogger;
import jetbrains.buildServer.coverage.CoverageConstants;
import jetbrains.buildServer.coverage.idea.AgentCoverageForAnt;

public class JacocoForAnt
extends AgentCoverageForAnt {
    public JacocoForAnt() {
        super("JACOCO");
    }

    public Collection getAntRuntimeClasspathClasses() {
        try {
            ArrayList<Class<CoverageConstants>> classes = new ArrayList<Class<CoverageConstants>>();
            classes.add(CoverageConstants.class);
            return classes;
        }
        catch (Throwable e) {
            if (this.myLogger != null) {
                this.myLogger.error(e.toString());
            }
            return null;
        }
    }

    protected String buildArgString(BuildProgressLogger logger) {
        String includes = System.getProperty("teamcity.coverage.jacoco.includePatterns");
        String excludes = System.getProperty("teamcity.coverage.jacoco.excludePatterns");
        String path = System.getProperty("teamcity.coverage.jacoco.javaagent.jar.path");
        StringBuffer sb = new StringBuffer("-javaagent:").append(path).append("=");
        if (includes != null) {
            sb.append("includes=").append(includes.replace(' ', ':')).append(",");
        }
        if (excludes != null) {
            sb.append("excludes=").append(excludes.replace(' ', ':')).append(",");
        }
        sb.append("append=true,destfile=").append(this.getJacocoExecFilePath());
        return sb.toString();
    }

    private String getJacocoExecFilePath() {
        String jacocoExecFilePath = System.getProperty("teamcity.jacoco.coverage.datafile");
        if (jacocoExecFilePath == null) {
            String tempDir = this.getOrCreateTempDirectory().getAbsolutePath();
            jacocoExecFilePath = tempDir + File.separator + "jacoco.exec";
            System.setProperty("teamcity.jacoco.coverage.datafile", jacocoExecFilePath);
        }
        return jacocoExecFilePath;
    }
}

