/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.crashDetector;

public enum FailureStatusConstants {
    EXECUTION_TIMEOUT_PREFIX("Execution timeout"),
    JVM_CRASHED_PREFIX("JVM crashed"),
    JVM_OOME_FAILURE_PREFIX("Out of memory:"),
    UNABLE_TO_COLLECT_CHANGES("Unable to collect changes"),
    COMPILATION_FAILED("Compilation error"),
    ARTIFACTS_PUBLISHING_FAILED("[Artifacts publishing failed]"),
    FAILURE("Failure");

    private final String myText;
    private final String myLowercaseText;

    private FailureStatusConstants(String text) {
        this.myText = text;
        this.myLowercaseText = text.toLowerCase();
    }

    public String getText() {
        return this.myText;
    }

    public static boolean isPreliminaryFinishStatus(String text) {
        String textLocase = text.toLowerCase();
        for (FailureStatusConstants statusConstants : FailureStatusConstants.values()) {
            if (textLocase.indexOf(statusConstants.myLowercaseText) < 0) continue;
            return true;
        }
        return false;
    }
}

