/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.http;

import com.intellij.openapi.util.io.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import jetbrains.buildServer.http.HttpApi;
import jetbrains.buildServer.http.HttpUserAgent;
import jetbrains.buildServer.http.HttpUtil;
import jetbrains.buildServer.http.SimpleCredentials;
import jetbrains.buildServer.http.UserSecureProtocolSocketFactory;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.ssl.SSLContextUtil;
import jetbrains.buildServer.util.ssl.SSLTrustStoreProvider;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpClientBasedHttpApi
implements HttpApi {
    private final HttpClient myHttpClient;

    public HttpClientBasedHttpApi(int connectionTimeout, String userAgent, SSLTrustStoreProvider sslTrustStoreProvider) {
        if (TeamCityProperties.getBooleanOrTrue((String)"teamcity.ssl.useCustomTrustStore")) {
            this.registerTrustStore(sslTrustStoreProvider.getTrustStore());
        }
        this.myHttpClient = HttpUtil.createHttpClient((int)connectionTimeout);
        this.myHttpClient.setHttpConnectionManager(HttpUtil.createMultiThreadedHttpConnectionManager((int)connectionTimeout));
        this.myHttpClient.getParams().setParameter("http.useragent", (Object)userAgent);
    }

    public void setProxy(@NotNull String proxyHost, int proxyPort, @Nullable SimpleCredentials credentials) {
        if (proxyHost == null) {
            HttpClientBasedHttpApi.$$$reportNull$$$0(0);
        }
        this.myHttpClient.getHostConfiguration().setProxy(proxyHost, proxyPort);
        HttpUtil.configureProxy((HttpClient)this.myHttpClient, (String)proxyHost, (int)proxyPort, (SimpleCredentials)credentials);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public HttpApi.Response get(String uri, HttpApi.HeaderPair ... headers) throws IOException {
        GetMethod get = new GetMethod(uri);
        this.initHeaders((HttpMethodBase)get, headers);
        this.myHttpClient.executeMethod((HttpMethod)get);
        HttpClientResponse httpClientResponse = new HttpClientResponse((HttpMethodBase)get);
        HttpClientResponse httpClientResponse2 = httpClientResponse;
        if (httpClientResponse2 == null) {
            HttpClientBasedHttpApi.$$$reportNull$$$0(1);
        }
        return httpClientResponse2;
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public HttpApi.Response post(String uri, String body, String contentType, String charset, HttpApi.HeaderPair ... headers) throws IOException {
        PostMethod post = new PostMethod(uri);
        this.initHeaders((HttpMethodBase)post, headers);
        post.setRequestEntity((RequestEntity)new StringRequestEntity(body, contentType, charset));
        this.myHttpClient.executeMethod((HttpMethod)post);
        HttpClientResponse httpClientResponse = new HttpClientResponse((HttpMethodBase)post);
        HttpClientResponse httpClientResponse2 = httpClientResponse;
        if (httpClientResponse2 == null) {
            HttpClientBasedHttpApi.$$$reportNull$$$0(2);
        }
        return httpClientResponse2;
        finally {
            post.releaseConnection();
        }
    }

    private void initHeaders(HttpMethodBase method, HttpApi.HeaderPair[] headers) {
        boolean hasUserAgent = false;
        for (HttpApi.HeaderPair header : headers) {
            if ("User-Agent".equals(header.getFirst())) {
                hasUserAgent = true;
            }
            method.addRequestHeader((String)header.getFirst(), header.getSecond().toString());
        }
        if (!hasUserAgent) {
            HttpUserAgent.addHeader((HttpMethod)method);
        }
    }

    private void registerTrustStore(KeyStore trustStore) {
        SSLContext sslContext = SSLContextUtil.createUserSSLContext((KeyStore)trustStore);
        if (sslContext != null) {
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (SecureProtocolSocketFactory)new UserSecureProtocolSocketFactory(sslContext), 443));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxyHost";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/http/HttpClientBasedHttpApi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/http/HttpClientBasedHttpApi";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "post";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setProxy";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HttpClientResponse
    implements HttpApi.Response {
        private final int myStatus;
        private final String myBody;
        private final Header[] headers;
        private final String myStatusText;

        public HttpClientResponse(HttpMethodBase httpMethod) throws IOException {
            this.myStatus = httpMethod.getStatusCode();
            this.myStatusText = httpMethod.getStatusText();
            InputStream is = httpMethod.getResponseBodyAsStream();
            this.myBody = is != null ? StreamUtil.readText((InputStream)is, (String)httpMethod.getResponseCharSet()) : "";
            this.headers = httpMethod.getResponseHeaders();
        }

        @Override
        public int getStatusCode() {
            return this.myStatus;
        }

        @Override
        @NotNull
        public String getStatusText() {
            String string = this.myStatusText;
            if (string == null) {
                HttpClientResponse.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getBody() {
            String string = this.myBody;
            if (string == null) {
                HttpClientResponse.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nullable
        public String getHeader(String name) {
            for (Header header : this.headers) {
                if (!header.getName().equalsIgnoreCase(name)) continue;
                return header.getValue();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "jetbrains/buildServer/http/HttpClientBasedHttpApi$HttpClientResponse";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatusText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBody";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

