/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.ideaCommandLine;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import jetbrains.buildServer.agent.BuildProgressLogger;
import jetbrains.buildServer.messages.BuildMessage1;
import jetbrains.buildServer.messages.Status;

public class XmlRpcUtil {
    private XmlRpcUtil() {
    }

    public static <T> void splitAndSendProblems(Set<T> messages, BuildProgressLogger logger, String sourceId, String typeId) {
        if (messages.size() > 100) {
            HashSet<T> set = new HashSet<T>();
            for (T messageBean : messages) {
                set.add(messageBean);
                if (set.size() < 100) continue;
                XmlRpcUtil.sendSetOfProblems(logger, set, sourceId, typeId);
                logger.flush();
                set = new HashSet();
            }
            if (!set.isEmpty()) {
                XmlRpcUtil.sendSetOfProblems(logger, set, sourceId, typeId);
            }
        } else {
            XmlRpcUtil.sendSetOfProblems(logger, messages, sourceId, typeId);
        }
    }

    static <T> void sendSetOfProblems(BuildProgressLogger logger, Set<T> set, String sourceId, String typeId) {
        logger.logMessage(new BuildMessage1(sourceId, typeId, Status.NORMAL, new Date(), set));
    }
}

