/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.ideaCommandLine.runner;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import jetbrains.buildServer.ideaCommandLine.runner.JavaSdkUtil;
import jetbrains.buildServer.ideaSettings.AndroidSDK;
import jetbrains.buildServer.ideaSettings.IdeaJdk;
import jetbrains.buildServer.ideaSettings.IdeaSettings;
import jetbrains.buildServer.ideaSettings.JavaSdk;
import jetbrains.buildServer.ideaSettings.Library;
import jetbrains.buildServer.ideaSettings.PathVariableInfo;
import jetbrains.buildServer.ideaSettings.Sdk;
import jetbrains.buildServer.util.CollectionsUtil;
import jetbrains.buildServer.util.Converter;
import jetbrains.buildServer.util.FileUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IdeaCommandLineGenerateUtil {
    @NonNls
    private static final String SKIP_DEFAULT_MAC_JDK_PATTERNS = "skip.default.mac.jdk.patterns";
    private static final Logger LOG = Logger.getInstance((String)IdeaCommandLineGenerateUtil.class.getName());
    private static final String JRE = "jre/";
    public static final String OLD_MAC_JDK_MARK = "Classes";

    private IdeaCommandLineGenerateUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePathMacroTable(@NotNull IdeaSettings settings, @NotNull File pathMacroTable) throws IOException {
        if (settings == null) {
            IdeaCommandLineGenerateUtil.$$$reportNull$$$0(0);
        }
        if (pathMacroTable == null) {
            IdeaCommandLineGenerateUtil.$$$reportNull$$$0(1);
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(pathMacroTable);
            PrettyPrintWriter writer = new PrettyPrintWriter((Writer)fileWriter);
            writer.startNode("application");
            writer.startNode("component");
            writer.addAttribute("name", "PathMacrosImpl");
            Map pathVariables = settings.getPathVariables();
            for (String path : pathVariables.keySet()) {
                writer.startNode("macro");
                writer.addAttribute("name", path);
                writer.addAttribute("value", FileUtil.toSystemIndependentName((String)((PathVariableInfo)pathVariables.get(path)).getValue()));
                writer.endNode();
            }
            writer.endNode();
            writer.endNode();
        }
        catch (Throwable throwable) {
            FileUtil.close(fileWriter);
            throw throwable;
        }
        FileUtil.close((Closeable)fileWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeGlobalLibraryTable(@NotNull IdeaSettings settings, @NotNull File libraryTable) throws IOException {
        if (settings == null) {
            IdeaCommandLineGenerateUtil.$$$reportNull$$$0(2);
        }
        if (libraryTable == null) {
            IdeaCommandLineGenerateUtil.$$$reportNull$$$0(3);
        }
        try (FileWriter fileWriter = null;){
            fileWriter = new FileWriter(libraryTable);
            PrettyPrintWriter writer = new PrettyPrintWriter((Writer)fileWriter);
            writer.startNode("application");
            writer.startNode("component");
            writer.addAttribute("name", "libraryTable");
            Collection libraries = settings.getGlobalLibraries();
            for (Library library : libraries) {
                writer.startNode("library");
                writer.addAttribute("name", library.getName());
                writer.startNode("CLASSES");
                ArrayList<File> acceptedFiles = new ArrayList<File>();
                ArrayList<File> declinedFiles = new ArrayList<File>();
                File root = new File(library.getPathToLibrary());
                IdeaCommandLineGenerateUtil.processRelativeToPatterns(acceptedFiles, declinedFiles, root, root, library.getPatterns());
                IdeaCommandLineGenerateUtil.writePathsToFiles(writer, IdeaCommandLineGenerateUtil.toFileUrls(acceptedFiles));
                writer.endNode();
                writer.endNode();
            }
            writer.endNode();
            writer.endNode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeJdkTable(@NotNull IdeaSettings settings, @NotNull File jdkTable, @NotNull File checkoutDirectory, @NotNull Map<String, String> buildParameters) throws IOException {
        if (settings == null) {
            IdeaCommandLineGenerateUtil.$$$reportNull$$$0(4);
        }
        if (jdkTable == null) {
            IdeaCommandLineGenerateUtil.$$$reportNull$$$0(5);
        }
        if (checkoutDirectory == null) {
            IdeaCommandLineGenerateUtil.$$$reportNull$$$0(6);
        }
        if (buildParameters == null) {
            IdeaCommandLineGenerateUtil.$$$reportNull$$$0(7);
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(jdkTable);
            PrettyPrintWriter writer = new PrettyPrintWriter((Writer)fileWriter);
            writer.startNode("application");
            writer.startNode("component");
            writer.addAttribute("name", "ProjectJdkTable");
            ArrayList<Object> sdks = new ArrayList<Object>();
            for (Sdk sdk : settings.getSdks()) {
                sdks.add(sdk);
                if (!"Android SDK".equals(sdk.getSdkType())) continue;
                AndroidSDK androidSdk = (AndroidSDK)sdk;
                sdks.add(androidSdk.getJavaSdk());
            }
            for (Sdk sdk : sdks) {
                writer.startNode("jdk");
                writer.addAttribute("version", "2");
                writer.startNode("name");
                writer.addAttribute("value", sdk.getName());
                writer.endNode();
                writer.startNode("type");
                writer.addAttribute("value", sdk.getSdkType());
                writer.endNode();
                String homePath = sdk.getPathToJdk();
                writer.startNode("homePath");
                writer.addAttribute("value", FileUtil.toSystemIndependentName((String)homePath));
                writer.endNode();
                writer.startNode("roots");
                if (sdk instanceof JavaSdk) {
                    IdeaCommandLineGenerateUtil.writeExternalAnnotationsPaths(writer, (JavaSdk)sdk, checkoutDirectory);
                }
                if (sdk instanceof AndroidSDK) {
                    IdeaCommandLineGenerateUtil.writeExternalAnnotationsPaths(writer, ((AndroidSDK)sdk).getJavaSdk(), checkoutDirectory);
                }
                writer.startNode("classPath");
                writer.startNode("root");
                writer.addAttribute("type", "composite");
                ArrayList<File> acceptedFiles = new ArrayList<File>();
                ArrayList<String> urls = new ArrayList<String>(0);
                File sdkHome = new File(homePath);
                List patterns = sdk.getPatterns();
                if (sdkHome.isDirectory()) {
                    File rootToScan;
                    ArrayList declinedFiles = new ArrayList();
                    if (IdeaCommandLineGenerateUtil.isOldJdkOnMac(sdkHome)) {
                        rootToScan = sdkHome.getParentFile();
                        if (patterns.toString().indexOf(OLD_MAC_JDK_MARK) < 0 && !buildParameters.containsKey("system.skip.default.mac.jdk.patterns")) {
                            LOG.info("Appending default patterns to JDK path: ");
                            LOG.info("lib/*.jar");
                            LOG.info("../Classes/*.jar");
                            LOG.info("To avoid adding these patterns define system property 'skip.default.mac.jdk.patterns' in 'System properties and environment variables' screen.");
                            patterns.add("lib/*.jar");
                            patterns.add("../Classes/*.jar");
                        }
                    } else {
                        rootToScan = sdkHome;
                    }
                    if (sdk instanceof JavaSdk) {
                        List<String> classes = JavaSdkUtil.findJrtModules(sdkHome);
                        if (classes != null) {
                            urls.addAll(classes);
                        } else {
                            IdeaCommandLineGenerateUtil.processRelativeToPatterns(acceptedFiles, declinedFiles, sdkHome, rootToScan, patterns);
                        }
                    } else {
                        IdeaCommandLineGenerateUtil.processRelativeToPatterns(acceptedFiles, declinedFiles, sdkHome, rootToScan, patterns);
                    }
                    if (sdk instanceof IdeaJdk) {
                        IdeaJdk ideaJdk = (IdeaJdk)sdk;
                        File root = new File(ideaJdk.getPathToIdea());
                        IdeaCommandLineGenerateUtil.processRelativeToPatterns(acceptedFiles, declinedFiles, root, root, ideaJdk.getIdeaPatterns());
                    }
                } else {
                    for (String pattern : patterns) {
                        acceptedFiles.add(new File(pattern));
                    }
                }
                urls.addAll(IdeaCommandLineGenerateUtil.toFileUrls(acceptedFiles));
                IdeaCommandLineGenerateUtil.writePathsToFiles(writer, urls);
                writer.endNode();
                writer.endNode();
                writer.endNode();
                if (sdk instanceof AndroidSDK) {
                    AndroidSDK androidSdk = (AndroidSDK)sdk;
                    writer.startNode("additional");
                    writer.addAttribute("jdk", androidSdk.getJavaSdk().getName());
                    writer.addAttribute("sdk", "android-" + androidSdk.getApiLevel());
                    writer.endNode();
                }
                writer.endNode();
            }
            writer.endNode();
            writer.endNode();
        }
        catch (Throwable throwable) {
            FileUtil.close(fileWriter);
            throw throwable;
        }
        FileUtil.close((Closeable)fileWriter);
    }

    public static boolean isOldJdkOnMac(@NotNull File sdkHome) {
        if (sdkHome == null) {
            IdeaCommandLineGenerateUtil.$$$reportNull$$$0(8);
        }
        return SystemInfo.isMac && sdkHome.getParentFile() != null && new File(sdkHome.getParentFile(), OLD_MAC_JDK_MARK).exists();
    }

    private static void writeExternalAnnotationsPaths(PrettyPrintWriter writer, JavaSdk sdk, File checkoutDirectory) throws IOException {
        writer.startNode("annotationsPath");
        writer.startNode("root");
        writer.addAttribute("type", "composite");
        ArrayList<File> acceptedFiles = new ArrayList<File>();
        ArrayList<File> declinedFiles = new ArrayList<File>();
        IdeaCommandLineGenerateUtil.processRelativeToPatterns(acceptedFiles, declinedFiles, checkoutDirectory, checkoutDirectory, sdk.getExternalAnnotationsPatterns());
        IdeaCommandLineGenerateUtil.writePathsToFiles(writer, IdeaCommandLineGenerateUtil.toFileUrls(acceptedFiles));
        writer.endNode();
        writer.endNode();
    }

    private static List<String> toFileUrls(List<File> files) {
        return CollectionsUtil.convertCollection(files, (Converter)new Converter<String, File>(){

            public String createFrom(@NotNull File source) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                return IdeaCommandLineGenerateUtil.getUrlForLibraryRoot(source);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "jetbrains/buildServer/ideaCommandLine/runner/IdeaCommandLineGenerateUtil$1", "createFrom"));
            }
        });
    }

    private static void writePathsToFiles(PrettyPrintWriter writer, List<String> urls) {
        for (String url : urls) {
            writer.startNode("root");
            writer.addAttribute("type", "simple");
            writer.addAttribute("url", url);
            writer.endNode();
        }
    }

    public static void processRelativeToPatterns(@NotNull List<File> acceptedFiles, @NotNull List<File> declinedFiles, @NotNull File root, @NotNull File rootToScan, @NotNull List<String> patterns) throws IOException {
        if (acceptedFiles == null) {
            IdeaCommandLineGenerateUtil.$$$reportNull$$$0(9);
        }
        if (declinedFiles == null) {
            IdeaCommandLineGenerateUtil.$$$reportNull$$$0(10);
        }
        if (root == null) {
            IdeaCommandLineGenerateUtil.$$$reportNull$$$0(11);
        }
        if (rootToScan == null) {
            IdeaCommandLineGenerateUtil.$$$reportNull$$$0(12);
        }
        if (patterns == null) {
            IdeaCommandLineGenerateUtil.$$$reportNull$$$0(13);
        }
        for (String pattern : patterns) {
            File absFile;
            boolean accepted = true;
            if (pattern.startsWith("-")) {
                pattern = pattern.substring(1);
                accepted = false;
            }
            if (IdeaCommandLineGenerateUtil.isOldJdkOnMac(root)) {
                if (pattern.contains("/jre/")) {
                    pattern = pattern.replaceAll("/jre/", "/");
                } else if (pattern.startsWith(JRE)) {
                    pattern = pattern.substring(JRE.length());
                }
            }
            if ((absFile = new File(pattern)).exists()) {
                if (accepted) {
                    acceptedFiles.add(absFile);
                    continue;
                }
                declinedFiles.add(absFile);
                continue;
            }
            Pattern compiledPattern = Pattern.compile(FileUtil.convertAntToRegexp((String)FileUtil.toSystemIndependentName((String)pattern)));
            HashSet<String> processedPaths = new HashSet<String>();
            IdeaCommandLineGenerateUtil.collectFiles(root, rootToScan, rootToScan.getCanonicalFile(), compiledPattern, accepted ? acceptedFiles : declinedFiles, processedPaths);
        }
        acceptedFiles.removeAll(declinedFiles);
    }

    private static void collectFiles(@NotNull File root, @NotNull File rootToScan, @NotNull File primaryRoot, @NotNull Pattern pattern, @NotNull List<File> files, @NotNull Set<String> processedPaths) throws IOException {
        if (root == null) {
            IdeaCommandLineGenerateUtil.$$$reportNull$$$0(14);
        }
        if (rootToScan == null) {
            IdeaCommandLineGenerateUtil.$$$reportNull$$$0(15);
        }
        if (primaryRoot == null) {
            IdeaCommandLineGenerateUtil.$$$reportNull$$$0(16);
        }
        if (pattern == null) {
            IdeaCommandLineGenerateUtil.$$$reportNull$$$0(17);
        }
        if (files == null) {
            IdeaCommandLineGenerateUtil.$$$reportNull$$$0(18);
        }
        if (processedPaths == null) {
            IdeaCommandLineGenerateUtil.$$$reportNull$$$0(19);
        }
        if (IdeaCommandLineGenerateUtil.isAlreadyProcessed(rootToScan, processedPaths)) {
            return;
        }
        File[] dirs = rootToScan.listFiles();
        if (dirs == null) {
            return;
        }
        for (File dir : dirs) {
            if (dir.isFile()) {
                String path;
                String relativePath = FileUtil.getRelativePath((File)root, (File)dir);
                if (relativePath == null || !pattern.matcher(path = FileUtil.toSystemIndependentName((String)relativePath)).matches()) continue;
                files.add(dir);
                continue;
            }
            if (dir.getCanonicalPath().startsWith(primaryRoot.getAbsolutePath())) {
                IdeaCommandLineGenerateUtil.collectFiles(root, dir, primaryRoot, pattern, files, processedPaths);
                continue;
            }
            LOG.warn("Won't follow directory symbolic link " + dir.getAbsolutePath() + ", points to " + dir.getCanonicalPath() + ", not under " + primaryRoot.getAbsolutePath());
        }
    }

    private static boolean isAlreadyProcessed(@NotNull File rootToScan, @NotNull Set<String> processedPaths) throws IOException {
        String toScan;
        if (rootToScan == null) {
            IdeaCommandLineGenerateUtil.$$$reportNull$$$0(20);
        }
        if (processedPaths == null) {
            IdeaCommandLineGenerateUtil.$$$reportNull$$$0(21);
        }
        if (processedPaths.contains(toScan = rootToScan.getCanonicalPath())) {
            LOG.info("Already processed: " + toScan);
            return true;
        }
        processedPaths.add(toScan);
        return false;
    }

    private static String getUrlForLibraryRoot(@NotNull File libraryRoot) {
        String path;
        if (libraryRoot == null) {
            IdeaCommandLineGenerateUtil.$$$reportNull$$$0(22);
        }
        if ((path = FileUtil.toSystemIndependentName((String)libraryRoot.getAbsolutePath())).endsWith(".jar") || path.endsWith(".zip")) {
            return VirtualFileManager.constructUrl((String)"jar", (String)(path + "!/"));
        }
        return VirtualFileManager.constructUrl((String)"file", (String)path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMacroTable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryTable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkTable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkoutDirectory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildParameters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptedFiles";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declinedFiles";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 12: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootToScan";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryRoot";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedPaths";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryRoot";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/ideaCommandLine/runner/IdeaCommandLineGenerateUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writePathMacroTable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeGlobalLibraryTable";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "writeJdkTable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isOldJdkOnMac";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "processRelativeToPatterns";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "collectFiles";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "isAlreadyProcessed";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "getUrlForLibraryRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

