/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.ideaCommandLine.runner;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.RunBuildException;
import jetbrains.buildServer.agent.AgentRunningBuild;
import jetbrains.buildServer.agent.BuildProgressLogger;
import jetbrains.buildServer.agent.BuildRunnerContext;
import jetbrains.buildServer.agent.impl.IdeaCacheDirectoryProvider;
import jetbrains.buildServer.agent.javaDowser.JavaDowser;
import jetbrains.buildServer.agent.javaDowser.JavaInstallation;
import jetbrains.buildServer.agent.javaDowser.JavaVersion;
import jetbrains.buildServer.agent.runner.BuildServiceAdapter;
import jetbrains.buildServer.agent.runner.CannotBuildCommandLineException;
import jetbrains.buildServer.agent.runner.JavaCommandLineBuilder;
import jetbrains.buildServer.agent.runner.JavaRunnerUtil;
import jetbrains.buildServer.agent.runner.LogLastLinesProcessListener;
import jetbrains.buildServer.agent.runner.ProcessListener;
import jetbrains.buildServer.agent.runner.ProcessListenerAdapter;
import jetbrains.buildServer.agent.runner.ProgramCommandLine;
import jetbrains.buildServer.ideaCommandLine.runner.AgentIdeaSettings;
import jetbrains.buildServer.ideaCommandLine.runner.IdeaCommandLineGenerateUtil;
import jetbrains.buildServer.ideaSettings.AndroidSDK;
import jetbrains.buildServer.ideaSettings.IdeaSettings;
import jetbrains.buildServer.ideaSettings.JavaSdk;
import jetbrains.buildServer.ideaSettings.Sdk;
import jetbrains.buildServer.util.CollectionsUtil;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.IncludeExcludeRules;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.filters.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeaCommandLineService
extends BuildServiceAdapter {
    public static final String INCLUDE_EXCLUDE_PATTERNS_PARAM = "includeExclude.patterns";
    private static final String IDEA_INCLUDE_PATTERNS_PROP = "idea.include.patterns";
    private static final String IDEA_EXCLUDE_PATTERNS_PROP = "idea.exclude.patterns";
    private static final Logger LOG = Logger.getInstance((String)IdeaCommandLineService.class.getName());
    public static final String OUTPUT_KEY = "output";
    private static final String DISABLED_PLUGINS_FILE_NAME = "disabled_plugins.txt";
    private static final List<String> IDEA_JARS_NAME_PREFIXES = Arrays.asList("bootstrap.jar", "extensions.jar", "openapi.jar", "util.jar", "jdom.jar", "log4j.jar", "trove4j.jar", "jna.jar", "slf4j-log4j12");
    private final IdeaCacheDirectoryProvider myIdeaCachesDirectory;
    private final JavaDowser myJavaDowser;

    protected IdeaCommandLineService(@NotNull IdeaCacheDirectoryProvider ideaCachesDir, JavaDowser javaDowser) {
        if (ideaCachesDir == null) {
            IdeaCommandLineService.$$$reportNull$$$0(0);
        }
        this.myIdeaCachesDirectory = ideaCachesDir;
        this.myJavaDowser = javaDowser;
    }

    @NotNull
    protected abstract List<String> getProgramParameters() throws RunBuildException;

    @NotNull
    public ProgramCommandLine makeProgramCommandLine() throws RunBuildException {
        ProgramCommandLine programCommandLine;
        String runnerJavaHome = this.getRunnerJavaHome();
        Map<String, String> vmProps = this.getVMProperties(runnerJavaHome);
        vmProps.put("idea.build.agent.port", String.valueOf(this.getBuild().getAgentConfiguration().getOwnPort()));
        File buildTxtFile = new File(this.getIdeaTool(), "build.txt");
        ArrayList<String> requiredModules = new ArrayList<String>();
        requiredModules.addAll(Arrays.asList("jdk.compiler", "java.xml.bind", "java.se.ee"));
        try {
            String majorNum;
            int majorNumInt;
            String buildNumber = FileUtil.readText((File)buildTxtFile).trim();
            Pattern buildNumberPattern = Pattern.compile("[^-]+-([0-9]+)\\..*");
            Matcher matcher = buildNumberPattern.matcher(buildNumber);
            if (matcher.matches() && (majorNumInt = Integer.parseInt(majorNum = matcher.group(1))) >= 191) {
                requiredModules.removeAll(Arrays.asList("java.xml.bind", "java.se.ee"));
            }
        }
        catch (Exception e) {
            LOG.warnAndDebugDetails("Could not read IntelliJ IDEA build number from: " + buildTxtFile.getAbsolutePath(), (Throwable)e);
        }
        try {
            programCommandLine = new JavaCommandLineBuilder(this.myJavaDowser.getVersionProvider()).withJavaHome(runnerJavaHome, this.getRunnerContext().isVirtualContext()).withBaseDir(this.getCheckoutDirectory().getPath()).withBootClassPath(this.getBootclasspath()).withSystemProperties(vmProps).withEnvVariables(this.getEnvironmentVariables()).withJvmArgs(IdeaCommandLineService.filterOutJava8DeprecatedArgs(JavaRunnerUtil.extractJvmArgs((Map)this.getRunnerParameters()))).withClassPath(this.getClasspath(runnerJavaHome)).withModules(requiredModules).withMainClass(this.getMainClass()).withProgramArgs(this.getProgramParameters()).withWorkingDir(this.getWorkingDirectory().getAbsolutePath()).build();
        }
        catch (CannotBuildCommandLineException e) {
            throw new RunBuildException("Failed to start IntelliJ IDEA: " + e.getMessage());
        }
        if (programCommandLine == null) {
            IdeaCommandLineService.$$$reportNull$$$0(1);
        }
        return programCommandLine;
    }

    @NotNull
    private static List<String> filterOutJava8DeprecatedArgs(@NotNull List<String> jvmArgs) {
        if (jvmArgs == null) {
            IdeaCommandLineService.$$$reportNull$$$0(2);
        }
        List list = CollectionsUtil.filterCollection(jvmArgs, (Filter)new Filter<String>(){

            public boolean accept(@NotNull String arg) {
                String trim;
                if (arg == null) {
                    1.$$$reportNull$$$0(0);
                }
                return !(trim = arg.trim()).startsWith("-XX:MaxPermSize=") && !trim.startsWith("-XX:PermSize=");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "jetbrains/buildServer/ideaCommandLine/runner/IdeaCommandLineService$1", "accept"));
            }
        });
        if (list == null) {
            IdeaCommandLineService.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private String getRunnerJavaHome() throws RunBuildException {
        String javaHome = JavaRunnerUtil.findJavaHome((String)((String)this.getRunnerParameters().get("target.jdk.home")), (Map)this.getBuildParameters().getAllParameters(), (String)this.getCheckoutDirectory().getPath());
        if (javaHome == null) {
            throw new RunBuildException("Unable to find java executable");
        }
        JavaDowser.OperationResult result = this.myJavaDowser.examJavaInDirectory(new File(javaHome));
        if (result.failReason != null) {
            throw new RunBuildException(result.failReason);
        }
        assert (result.successResult != null);
        JavaVersion version = ((JavaInstallation)result.successResult).version;
        if (version.versionNumber < 8) {
            String jdk18 = IdeaCommandLineService.getJDK18(this.getEnvironmentVariables());
            if (jdk18 != null && this.myJavaDowser.examJavaInDirectory((File)new File((String)jdk18)).successResult != null) {
                javaHome = jdk18;
                this.getLogger().warning("Target JDK set to version older than Java 1.8. Will use '" + javaHome + "' instead. Consider using JDK 1.8 installation (env.JDK_18) in runner settings so Agent Requirement would be added.");
            } else {
                throw new RunBuildException(String.format("Java version '%s' found at '%s' is outdated: IntelliJ IDEA requires JDK 1.8+ to start. Use JDK 1.8 (env.JDK_18) in the Java settings of the runner for the Agent Requirement to be added.", version.versionText, javaHome), null, "BUILD_RUNNER_ERROR");
            }
        }
        String string = javaHome;
        if (string == null) {
            IdeaCommandLineService.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static String getJDK18(Map<String, String> env) {
        String val = env.get("JDK_18");
        if (val != null) {
            return val;
        }
        val = env.get("JDK_18_x64");
        return val;
    }

    @NotNull
    private Map<String, String> getVMProperties(@NotNull String runnerJavaHome) throws RunBuildException {
        IdeaSettings ideaSettings;
        if (runnerJavaHome == null) {
            IdeaCommandLineService.$$$reportNull$$$0(5);
        }
        Map params = JavaRunnerUtil.composeSystemProperties((AgentRunningBuild)this.getBuild(), (BuildRunnerContext)this.getRunnerContext());
        String ideaPath = this.getIdeaPath();
        params.put("idea.home.path", ideaPath);
        if (!this.getBuildParameters().getSystemProperties().containsKey("java.library.path")) {
            params.put("java.library.path", ideaPath + "/bin");
        }
        String configPath = new File(this.getBuildTempDirectory(), "config").getAbsolutePath();
        params.put("idea.config.path", configPath);
        params.put("java.awt.headless", "true");
        if (SystemInfo.isWindows) {
            params.put("swing.noxp", "true");
        }
        this.getLogger().progressMessage("Initialization");
        try {
            ideaSettings = AgentIdeaSettings.createFrom(this.getRunnerContext());
        }
        catch (Exception e) {
            RunBuildException ex = new RunBuildException(e.getMessage(), (Throwable)e);
            ex.setLogStacktrace(false);
            throw ex;
        }
        String systemPath = this.getIdeaSystemDirectoryPath(ideaSettings.getIpr());
        params.put("idea.system.path", systemPath);
        HashSet<Sdk> sdks = new HashSet<Sdk>(ideaSettings.getSdks());
        this.checkJDKs(sdks);
        if (sdks.isEmpty()) {
            JavaSdk defaultJdk = (JavaSdk)ideaSettings.addSdk("DefaultTeamCityJDK", "JavaSDK");
            defaultJdk.setPathToJdk(runnerJavaHome);
            defaultJdk.setExternalAnnotationsPatternsText(ideaPath + "/lib/jdkAnnotations.jar");
            ideaSettings.resolveSubstitutions(this.getRunnerContext().getParametersResolver());
        } else {
            this.fixExternalAnnotationsPaths(sdks, (String)this.getConfigParameters().get("teamcity.tool.idea"), ideaPath);
        }
        params.put("idea.plugins.path", ideaPath + File.separator + "plugins");
        String disabledPluginsPath = this.getDisabledPluginsPath();
        this.generateGlobalSettings(configPath, ideaSettings, disabledPluginsPath);
        params.put("idea.no.jdk.check", "true");
        params.put("idea.jars.nocopy", "true");
        params.put("newlocalvcs.disabled", "true");
        this.parseIncludeExcludePatterns(params);
        Map map = params;
        if (map == null) {
            IdeaCommandLineService.$$$reportNull$$$0(6);
        }
        return map;
    }

    @NotNull
    private String getIdeaSystemDirectoryPath(@NotNull String pathToIpr) {
        if (pathToIpr == null) {
            IdeaCommandLineService.$$$reportNull$$$0(7);
        }
        File cacheDir = this.myIdeaCachesDirectory.getBuildRunnerCacheDirectory(this.getRunnerContext());
        String dirName = "system_" + FileUtil.fixDirectoryName((String)pathToIpr);
        String string = new File(cacheDir, dirName).getAbsolutePath();
        if (string == null) {
            IdeaCommandLineService.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    private String getDisabledPluginsPath() {
        String disabledPluginsPath = null;
        String disabledPluginsContent = (String)this.getRunnerParameters().get("disabled.plugins.file");
        if (!StringUtil.isEmptyOrSpaces((String)disabledPluginsContent)) {
            File file = new File(this.getBuildTempDirectory(), this.getBuild().getBuildId() + "_disabled_plugins.txt");
            try {
                file.createNewFile();
                FileUtil.writeFile((File)file, (String)disabledPluginsContent, (String)"UTF-8");
                disabledPluginsPath = file.getAbsolutePath();
            }
            catch (IOException e) {
                this.getLogger().warning("Failed to create file: " + file.getAbsolutePath());
            }
        }
        return disabledPluginsPath;
    }

    private void parseIncludeExcludePatterns(Map<String, String> params) {
        String includeExcludePatterns = (String)this.getRunnerParameters().get(INCLUDE_EXCLUDE_PATTERNS_PARAM);
        if (includeExcludePatterns != null) {
            IncludeExcludeRules rules = new IncludeExcludeRules(includeExcludePatterns);
            StringBuilder include = new StringBuilder();
            StringBuilder exclude = new StringBuilder();
            for (IncludeExcludeRules.Rule rule : rules.getRules()) {
                if (rule.isInclude()) {
                    include.append(rule.getRule()).append(';');
                    continue;
                }
                exclude.append(rule.getRule()).append(';');
            }
            for (String arg : JavaRunnerUtil.extractJvmArgs((Map)this.getRunnerParameters())) {
                if (arg.indexOf(IDEA_INCLUDE_PATTERNS_PROP) != -1) {
                    include.setLength(0);
                }
                if (arg.indexOf(IDEA_EXCLUDE_PATTERNS_PROP) == -1) continue;
                exclude.setLength(0);
            }
            if (include.length() > 0) {
                params.put(IDEA_INCLUDE_PATTERNS_PROP, include.toString());
            }
            if (exclude.length() > 0) {
                params.put(IDEA_EXCLUDE_PATTERNS_PROP, exclude.toString());
            }
        }
    }

    private void checkJDKs(@NotNull Collection<? extends Sdk> jdks) {
        if (jdks == null) {
            IdeaCommandLineService.$$$reportNull$$$0(9);
        }
        BuildProgressLogger logger = this.getLogger();
        for (Sdk sdk : jdks) {
            if (!IdeaCommandLineService.isJavaSDK(sdk)) continue;
            String libraryPath = JavaRunnerUtil.findJavaHome((String)sdk.getPathToLibrary(), Collections.emptyMap(), null);
            if (libraryPath == null) {
                logger.error("Cannot resolve JDK path for '" + sdk.getName() + "'");
                continue;
            }
            File library = new File(libraryPath);
            boolean exists = library.isDirectory();
            if (library.getName().startsWith("jre")) {
                if (IdeaCommandLineService.isLightJDK(library)) {
                    sdk.addPattern("../lib/tools.jar");
                    continue;
                }
                logger.warning("This build runner requires JDK to operate.");
                logger.warning("Possibly, project JDK path for '" + sdk.getName() + "' points to JRE, not to JDK. ");
                logger.warning("To fix this, edit build configuration settings, and specify JDK path in the Build Runner section.");
                logger.warning("If you use env.JAVA_HOME as a pointer to JDK (default setting), ensure that buildAgent/conf/buildAgent.properties contains reference to JDK and not to JRE.");
                logger.warning("Used path: " + libraryPath + (exists ? "" : " (doesn't exist)"));
                continue;
            }
            if (exists) continue;
            logger.warning("JDK path for '" + sdk.getName() + "' :" + libraryPath + " doesn't exist.");
        }
    }

    private void fixExternalAnnotationsPaths(@NotNull Collection<Sdk> sdks, @Nullable String oldPath, @NotNull String newPath) {
        if (sdks == null) {
            IdeaCommandLineService.$$$reportNull$$$0(10);
        }
        if (newPath == null) {
            IdeaCommandLineService.$$$reportNull$$$0(11);
        }
        if (oldPath == null || oldPath.equals(newPath)) {
            return;
        }
        for (Sdk sdk : sdks) {
            if (sdk instanceof JavaSdk) {
                this.fixExternalAnnotationsPath((JavaSdk)sdk, oldPath, newPath);
                continue;
            }
            if (!(sdk instanceof AndroidSDK)) continue;
            this.fixExternalAnnotationsPath(((AndroidSDK)sdk).getJavaSdk(), oldPath, newPath);
        }
    }

    private void fixExternalAnnotationsPath(@NotNull JavaSdk sdk, @NotNull String oldPath, @NotNull String newPath) {
        String text;
        String replace;
        if (sdk == null) {
            IdeaCommandLineService.$$$reportNull$$$0(12);
        }
        if (oldPath == null) {
            IdeaCommandLineService.$$$reportNull$$$0(13);
        }
        if (newPath == null) {
            IdeaCommandLineService.$$$reportNull$$$0(14);
        }
        if ((replace = (text = sdk.getExternalAnnotationsPatternsText()).replace(oldPath, newPath)).equalsIgnoreCase(text)) {
            return;
        }
        sdk.setExternalAnnotationsPatternsText(replace);
    }

    public static boolean isJavaSDK(@NotNull Sdk jdk) {
        if (jdk == null) {
            IdeaCommandLineService.$$$reportNull$$$0(15);
        }
        return "JavaSDK".equals(jdk.getSdkType()) || "IDEA JDK".equals(jdk.getSdkType());
    }

    private static boolean isLightJDK(File homeDir) {
        File upperToolsJar = new File(homeDir.getAbsoluteFile(), "../lib/tools.jar");
        return upperToolsJar.exists() && upperToolsJar.isFile();
    }

    private void generateGlobalSettings(@NotNull String configPath, @NotNull IdeaSettings ideaSettings, @Nullable String disabledPluginsPath) {
        if (configPath == null) {
            IdeaCommandLineService.$$$reportNull$$$0(16);
        }
        if (ideaSettings == null) {
            IdeaCommandLineService.$$$reportNull$$$0(17);
        }
        try {
            File optionsDir = new File(configPath, "options");
            optionsDir.mkdirs();
            IdeaCommandLineGenerateUtil.writeJdkTable(ideaSettings, new File(optionsDir, "jdk.table.xml"), this.getCheckoutDirectory(), this.getBuildParameters().getAllParameters());
            IdeaCommandLineGenerateUtil.writeGlobalLibraryTable(ideaSettings, new File(optionsDir, "applicationLibraries.xml"));
            IdeaCommandLineGenerateUtil.writePathMacroTable(ideaSettings, new File(optionsDir, "path.macros.xml"));
            if (disabledPluginsPath != null) {
                FileUtil.copy((File)new File(disabledPluginsPath), (File)new File(configPath, DISABLED_PLUGINS_FILE_NAME));
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to create IntelliJ IDEA config", (Throwable)e);
            this.getLogger().warning("Failed to create IntelliJ IDEA configuration files:");
            this.getLogger().exception((Throwable)e);
        }
    }

    private String getBootclasspath() {
        String ideaPath = this.getIdeaPath();
        String bootJar = ideaPath + File.separator + "lib" + File.separator + "boot.jar";
        return new File(bootJar).exists() ? bootJar : null;
    }

    @NotNull
    protected File findIprFile() throws Exception {
        File workDir = this.getCheckoutDirectory();
        IdeaSettings settings = AgentIdeaSettings.createFrom(this.getRunnerContext());
        File file = FileUtil.resolvePath((File)workDir, (String)settings.getIpr());
        if (file == null) {
            IdeaCommandLineService.$$$reportNull$$$0(18);
        }
        return file;
    }

    private String getMainClass() {
        return "com.intellij.idea.Main";
    }

    private String getClasspath(@NotNull String runnerJavaHome) {
        if (runnerJavaHome == null) {
            IdeaCommandLineService.$$$reportNull$$$0(19);
        }
        return IdeaCommandLineService.buildClasspath(this.getIdeaPath(), runnerJavaHome);
    }

    public static String buildClasspath(String path2Idea, String jdkPath) {
        path2Idea = FileUtil.normalizeSeparator((String)path2Idea);
        jdkPath = FileUtil.normalizeSeparator((String)jdkPath);
        String libPath = FileUtil.normalizeSeparator((String)path2Idea) + File.separator + "lib" + File.separator;
        ArrayList<String> parts = new ArrayList<String>();
        File toolsJarPath = new File(jdkPath, "lib/tools.jar");
        if (!toolsJarPath.exists()) {
            File upperToolsJar = new File(new File(jdkPath).getAbsoluteFile().getParent(), "lib/tools.jar");
            if (upperToolsJar.exists()) {
                toolsJarPath = upperToolsJar;
            } else if (!new File(jdkPath, "jmods/jdk.compiler.jmod").exists()) {
                LOG.warn("Cannot find tools.jar, tried to find it inside: " + FileUtil.getCanonicalFile((File)new File(jdkPath, "lib")).getPath());
            }
        }
        parts.add(toolsJarPath.getPath());
        List<String> notFound = IdeaCommandLineService.fillClasspathWithIdeaJars(libPath, parts);
        for (String s : notFound) {
            LOG.warn("Cannot find jar with name prefix '" + s + "' in IntelliJ IDEA libs directory '" + libPath + "'");
        }
        return StringUtil.join(parts, (String)File.pathSeparator);
    }

    static List<String> fillClasspathWithIdeaJars(String libPath, List<String> classpath) {
        ArrayList<String> notFound = new ArrayList<String>();
        for (String prefix : IDEA_JARS_NAME_PREFIXES) {
            File found = IdeaCommandLineService.findJar(libPath, prefix);
            if (found != null) {
                classpath.add(libPath + found.getName());
                continue;
            }
            notFound.add(prefix);
        }
        return notFound;
    }

    private static File findJar(String root, final String prefix) {
        File[] found = new File(root).listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.exists() && pathname.getName().startsWith(prefix);
            }
        });
        return found == null ? null : found[0];
    }

    private String getIdeaPath() {
        return this.getIdeaTool().getPath();
    }

    @NotNull
    private File getIdeaTool() {
        File file = FileUtil.getCanonicalFile((File)new File(this.getToolPath("idea")));
        if (file == null) {
            IdeaCommandLineService.$$$reportNull$$$0(20);
        }
        return file;
    }

    @NotNull
    protected abstract String getRunnerName();

    @NotNull
    public List<ProcessListener> getListeners() {
        List<ProcessListener> list = Arrays.asList(new LogLastLinesProcessListener(this.getRunnerName(), this.getLogger(), 30), new ProcessListenerAdapter(){

            public void onStandardOutput(@NotNull String text) {
                if (text == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (StringUtil.isEmpty((String)text)) {
                    return;
                }
                IdeaCommandLineService.this.getLogger().progressMessage(text);
            }

            public void onErrorOutput(@NotNull String text) {
                if (text == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (StringUtil.isEmpty((String)text)) {
                    return;
                }
                IdeaCommandLineService.this.getLogger().warning(text);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "text";
                objectArray2[1] = "jetbrains/buildServer/ideaCommandLine/runner/IdeaCommandLineService$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onStandardOutput";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onErrorOutput";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (list == null) {
            IdeaCommandLineService.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 18: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 18: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaCachesDir";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/ideaCommandLine/runner/IdeaCommandLineService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmArgs";
                break;
            }
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerJavaHome";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToIpr";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdks";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/ideaCommandLine/runner/IdeaCommandLineService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "makeProgramCommandLine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutJava8DeprecatedArgs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerJavaHome";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVMProperties";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeaSystemDirectoryPath";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findIprFile";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeaTool";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getListeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 18: 
            case 20: 
            case 21: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "filterOutJava8DeprecatedArgs";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVMProperties";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIdeaSystemDirectoryPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkJDKs";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fixExternalAnnotationsPaths";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fixExternalAnnotationsPath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isJavaSDK";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "generateGlobalSettings";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getClasspath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 18: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

