/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.ideaCommandLine.runner;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import jetbrains.buildServer.ExecResult;
import jetbrains.buildServer.SimpleCommandLineProcessRunner;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.PropertiesUtil;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaSdkUtil {
    JavaSdkUtil() {
    }

    @Nullable
    static List<String> findJrtModules(@NotNull File file) {
        if (file == null) {
            JavaSdkUtil.$$$reportNull$$$0(0);
        }
        ArrayList<String> result = new ArrayList<String>();
        if (JavaSdkUtil.isExplodedModularRuntime(file.getPath())) {
            File modules = new File(file, "modules");
            File[] files = modules.listFiles();
            if (files != null) {
                for (File f : files) {
                    result.add(VirtualFileManager.constructUrl((String)"file", (String)JavaSdkUtil.getPath(f)));
                }
            }
        } else if (JavaSdkUtil.isModularRuntime(file)) {
            String jrtBaseUrl = "jrt://" + JavaSdkUtil.getPath(file) + "!/";
            List<String> modules = JavaSdkUtil.readModulesFromReleaseFile(file);
            if (modules != null) {
                for (String module : modules) {
                    result.add(jrtBaseUrl + module);
                }
            } else {
                GeneralCommandLine cmd = new GeneralCommandLine();
                cmd.setWorkingDirectory(file);
                cmd.setExePath(new File(file, SystemInfo.isWindows ? "bin/java.exe" : "bin/java").getAbsolutePath());
                cmd.addParameter("--list-modules");
                ExecResult exec = SimpleCommandLineProcessRunner.runCommand((GeneralCommandLine)cmd, null);
                List lines = StringUtil.split((String)exec.getStdout());
                for (String line : lines) {
                    int at = line.indexOf("@");
                    String module = at > 0 ? line.substring(0, at) : line;
                    result.add(jrtBaseUrl + module);
                }
            }
        } else {
            return null;
        }
        Collections.sort(result);
        return result;
    }

    private static String getPath(File jarFile) {
        return FileUtil.toSystemIndependentName((String)jarFile.getAbsolutePath());
    }

    @Nullable
    private static List<String> readModulesFromReleaseFile(@NotNull File jrtBaseDir) {
        File releaseFile;
        if (jrtBaseDir == null) {
            JavaSdkUtil.$$$reportNull$$$0(1);
        }
        if ((releaseFile = new File(jrtBaseDir, "release")).isFile()) {
            try {
                Properties p = PropertiesUtil.loadProperties((File)releaseFile);
                String modules = p.getProperty("MODULES");
                if (modules != null) {
                    return StringUtil.split((String)StringUtil.unquoteString((String)modules), (String)" ");
                }
            }
            catch (IOException iOException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean isModularRuntime(@NotNull File homePath) {
        if (homePath == null) {
            JavaSdkUtil.$$$reportNull$$$0(2);
        }
        return new File(homePath, "lib/jrt-fs.jar").isFile() || JavaSdkUtil.isExplodedModularRuntime(homePath.getPath());
    }

    private static boolean isExplodedModularRuntime(@NotNull String homePath) {
        if (homePath == null) {
            JavaSdkUtil.$$$reportNull$$$0(3);
        }
        return new File(homePath, "modules/java.base").isDirectory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jrtBaseDir";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/ideaCommandLine/runner/JavaSdkUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findJrtModules";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "readModulesFromReleaseFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isModularRuntime";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isExplodedModularRuntime";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

