/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.parameters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import jetbrains.buildServer.messages.XStreamHolder;
import jetbrains.buildServer.serverSide.crypt.EncryptUtil;
import jetbrains.buildServer.util.PasswordReplacer;
import jetbrains.buildServer.xstream.XStreamWrapper;
import org.jetbrains.annotations.NotNull;

public class PasswordParametersFilterCore {
    public static final String VALUES_LIST_CONFIG_PARAMETER_NAME = "teamcity.agent.internal.passwords.values";
    public static final String REPLACEMENT = "*******";
    private static final Pattern DO_NOT_MATCH = Pattern.compile("");

    @NotNull
    public static String packParameters(@NotNull Set<String> passwords) {
        if (passwords == null) {
            PasswordParametersFilterCore.$$$reportNull$$$0(0);
        }
        String string = EncryptUtil.scramble((String)XStreamWrapper.serializeObject(new ArrayList<String>(passwords), (XStreamHolder)PasswordParametersFilterCore.getHolder()));
        if (string == null) {
            PasswordParametersFilterCore.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static XStreamHolder getHolder() {
        XStreamHolder xStreamHolder = new XStreamHolder();
        if (xStreamHolder == null) {
            PasswordParametersFilterCore.$$$reportNull$$$0(2);
        }
        return xStreamHolder;
    }

    @NotNull
    public static Set<String> unpackParameters(@NotNull String text) {
        if (text == null) {
            PasswordParametersFilterCore.$$$reportNull$$$0(3);
        }
        if (EncryptUtil.isScrambled((String)text)) {
            text = EncryptUtil.unscramble((String)text);
        }
        List strings = (List)XStreamWrapper.deserializeObject((String)text, (XStreamHolder)PasswordParametersFilterCore.getHolder());
        assert (strings != null);
        TreeSet<String> treeSet = new TreeSet<String>(strings);
        if (treeSet == null) {
            PasswordParametersFilterCore.$$$reportNull$$$0(4);
        }
        return treeSet;
    }

    @NotNull
    public static PasswordReplacer createPasswordReplacer(@NotNull Set<String> passwords) {
        if (passwords == null) {
            PasswordParametersFilterCore.$$$reportNull$$$0(5);
        }
        final Set<String> actualPasswords = Collections.synchronizedSet(new HashSet<String>(passwords));
        PasswordReplacer passwordReplacer = new PasswordReplacer(){
            private volatile Pattern myPattern;

            @NotNull
            public String replacePasswords(@NotNull String text) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (actualPasswords.isEmpty()) {
                    String string = text;
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                Pattern pattern = this.getPattern();
                if (pattern == DO_NOT_MATCH) {
                    String string = text;
                    if (string == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return string;
                }
                String string = pattern.matcher(text).replaceAll(PasswordParametersFilterCore.REPLACEMENT);
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            private Pattern getPattern() {
                if (this.myPattern != null) {
                    Pattern pattern = this.myPattern;
                    if (pattern == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return pattern;
                }
                Set set = actualPasswords;
                synchronized (set) {
                    this.myPattern = PasswordParametersFilterCore.createPasswordsPattern(actualPasswords);
                }
                Pattern pattern = this.myPattern;
                if (pattern == null) {
                    1.$$$reportNull$$$0(5);
                }
                return pattern;
            }

            public boolean hasPasswords() {
                return !actualPasswords.isEmpty();
            }

            @NotNull
            public Set<String> getPasswords() {
                Set<String> set = Collections.unmodifiableSet(actualPasswords);
                if (set == null) {
                    1.$$$reportNull$$$0(6);
                }
                return set;
            }

            public boolean addPassword(@NotNull String password) {
                if (password == null) {
                    1.$$$reportNull$$$0(7);
                }
                try {
                    boolean bl = actualPasswords.add(password);
                    return bl;
                }
                finally {
                    this.myPattern = null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "jetbrains/buildServer/parameters/PasswordParametersFilterCore$1";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "password";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "jetbrains/buildServer/parameters/PasswordParametersFilterCore$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "replacePasswords";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPattern";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPasswords";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "replacePasswords";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "addPassword";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (passwordReplacer == null) {
            PasswordParametersFilterCore.$$$reportNull$$$0(6);
        }
        return passwordReplacer;
    }

    @NotNull
    private static Pattern createPasswordsPattern(@NotNull Set<String> passwords) {
        if (passwords == null) {
            PasswordParametersFilterCore.$$$reportNull$$$0(7);
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> sorted = new ArrayList<String>();
        for (String pwd : passwords) {
            String[] lines;
            String trimmed;
            if (pwd == null || (trimmed = pwd.trim()).length() <= 2 || REPLACEMENT.contains(pwd)) continue;
            sorted.add(pwd);
            if (trimmed.length() != pwd.length()) {
                sorted.add(trimmed);
            }
            if ((lines = pwd.split("[\r\n]+")).length <= 1) continue;
            for (String l : lines) {
                if (l.trim().length() < 8) continue;
                sorted.add(l.trim());
            }
        }
        if (sorted.isEmpty()) {
            Pattern pattern = DO_NOT_MATCH;
            if (pattern == null) {
                PasswordParametersFilterCore.$$$reportNull$$$0(8);
            }
            return pattern;
        }
        Collections.sort(sorted, new Comparator<String>(){

            @Override
            public int compare(String left, String right) {
                return right.length() - left.length();
            }
        });
        for (String v : sorted) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append("(").append(Pattern.quote(v).replaceAll("%%", "\\\\E%{1,2}\\\\Q")).append(")");
        }
        Pattern pattern = Pattern.compile(sb.toString());
        if (pattern == null) {
            PasswordParametersFilterCore.$$$reportNull$$$0(9);
        }
        return pattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "passwords";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/parameters/PasswordParametersFilterCore";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/parameters/PasswordParametersFilterCore";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "packParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHolder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "unpackParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPasswordReplacer";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createPasswordsPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "packParameters";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unpackParameters";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPasswordReplacer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPasswordsPattern";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

