/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.plugins;

import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import jetbrains.buildServer.plugins.NotLoadedPlugin;
import jetbrains.buildServer.plugins.PluginData;
import jetbrains.buildServer.plugins.ProcessPlugins;
import jetbrains.buildServer.plugins.bean.PluginInfo;
import jetbrains.buildServer.plugins.classLoaders.PluginClassLoadingInfo;
import jetbrains.buildServer.plugins.classLoaders.SharedClassloaderFactory;
import jetbrains.buildServer.plugins.classLoaders.StandaloneClassloaderFactory;
import jetbrains.buildServer.plugins.classLoaders.TeamCityClassLoader;
import jetbrains.buildServer.util.CaseInsensitiveStringComparator;
import jetbrains.buildServer.util.CollectionsUtil;
import jetbrains.buildServer.util.Converter;
import jetbrains.buildServer.util.ThreadUtil;
import jetbrains.buildServer.util.executors.ExecutorsFactory;
import jetbrains.buildServer.util.filters.Filter;
import org.jetbrains.annotations.NotNull;

public class PluginsCollection {
    private static final Logger LOG = Logger.getInstance((String)PluginsCollection.class.getName());
    private final List<PluginData> myTopoOrderedPlugins;
    private final List<NotLoadedPlugin> myNotLoadedPlugins;

    public PluginsCollection(@NotNull List<PluginData> topoOrderedPlugins, @NotNull List<NotLoadedPlugin> notLoadedPlugins) {
        if (topoOrderedPlugins == null) {
            PluginsCollection.$$$reportNull$$$0(0);
        }
        if (notLoadedPlugins == null) {
            PluginsCollection.$$$reportNull$$$0(1);
        }
        this.myTopoOrderedPlugins = topoOrderedPlugins;
        this.myNotLoadedPlugins = notLoadedPlugins;
    }

    @NotNull
    public List<NotLoadedPlugin> getNotLoadedPlugins() {
        List<NotLoadedPlugin> list = Collections.unmodifiableList(this.myNotLoadedPlugins);
        if (list == null) {
            PluginsCollection.$$$reportNull$$$0(2);
        }
        return list;
    }

    public Collection<PluginData> getPluginDatas() {
        return Collections.unmodifiableList(this.myTopoOrderedPlugins);
    }

    public void foreachPlugins(@NotNull ProcessPlugins processor) {
        if (processor == null) {
            PluginsCollection.$$$reportNull$$$0(3);
        }
        for (PluginData plugin : this.myTopoOrderedPlugins) {
            processor.visitPlugin(plugin);
        }
    }

    public void foreachLoadedPlugins(@NotNull ProcessPlugins processor) {
        if (processor == null) {
            PluginsCollection.$$$reportNull$$$0(4);
        }
        for (PluginData plugin : this.myTopoOrderedPlugins) {
            if (!plugin.hasClassloader()) continue;
            processor.visitPlugin(plugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void foreachLoadedPluginsAsync(final @NotNull ProcessPlugins processor, int numThreads) {
        if (processor == null) {
            PluginsCollection.$$$reportNull$$$0(5);
        }
        ArrayList<PluginData> independent = new ArrayList<PluginData>();
        ArrayList<PluginData> rest = new ArrayList<PluginData>();
        for (PluginData plugin : this.myTopoOrderedPlugins) {
            if (!plugin.hasClassloader()) continue;
            if (plugin.getParents().isEmpty()) {
                independent.add(plugin);
                continue;
            }
            rest.add(plugin);
        }
        final ArrayBlockingQueue<PluginData> queue = new ArrayBlockingQueue<PluginData>(Math.max(10, independent.size()));
        queue.addAll(independent);
        String prefix = "Processing plugins";
        ExecutorService executorService = ExecutorsFactory.newFixedDaemonExecutor((String)"Processing plugins", (int)numThreads);
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    while (!queue.isEmpty()) {
                        PluginData next = (PluginData)queue.poll();
                        if (next == null) continue;
                        processor.visitPlugin(next);
                    }
                }
            };
            ArrayList tasks = new ArrayList();
            for (int i = 0; i < numThreads; ++i) {
                tasks.add(executorService.submit(runnable));
            }
            ThreadUtil.waitForTasks(tasks);
        }
        finally {
            ThreadUtil.shutdownGracefully((ExecutorService)executorService, (String)"Processing plugins");
        }
        for (PluginData plugin : rest) {
            processor.visitPlugin(plugin);
        }
    }

    public Collection<PluginInfo> getDependencies(final PluginInfo plugin) {
        PluginData found = (PluginData)CollectionsUtil.findFirst(this.myTopoOrderedPlugins, (Filter)new Filter<PluginData>(){

            public boolean accept(@NotNull PluginData data) {
                if (data == null) {
                    2.$$$reportNull$$$0(0);
                }
                return data.getPluginInfo().equals(plugin);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/plugins/PluginsCollection$2", "accept"));
            }
        });
        if (found == null) {
            return Collections.emptyList();
        }
        return CollectionsUtil.convertCollection(found.getParents(), (Converter)new Converter<PluginInfo, PluginData>(){

            public PluginInfo createFrom(@NotNull PluginData source) {
                if (source == null) {
                    3.$$$reportNull$$$0(0);
                }
                return source.getPluginInfo();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "jetbrains/buildServer/plugins/PluginsCollection$3", "createFrom"));
            }
        });
    }

    public void createClassloaders(@NotNull StandaloneClassloaderFactory standaloneFactory, @NotNull SharedClassloaderFactory sharedFactory) {
        if (standaloneFactory == null) {
            PluginsCollection.$$$reportNull$$$0(6);
        }
        if (sharedFactory == null) {
            PluginsCollection.$$$reportNull$$$0(7);
        }
        ArrayList<PluginData> shared = new ArrayList<PluginData>();
        ArrayList<PluginData> standalone = new ArrayList<PluginData>();
        for (PluginData plugin : this.myTopoOrderedPlugins) {
            PluginInfo info = plugin.getPluginInfo();
            PluginClassLoadingInfo cli = info.getClassloadingInfo();
            if (cli == null) {
                shared.add(plugin);
                continue;
            }
            if (plugin.getPluginInfo().getDependencies().isEmpty() && !cli.useStandaloneClassloader()) {
                shared.add(plugin);
                continue;
            }
            standalone.add(plugin);
        }
        TeamCityClassLoader sharedClassloader = this.createSharedClassloader(sharedFactory, shared);
        this.createStandaloneClassloaders(standaloneFactory, standalone, sharedClassloader);
    }

    private void createStandaloneClassloaders(@NotNull StandaloneClassloaderFactory factory, @NotNull List<PluginData> ordered, @NotNull TeamCityClassLoader shared) {
        if (factory == null) {
            PluginsCollection.$$$reportNull$$$0(8);
        }
        if (ordered == null) {
            PluginsCollection.$$$reportNull$$$0(9);
        }
        if (shared == null) {
            PluginsCollection.$$$reportNull$$$0(10);
        }
        TreeSet<String> names = new TreeSet<String>((Comparator<String>)CaseInsensitiveStringComparator.INSTANCE);
        for (PluginData plugin : ordered) {
            PluginInfo info = plugin.getPluginInfo();
            PluginClassLoadingInfo cli = info.getClassloadingInfo();
            String name = info.getPluginName();
            assert (cli != null);
            names.add(name);
            LOG.debug("Create standalone classloader for plugin " + name);
            LinkedList<TeamCityClassLoader> parentClassloaders = new LinkedList<TeamCityClassLoader>();
            boolean withShared = false;
            for (PluginData parent : plugin.getParents()) {
                TeamCityClassLoader cl = parent.getClassloader();
                assert (cl != null);
                if (cl.equals(shared)) {
                    withShared = true;
                    continue;
                }
                if (parentClassloaders.contains(cl)) continue;
                parentClassloaders.add(cl);
            }
            if (withShared) {
                parentClassloaders.add(0, shared);
            }
            TeamCityClassLoader classloader = factory.createClassloader(cli, parentClassloaders);
            plugin.setClassloader(classloader);
        }
        if (names.isEmpty()) {
            LOG.info("No plugins were loaded with standalone classloaders");
        } else {
            LOG.info("Load standalone classloaders for " + names.size() + " plugins " + names);
        }
    }

    @NotNull
    private TeamCityClassLoader createSharedClassloader(@NotNull SharedClassloaderFactory factory, @NotNull List<PluginData> ordered) {
        if (factory == null) {
            PluginsCollection.$$$reportNull$$$0(11);
        }
        if (ordered == null) {
            PluginsCollection.$$$reportNull$$$0(12);
        }
        ArrayList<PluginClassLoadingInfo> infos = new ArrayList<PluginClassLoadingInfo>();
        TreeSet<String> names = new TreeSet<String>((Comparator<String>)CaseInsensitiveStringComparator.INSTANCE);
        for (PluginData plugin : ordered) {
            PluginInfo info = plugin.getPluginInfo();
            PluginClassLoadingInfo cli = info.getClassloadingInfo();
            String name = info.getPluginName();
            if (cli != null) {
                infos.add(cli);
                names.add(name);
                continue;
            }
            LOG.debug("Plugin " + name + " has no classloading info. Will use shared classloader.");
        }
        LOG.info("Load shared classloader for " + names.size() + " plugins " + names);
        TeamCityClassLoader loader = factory.createClassloader(infos);
        for (PluginData pluginData : ordered) {
            pluginData.setClassloader(loader);
        }
        TeamCityClassLoader teamCityClassLoader = loader;
        if (teamCityClassLoader == null) {
            PluginsCollection.$$$reportNull$$$0(13);
        }
        return teamCityClassLoader;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topoOrderedPlugins";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notLoadedPlugins";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/plugins/PluginsCollection";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "standaloneFactory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedFactory";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ordered";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shared";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/plugins/PluginsCollection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotLoadedPlugins";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createSharedClassloader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "foreachPlugins";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "foreachLoadedPlugins";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "foreachLoadedPluginsAsync";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createClassloaders";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createStandaloneClassloaders";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createSharedClassloader";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

