/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.plugins;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.dataStructures.MultiMapToList;
import jetbrains.buildServer.plugins.NotLoadedPlugin;
import jetbrains.buildServer.plugins.PluginData;
import jetbrains.buildServer.plugins.PluginDisabledInfoProvider;
import jetbrains.buildServer.plugins.PluginVersionComparator;
import jetbrains.buildServer.plugins.PluginsCollection;
import jetbrains.buildServer.plugins.ReloadablePlugins;
import jetbrains.buildServer.plugins.bean.IncorrectPluginInfo;
import jetbrains.buildServer.plugins.bean.MissingPluginInfo;
import jetbrains.buildServer.plugins.bean.PluginDependencyInfo;
import jetbrains.buildServer.plugins.bean.PluginInfo;
import jetbrains.buildServer.plugins.classLoaders.PluginClassLoadingInfo;
import jetbrains.buildServer.plugins.loaders.PluginInfosBuilder;
import jetbrains.buildServer.util.CollectionsUtil;
import jetbrains.buildServer.util.Converter;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.graph.DAG;
import jetbrains.buildServer.util.graph.DAGUtil;
import jetbrains.buildServer.util.graph.DAGs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginsLookupCollector
implements PluginInfosBuilder {
    @NotNull
    private static final Logger LOG = Logger.getInstance((String)PluginsLookupCollector.class.getName());
    @NotNull
    private final MultiMapToList<String, PluginInfo> myPluginInfoMap;
    @NotNull
    private final ReloadablePlugins myReloadablePlugins;
    @NotNull
    private final List<PluginInfoFilter> myPluginInfoFiltersChain;
    private static final NotNullFunction<PluginInfo, String> PLUGIN_INFO_TO_NAME = new NotNullFunction<PluginInfo, String>(){

        @NotNull
        public String fun(PluginInfo pluginInfo) {
            String string = pluginInfo.getPluginName();
            if (string == null) {
                4.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/plugins/PluginsLookupCollector$4", "fun"));
        }
    };

    PluginsLookupCollector(@NotNull PluginVersionComparator comparator, @NotNull PluginDisabledInfoProvider pluginDisabledInfoProvider) {
        if (comparator == null) {
            PluginsLookupCollector.$$$reportNull$$$0(0);
        }
        if (pluginDisabledInfoProvider == null) {
            PluginsLookupCollector.$$$reportNull$$$0(1);
        }
        this(comparator, pluginDisabledInfoProvider, new ReloadablePlugins(){

            @Override
            public String canUnloadPluginInRuntime(@NotNull PluginInfo pluginInfo) {
                if (pluginInfo == null) {
                    2.$$$reportNull$$$0(0);
                }
                return "forbidden";
            }

            @Override
            @Nullable
            public String canReloadPluginInRuntime(@NotNull PluginInfo from, @NotNull PluginInfo to) {
                if (from == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (to == null) {
                    2.$$$reportNull$$$0(2);
                }
                return null;
            }

            @Override
            public String canLoadPluginInRuntime(@NotNull PluginInfo pluginInfo) {
                if (pluginInfo == null) {
                    2.$$$reportNull$$$0(3);
                }
                return null;
            }

            @Override
            public boolean allowLoadNotReloadable() {
                return false;
            }

            @Override
            public boolean shouldLoadPluginAsUnloadable(@NotNull PluginInfo pluginInfo) {
                if (pluginInfo == null) {
                    2.$$$reportNull$$$0(4);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginInfo";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "from";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "to";
                        break;
                    }
                }
                objectArray2[1] = "jetbrains/buildServer/plugins/PluginsLookupCollector$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "canUnloadPluginInRuntime";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "canReloadPluginInRuntime";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "canLoadPluginInRuntime";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "shouldLoadPluginAsUnloadable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public PluginsLookupCollector(@NotNull PluginVersionComparator comparator, @NotNull PluginDisabledInfoProvider pluginDisabledInfoProvider, @NotNull ReloadablePlugins reloadablePlugins) {
        if (comparator == null) {
            PluginsLookupCollector.$$$reportNull$$$0(2);
        }
        if (pluginDisabledInfoProvider == null) {
            PluginsLookupCollector.$$$reportNull$$$0(3);
        }
        if (reloadablePlugins == null) {
            PluginsLookupCollector.$$$reportNull$$$0(4);
        }
        this.myPluginInfoMap = new MultiMapToList<String, PluginInfo>(){

            @NotNull
            protected List<PluginInfo> createEmptyCollection() {
                LinkedList<PluginInfo> linkedList = new LinkedList<PluginInfo>();
                if (linkedList == null) {
                    1.$$$reportNull$$$0(0);
                }
                return linkedList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/plugins/PluginsLookupCollector$1", "createEmptyCollection"));
            }
        };
        this.myReloadablePlugins = reloadablePlugins;
        this.myPluginInfoFiltersChain = Arrays.asList(new AbstractPluginInfoFilter(new AlreadyLoadedSimplePluginInfoFilterFactory()), new AbstractPluginInfoFilter(new IncorrectSimplePluginInfoFilterFactory()), new AbstractPluginInfoFilter(new DisabledSimplePluginInfoFilterFactory(pluginDisabledInfoProvider)), new VersionPluginInfoFilter(comparator), new CyclicDependenciesPluginInfoFilter(), new FullDependenciesGraphPluginInfoFilter());
    }

    @Override
    public void pluginInfoFound(@NotNull PluginInfo pluginInfo) {
        if (pluginInfo == null) {
            PluginsLookupCollector.$$$reportNull$$$0(5);
        }
        String actualPluginName = pluginInfo.getPluginName();
        LOG.debug("Found plugin " + actualPluginName);
        this.myPluginInfoMap.add((Object)actualPluginName, (Object)pluginInfo);
    }

    @NotNull
    public PluginsCollection toPluginsCollection() {
        PluginsCollection pluginsCollection = this.getPluginsCollection(this.myPluginInfoMap, Collections.emptyList(), true);
        if (pluginsCollection == null) {
            PluginsLookupCollector.$$$reportNull$$$0(6);
        }
        return pluginsCollection;
    }

    @NotNull
    PluginsCollection toPluginsCollection(@NotNull Collection<PluginInfo> plugins, @NotNull Collection<PluginData> loadedPlugins, boolean logNotLoadable) {
        if (plugins == null) {
            PluginsLookupCollector.$$$reportNull$$$0(7);
        }
        if (loadedPlugins == null) {
            PluginsLookupCollector.$$$reportNull$$$0(8);
        }
        MultiMapToList map = new MultiMapToList();
        for (PluginInfo plugin : plugins) {
            map.add((Object)plugin.getPluginName(), (Object)plugin);
        }
        PluginsCollection pluginsCollection = this.getPluginsCollection((MultiMapToList<String, PluginInfo>)map, loadedPlugins, logNotLoadable);
        if (pluginsCollection == null) {
            PluginsLookupCollector.$$$reportNull$$$0(9);
        }
        return pluginsCollection;
    }

    @NotNull
    private PluginsCollection getPluginsCollection(MultiMapToList<String, PluginInfo> pluginsToLoad, Collection<PluginData> alreadyLoadedPlugins, boolean logNotLoadable) {
        ArrayList<NotLoadedPlugin> notLoadable = new ArrayList<NotLoadedPlugin>();
        ArrayList<PluginInfo> allInfos = new ArrayList<PluginInfo>(pluginsToLoad.size());
        for (List pluginInfos : pluginsToLoad.values()) {
            allInfos.addAll(pluginInfos);
        }
        List<PluginInfo> filteredTopoordered = this.filterPlugins(alreadyLoadedPlugins, notLoadable, allInfos);
        List<PluginData> toLoad = this.createPluginDatas(filteredTopoordered);
        this.fillParents(toLoad, alreadyLoadedPlugins);
        if (!notLoadable.isEmpty() && logNotLoadable) {
            StringBuilder sb = new StringBuilder(notLoadable.size()).append("The following plugins will not be loaded:\n");
            for (NotLoadedPlugin notLoadedPlugin : notLoadable) {
                sb.append(PluginsLookupCollector.presentPlugin(notLoadedPlugin.getPlugin())).append(" - ").append(notLoadedPlugin.getReason()).append('\n');
            }
            sb.delete(sb.length() - 1, sb.length());
            LOG.warn(sb.toString());
            for (PluginInfo info : filteredTopoordered) {
                PluginClassLoadingInfo cli = info.getClassloadingInfo();
                if (info.getDependencies().isEmpty() || cli == null || cli.useStandaloneClassloader()) continue;
                LOG.warn("Plugin " + info.getPluginName() + "@[" + info.getPluginRoot() + "] has dependencies but not uses standalone classloader. Standalone classloader will be enforced. Update plugin descriptor.");
            }
        }
        PluginsCollection pluginsCollection = new PluginsCollection(toLoad, notLoadable);
        if (pluginsCollection == null) {
            PluginsLookupCollector.$$$reportNull$$$0(10);
        }
        return pluginsCollection;
    }

    @NotNull
    private List<PluginData> createPluginDatas(@NotNull List<PluginInfo> filteredTopoordered) {
        if (filteredTopoordered == null) {
            PluginsLookupCollector.$$$reportNull$$$0(11);
        }
        ArrayList<PluginData> toLoad = new ArrayList<PluginData>(filteredTopoordered.size());
        for (PluginInfo info : filteredTopoordered) {
            toLoad.add(this.createPluginData(info));
        }
        ArrayList<PluginData> arrayList = toLoad;
        if (arrayList == null) {
            PluginsLookupCollector.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private void fillParents(@NotNull List<PluginData> filteredTopoordered, @NotNull Collection<PluginData> alreadyLoadedPlugins) {
        if (filteredTopoordered == null) {
            PluginsLookupCollector.$$$reportNull$$$0(13);
        }
        if (alreadyLoadedPlugins == null) {
            PluginsLookupCollector.$$$reportNull$$$0(14);
        }
        HashMap<String, PluginData> parentsMap = new HashMap<String, PluginData>();
        for (PluginData loadedPlugin : alreadyLoadedPlugins) {
            parentsMap.put(loadedPlugin.getPluginName(), loadedPlugin);
        }
        for (PluginData pluginData : filteredTopoordered) {
            this.fillParents(parentsMap, pluginData);
            parentsMap.put(pluginData.getPluginName(), pluginData);
        }
    }

    @NotNull
    List<PluginInfo> filterPlugins(@NotNull Collection<PluginData> alreadyLoadedPlugins, @NotNull List<NotLoadedPlugin> notLoadable, @NotNull List<PluginInfo> infos) {
        if (alreadyLoadedPlugins == null) {
            PluginsLookupCollector.$$$reportNull$$$0(15);
        }
        if (notLoadable == null) {
            PluginsLookupCollector.$$$reportNull$$$0(16);
        }
        if (infos == null) {
            PluginsLookupCollector.$$$reportNull$$$0(17);
        }
        for (PluginInfoFilter infoFilter : this.myPluginInfoFiltersChain) {
            Pair<List<PluginInfo>, List<NotLoadedPlugin>> res = infoFilter.processPlugins(infos, notLoadable, alreadyLoadedPlugins);
            infos = (List)res.getFirst();
            notLoadable.addAll((Collection)res.getSecond());
            if (!infos.isEmpty()) continue;
            break;
        }
        List list = infos;
        if (list == null) {
            PluginsLookupCollector.$$$reportNull$$$0(18);
        }
        return list;
    }

    private void fillParents(@NotNull Map<String, PluginData> pluginsMap, @NotNull PluginData pluginData) {
        if (pluginsMap == null) {
            PluginsLookupCollector.$$$reportNull$$$0(19);
        }
        if (pluginData == null) {
            PluginsLookupCollector.$$$reportNull$$$0(20);
        }
        ArrayList<PluginData> parents = new ArrayList<PluginData>(pluginData.getPluginInfo().getDependencies().size());
        for (PluginDependencyInfo dependency : pluginData.getPluginInfo().getDependencies()) {
            PluginData parent = pluginsMap.get(dependency.getName());
            if (parent == null) {
                throw new IllegalStateException("Parent not found for plugin with name " + pluginData.getPluginName());
            }
            parents.add(parent);
        }
        pluginData.setParents(PluginsLookupCollector.sortDependencies(pluginData, parents));
    }

    @NotNull
    static List<PluginData> sortDependencies(@NotNull PluginData node, @NotNull List<PluginData> dependencies) {
        if (node == null) {
            PluginsLookupCollector.$$$reportNull$$$0(21);
        }
        if (dependencies == null) {
            PluginsLookupCollector.$$$reportNull$$$0(22);
        }
        if (dependencies.size() < 2) {
            List<PluginData> list = dependencies;
            if (list == null) {
                PluginsLookupCollector.$$$reportNull$$$0(23);
            }
            return list;
        }
        HashMap<String, PluginData> map = new HashMap<String, PluginData>();
        for (PluginData dependency : dependencies) {
            map.put(dependency.getPluginName(), dependency);
        }
        boolean fail = false;
        ArrayList<PluginData> res = new ArrayList<PluginData>(dependencies.size());
        for (String dependencyName : new LinkedHashSet(CollectionsUtil.convertCollection(node.getPluginInfo().getDependencies(), PluginsLookupCollector.depToName()))) {
            PluginData e = (PluginData)map.get(dependencyName);
            if (e == null) {
                fail = true;
            }
            res.add(e);
        }
        List<PluginData> list = !fail ? res : dependencies;
        if (list == null) {
            PluginsLookupCollector.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    private PluginData createPluginData(@NotNull PluginInfo pluginInfo) {
        if (pluginInfo == null) {
            PluginsLookupCollector.$$$reportNull$$$0(25);
        }
        PluginData pluginData = new PluginData(pluginInfo, this.myReloadablePlugins.shouldLoadPluginAsUnloadable(pluginInfo));
        if (pluginData == null) {
            PluginsLookupCollector.$$$reportNull$$$0(26);
        }
        return pluginData;
    }

    @NotNull
    private static String presentPlugin(@NotNull PluginInfo info) {
        if (info == null) {
            PluginsLookupCollector.$$$reportNull$$$0(27);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(info.getPluginName()).append("[");
        String pluginVersion = info.getPluginVersion();
        if (pluginVersion != null) {
            sb.append("version: ").append(pluginVersion).append(", ");
        } else {
            sb.append("version not set, ");
        }
        sb.append("path: ");
        sb.append(FileUtil.getCanonicalFile((File)info.getPluginRoot()).getPath());
        PluginClassLoadingInfo cl = info.getClassloadingInfo();
        if (LOG.isDebugEnabled() && cl != null) {
            sb.append(", jars: ");
            Function<File, String> toString = new Function<File, String>(){

                public String fun(File pluginPartInfo) {
                    return pluginPartInfo.getPath();
                }
            };
            sb.append(StringUtil.join(cl.getClasspath(), (Function)toString, (String)", "));
        }
        sb.append("]");
        String string = sb.toString();
        if (string == null) {
            PluginsLookupCollector.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    private static Set<PluginInfo> collectPluginsToSkip(@NotNull List<NotLoadedPlugin> notLoadable, @NotNull Collection<PluginData> alreadyLoadedPlugins) {
        if (notLoadable == null) {
            PluginsLookupCollector.$$$reportNull$$$0(29);
        }
        if (alreadyLoadedPlugins == null) {
            PluginsLookupCollector.$$$reportNull$$$0(30);
        }
        HashSet<PluginInfo> disabledPlugins = new HashSet<PluginInfo>();
        for (NotLoadedPlugin notLoadedPlugin : notLoadable) {
            disabledPlugins.add(notLoadedPlugin.getPlugin());
        }
        for (PluginData alreadyLoadedPlugin : alreadyLoadedPlugins) {
            disabledPlugins.add(alreadyLoadedPlugin.getPluginInfo());
        }
        HashSet<PluginInfo> hashSet = disabledPlugins;
        if (hashSet == null) {
            PluginsLookupCollector.$$$reportNull$$$0(31);
        }
        return hashSet;
    }

    @NotNull
    private static List<Pair<PluginInfo, PluginInfo>> collectEdges(List<PluginInfo> plugins, List<NotLoadedPlugin> notLoadable, Collection<PluginData> alreadyLoadedPlugins) {
        Map<String, PluginInfo> nameToInfoMap = PluginsLookupCollector.collectNameMap(plugins, notLoadable, alreadyLoadedPlugins);
        HashMap<String, PluginInfo> missingPlugins = new HashMap<String, PluginInfo>();
        ArrayList<Pair<PluginInfo, PluginInfo>> edges = new ArrayList<Pair<PluginInfo, PluginInfo>>();
        for (PluginInfo pluginInfo : plugins) {
            Collection<PluginDependencyInfo> deps = pluginInfo.getDependencies();
            for (PluginDependencyInfo dependency : deps) {
                PluginInfo dependencyInfo = nameToInfoMap.get(dependency.getName());
                if (dependencyInfo == null) {
                    dependencyInfo = PluginsLookupCollector.getMissingPluginInfo(missingPlugins, edges, dependency);
                }
                edges.add((Pair<PluginInfo, PluginInfo>)Pair.create((Object)pluginInfo, (Object)dependencyInfo));
            }
        }
        for (PluginInfo pluginInfo : plugins) {
            edges.add(Pair.create((Object)pluginInfo, null));
        }
        for (NotLoadedPlugin notLoadedPlugin : notLoadable) {
            edges.add(Pair.create((Object)notLoadedPlugin.getPlugin(), null));
        }
        for (PluginData pluginData : alreadyLoadedPlugins) {
            edges.add((Pair<PluginInfo, PluginInfo>)Pair.create((Object)pluginData.getPluginInfo(), null));
        }
        ArrayList<Pair<PluginInfo, PluginInfo>> arrayList = edges;
        if (arrayList == null) {
            PluginsLookupCollector.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    @NotNull
    private static PluginInfo getMissingPluginInfo(Map<String, PluginInfo> missingPlugins, List<Pair<PluginInfo, PluginInfo>> edges, PluginDependencyInfo dependency) {
        PluginInfo m = missingPlugins.get(dependency.getName());
        if (m == null) {
            MissingPluginInfo missing = new MissingPluginInfo(dependency.getName());
            missingPlugins.put(dependency.getName(), missing);
            edges.add((Pair<PluginInfo, PluginInfo>)Pair.create((Object)missing, null));
            m = missing;
        }
        PluginInfo pluginInfo = m;
        if (pluginInfo == null) {
            PluginsLookupCollector.$$$reportNull$$$0(33);
        }
        return pluginInfo;
    }

    @NotNull
    private static Map<String, PluginInfo> collectNameMap(@NotNull List<PluginInfo> plugins, @NotNull List<NotLoadedPlugin> notLoadable, @NotNull Collection<PluginData> alreadyLoadedPlugins) {
        if (plugins == null) {
            PluginsLookupCollector.$$$reportNull$$$0(34);
        }
        if (notLoadable == null) {
            PluginsLookupCollector.$$$reportNull$$$0(35);
        }
        if (alreadyLoadedPlugins == null) {
            PluginsLookupCollector.$$$reportNull$$$0(36);
        }
        HashMap<String, PluginInfo> nameToInfoMap = new HashMap<String, PluginInfo>();
        for (PluginInfo pluginInfo : plugins) {
            nameToInfoMap.put(pluginInfo.getPluginName(), pluginInfo);
        }
        for (NotLoadedPlugin notLoadedPlugin : notLoadable) {
            if (nameToInfoMap.containsKey(notLoadedPlugin.getPlugin().getPluginName())) continue;
            nameToInfoMap.put(notLoadedPlugin.getPlugin().getPluginName(), notLoadedPlugin.getPlugin());
        }
        for (PluginData pluginData : alreadyLoadedPlugins) {
            nameToInfoMap.put(pluginData.getPluginName(), pluginData.getPluginInfo());
        }
        HashMap<String, PluginInfo> hashMap = nameToInfoMap;
        if (hashMap == null) {
            PluginsLookupCollector.$$$reportNull$$$0(37);
        }
        return hashMap;
    }

    private static Converter<String, PluginDependencyInfo> depToName() {
        return new Converter<String, PluginDependencyInfo>(){

            public String createFrom(@NotNull PluginDependencyInfo source) {
                if (source == null) {
                    5.$$$reportNull$$$0(0);
                }
                return source.getName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "jetbrains/buildServer/plugins/PluginsLookupCollector$5", "createFrom"));
            }
        };
    }

    private static Converter<String, PluginData> dataToName() {
        return new Converter<String, PluginData>(){

            public String createFrom(@NotNull PluginData source) {
                if (source == null) {
                    6.$$$reportNull$$$0(0);
                }
                return source.getPluginInfo().getPluginName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "jetbrains/buildServer/plugins/PluginsLookupCollector$6", "createFrom"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 18: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 18: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDisabledInfoProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reloadablePlugins";
                break;
            }
            case 5: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginInfo";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 18: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/plugins/PluginsLookupCollector";
                break;
            }
            case 7: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedPlugins";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filteredTopoordered";
                break;
            }
            case 14: 
            case 15: 
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyLoadedPlugins";
                break;
            }
            case 16: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notLoadable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsMap";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginData";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/plugins/PluginsLookupCollector";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toPluginsCollection";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsCollection";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginDatas";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "filterPlugins";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "sortDependencies";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginData";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "presentPlugin";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPluginsToSkip";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "collectEdges";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingPluginInfo";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNameMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "pluginInfoFound";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 18: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 37: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toPluginsCollection";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createPluginDatas";
                break;
            }
            case 13: 
            case 14: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "fillParents";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "filterPlugins";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "sortDependencies";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createPluginData";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "presentPlugin";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "collectPluginsToSkip";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "collectNameMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 18: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FullDependenciesGraphPluginInfoFilter
    implements PluginInfoFilter {
        @Override
        @NotNull
        public Pair<List<PluginInfo>, List<NotLoadedPlugin>> processPlugins(@NotNull List<PluginInfo> infos, @NotNull List<NotLoadedPlugin> notLoadable, @NotNull Collection<PluginData> alreadyLoadedPlugins) {
            if (infos == null) {
                FullDependenciesGraphPluginInfoFilter.$$$reportNull$$$0(0);
            }
            if (notLoadable == null) {
                FullDependenciesGraphPluginInfoFilter.$$$reportNull$$$0(1);
            }
            if (alreadyLoadedPlugins == null) {
                FullDependenciesGraphPluginInfoFilter.$$$reportNull$$$0(2);
            }
            Set disabledPlugins = PluginsLookupCollector.collectPluginsToSkip(notLoadable, Collections.emptyList());
            Set toSkip = PluginsLookupCollector.collectPluginsToSkip(notLoadable, alreadyLoadedPlugins);
            ArrayList<NotLoadedPlugin> disabled = new ArrayList<NotLoadedPlugin>();
            ArrayList<PluginInfo> enabled = new ArrayList<PluginInfo>();
            DAG<PluginInfo> dag = DAGs.createFromEdges(PluginsLookupCollector.collectEdges(infos, notLoadable, alreadyLoadedPlugins));
            for (PluginInfo node : dag.toposort()) {
                if (toSkip.contains(node)) continue;
                List<PluginInfo> parents = dag.getParents(node);
                LinkedHashSet<String> missingParents = new LinkedHashSet<String>();
                LinkedHashSet<String> disabledParents = new LinkedHashSet<String>();
                for (PluginInfo parent : parents) {
                    if (disabledPlugins.contains(parent)) {
                        disabledParents.add(parent.getPluginName());
                        continue;
                    }
                    if (!(parent instanceof MissingPluginInfo)) continue;
                    missingParents.add(parent.getPluginName());
                }
                if (!missingParents.isEmpty() || !disabledParents.isEmpty()) {
                    if (!missingParents.isEmpty() && !disabledParents.isEmpty()) {
                        disabled.add(new NotLoadedPlugin(node, "Dependencies missing: " + StringUtil.join(missingParents, (String)", ") + "; and dependencies disabled: " + StringUtil.join(disabledParents, (String)", ")));
                    } else if (!missingParents.isEmpty()) {
                        disabled.add(new NotLoadedPlugin(node, "Dependencies missing: " + StringUtil.join(missingParents, (String)", ")));
                    } else {
                        disabled.add(new NotLoadedPlugin(node, "Dependencies disabled: " + StringUtil.join(disabledParents, (String)", ")));
                    }
                    disabledPlugins.add(node);
                    toSkip.add(node);
                    continue;
                }
                if (node instanceof MissingPluginInfo) continue;
                enabled.add(node);
            }
            Pair pair = Pair.create(enabled, disabled);
            if (pair == null) {
                FullDependenciesGraphPluginInfoFilter.$$$reportNull$$$0(3);
            }
            return pair;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notLoadable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alreadyLoadedPlugins";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/plugins/PluginsLookupCollector$FullDependenciesGraphPluginInfoFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/plugins/PluginsLookupCollector$FullDependenciesGraphPluginInfoFilter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "processPlugins";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "processPlugins";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class CyclicDependenciesPluginInfoFilter
    implements PluginInfoFilter {
        @Override
        @NotNull
        public Pair<List<PluginInfo>, List<NotLoadedPlugin>> processPlugins(@NotNull List<PluginInfo> infos, @NotNull List<NotLoadedPlugin> notLoadable, @NotNull Collection<PluginData> alreadyLoadedPlugins) {
            if (infos == null) {
                CyclicDependenciesPluginInfoFilter.$$$reportNull$$$0(0);
            }
            if (notLoadable == null) {
                CyclicDependenciesPluginInfoFilter.$$$reportNull$$$0(1);
            }
            if (alreadyLoadedPlugins == null) {
                CyclicDependenciesPluginInfoFilter.$$$reportNull$$$0(2);
            }
            ArrayList<NotLoadedPlugin> disabled = new ArrayList<NotLoadedPlugin>();
            List edges = PluginsLookupCollector.collectEdges(infos, notLoadable, alreadyLoadedPlugins);
            Set toSkip = PluginsLookupCollector.collectPluginsToSkip(notLoadable, alreadyLoadedPlugins);
            Pair removeResult = DAGUtil.removeCycles(edges);
            if (!((List)removeResult.second).isEmpty()) {
                String cycleToString = StringUtil.join((Collection)((Collection)removeResult.second), (Function)PLUGIN_INFO_TO_NAME, (String)",");
                for (PluginInfo info : (List)removeResult.second) {
                    if (toSkip.contains(info)) continue;
                    disabled.add(new NotLoadedPlugin(info, "Part of dependencies cycle or depends on cycle: " + cycleToString));
                    toSkip.add(info);
                }
            }
            HashSet set = new HashSet(((DAG)removeResult.first).getAllNodes());
            ArrayList<PluginInfo> enabled = new ArrayList<PluginInfo>(infos);
            enabled.retainAll(set);
            Pair pair = new Pair(enabled, disabled);
            if (pair == null) {
                CyclicDependenciesPluginInfoFilter.$$$reportNull$$$0(3);
            }
            return pair;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notLoadable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alreadyLoadedPlugins";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/plugins/PluginsLookupCollector$CyclicDependenciesPluginInfoFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/plugins/PluginsLookupCollector$CyclicDependenciesPluginInfoFilter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "processPlugins";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "processPlugins";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class VersionPluginInfoFilter
    implements PluginInfoFilter {
        @NotNull
        private final PluginVersionComparator myComparator;

        VersionPluginInfoFilter(@NotNull PluginVersionComparator comparator) {
            if (comparator == null) {
                VersionPluginInfoFilter.$$$reportNull$$$0(0);
            }
            this.myComparator = comparator;
        }

        @Override
        @NotNull
        public Pair<List<PluginInfo>, List<NotLoadedPlugin>> processPlugins(@NotNull List<PluginInfo> infos, @NotNull List<NotLoadedPlugin> notLoadable, @NotNull Collection<PluginData> alreadyLoadedPlugins) {
            if (infos == null) {
                VersionPluginInfoFilter.$$$reportNull$$$0(1);
            }
            if (notLoadable == null) {
                VersionPluginInfoFilter.$$$reportNull$$$0(2);
            }
            if (alreadyLoadedPlugins == null) {
                VersionPluginInfoFilter.$$$reportNull$$$0(3);
            }
            if (infos.isEmpty()) {
                Pair pair = new Pair(new ArrayList(), new ArrayList());
                if (pair == null) {
                    VersionPluginInfoFilter.$$$reportNull$$$0(4);
                }
                return pair;
            }
            ArrayList<NotLoadedPlugin> disabled = new ArrayList<NotLoadedPlugin>();
            ArrayList<PluginInfo> enabled = new ArrayList<PluginInfo>();
            for (List<PluginInfo> pluginInfos : VersionPluginInfoFilter.byName(infos)) {
                PluginInfo selected = pluginInfos.size() == 1 ? pluginInfos.iterator().next() : this.myComparator.selectPluginToLoad(Collections.unmodifiableCollection(pluginInfos));
                if (pluginInfos.size() > 1) {
                    for (PluginInfo plugin : pluginInfos) {
                        if (plugin == selected) continue;
                        disabled.add(new NotLoadedPlugin(plugin, "Overridden by newer version: " + PluginsLookupCollector.presentPlugin(selected)));
                    }
                }
                enabled.add(selected);
            }
            Pair pair = new Pair(enabled, disabled);
            if (pair == null) {
                VersionPluginInfoFilter.$$$reportNull$$$0(5);
            }
            return pair;
        }

        private static Iterable<List<PluginInfo>> byName(@NotNull List<PluginInfo> allPluginInfos) {
            if (allPluginInfos == null) {
                VersionPluginInfoFilter.$$$reportNull$$$0(6);
            }
            MultiMapToList map = new MultiMapToList();
            for (PluginInfo pluginInfo : allPluginInfos) {
                map.add((Object)pluginInfo.getPluginName(), (Object)pluginInfo);
            }
            return map.values();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comparator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notLoadable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alreadyLoadedPlugins";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/plugins/PluginsLookupCollector$VersionPluginInfoFilter";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allPluginInfos";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/plugins/PluginsLookupCollector$VersionPluginInfoFilter";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "processPlugins";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "processPlugins";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "byName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DisabledSimplePluginInfoFilterFactory
    implements SimplePluginInfoFilterFactory {
        @NotNull
        private final PluginDisabledInfoProvider myPluginDisabledInfoProvider;

        DisabledSimplePluginInfoFilterFactory(@NotNull PluginDisabledInfoProvider pluginDisabledInfoProvider) {
            if (pluginDisabledInfoProvider == null) {
                DisabledSimplePluginInfoFilterFactory.$$$reportNull$$$0(0);
            }
            this.myPluginDisabledInfoProvider = pluginDisabledInfoProvider;
        }

        @Override
        @NotNull
        public SimplePluginInfoFilter getSimpleFilter(@NotNull List<NotLoadedPlugin> notLoadable, @NotNull Collection<PluginData> alreadyLoadedPlugins) {
            if (notLoadable == null) {
                DisabledSimplePluginInfoFilterFactory.$$$reportNull$$$0(1);
            }
            if (alreadyLoadedPlugins == null) {
                DisabledSimplePluginInfoFilterFactory.$$$reportNull$$$0(2);
            }
            SimplePluginInfoFilter simplePluginInfoFilter = new SimplePluginInfoFilter(){

                @Override
                @Nullable
                public NotLoadedPlugin filter(@NotNull PluginInfo candidate) {
                    String disableReason;
                    if (candidate == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((disableReason = myPluginDisabledInfoProvider.getDisableReason(candidate)) != null) {
                        return new NotLoadedPlugin(candidate, "Plugin is disabled on this node, reason: " + disableReason.toLowerCase());
                    }
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "jetbrains/buildServer/plugins/PluginsLookupCollector$DisabledSimplePluginInfoFilterFactory$1", "filter"));
                }
            };
            if (simplePluginInfoFilter == null) {
                DisabledSimplePluginInfoFilterFactory.$$$reportNull$$$0(3);
            }
            return simplePluginInfoFilter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDisabledInfoProvider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notLoadable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alreadyLoadedPlugins";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/plugins/PluginsLookupCollector$DisabledSimplePluginInfoFilterFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/plugins/PluginsLookupCollector$DisabledSimplePluginInfoFilterFactory";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSimpleFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getSimpleFilter";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class IncorrectSimplePluginInfoFilterFactory
    implements SimplePluginInfoFilterFactory {
        @Override
        @NotNull
        public SimplePluginInfoFilter getSimpleFilter(@NotNull List<NotLoadedPlugin> notLoadable, @NotNull Collection<PluginData> alreadyLoadedPlugins) {
            if (notLoadable == null) {
                IncorrectSimplePluginInfoFilterFactory.$$$reportNull$$$0(0);
            }
            if (alreadyLoadedPlugins == null) {
                IncorrectSimplePluginInfoFilterFactory.$$$reportNull$$$0(1);
            }
            SimplePluginInfoFilter simplePluginInfoFilter = new SimplePluginInfoFilter(){

                @Override
                @Nullable
                public NotLoadedPlugin filter(@NotNull PluginInfo candidate) {
                    if (candidate == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (candidate instanceof IncorrectPluginInfo) {
                        return new NotLoadedPlugin(candidate, ((IncorrectPluginInfo)candidate).getReason());
                    }
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "jetbrains/buildServer/plugins/PluginsLookupCollector$IncorrectSimplePluginInfoFilterFactory$1", "filter"));
                }
            };
            if (simplePluginInfoFilter == null) {
                IncorrectSimplePluginInfoFilterFactory.$$$reportNull$$$0(2);
            }
            return simplePluginInfoFilter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notLoadable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alreadyLoadedPlugins";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/plugins/PluginsLookupCollector$IncorrectSimplePluginInfoFilterFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/plugins/PluginsLookupCollector$IncorrectSimplePluginInfoFilterFactory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSimpleFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSimpleFilter";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AlreadyLoadedSimplePluginInfoFilterFactory
    implements SimplePluginInfoFilterFactory {
        @Override
        @NotNull
        public SimplePluginInfoFilter getSimpleFilter(@NotNull List<NotLoadedPlugin> notLoadable, @NotNull Collection<PluginData> alreadyLoadedPlugins) {
            if (notLoadable == null) {
                AlreadyLoadedSimplePluginInfoFilterFactory.$$$reportNull$$$0(0);
            }
            if (alreadyLoadedPlugins == null) {
                AlreadyLoadedSimplePluginInfoFilterFactory.$$$reportNull$$$0(1);
            }
            final Set loaded = CollectionsUtil.convertSet(alreadyLoadedPlugins, (Converter)PluginsLookupCollector.dataToName());
            SimplePluginInfoFilter simplePluginInfoFilter = new SimplePluginInfoFilter(){

                @Override
                @Nullable
                public NotLoadedPlugin filter(@NotNull PluginInfo candidate) {
                    if (candidate == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return loaded.contains(candidate.getPluginName()) ? new NotLoadedPlugin(candidate, "There is already running plugin with same name") : null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "jetbrains/buildServer/plugins/PluginsLookupCollector$AlreadyLoadedSimplePluginInfoFilterFactory$1", "filter"));
                }
            };
            if (simplePluginInfoFilter == null) {
                AlreadyLoadedSimplePluginInfoFilterFactory.$$$reportNull$$$0(2);
            }
            return simplePluginInfoFilter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notLoadable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alreadyLoadedPlugins";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/plugins/PluginsLookupCollector$AlreadyLoadedSimplePluginInfoFilterFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/plugins/PluginsLookupCollector$AlreadyLoadedSimplePluginInfoFilterFactory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSimpleFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSimpleFilter";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AbstractPluginInfoFilter
    implements PluginInfoFilter {
        @NotNull
        private final SimplePluginInfoFilterFactory mySimplePluginInfoFilterFactory;

        AbstractPluginInfoFilter(@NotNull SimplePluginInfoFilterFactory simplePluginInfoFilterFactory) {
            if (simplePluginInfoFilterFactory == null) {
                AbstractPluginInfoFilter.$$$reportNull$$$0(0);
            }
            this.mySimplePluginInfoFilterFactory = simplePluginInfoFilterFactory;
        }

        @Override
        @NotNull
        public Pair<List<PluginInfo>, List<NotLoadedPlugin>> processPlugins(@NotNull List<PluginInfo> infos, @NotNull List<NotLoadedPlugin> notLoadable, @NotNull Collection<PluginData> alreadyLoadedPlugins) {
            if (infos == null) {
                AbstractPluginInfoFilter.$$$reportNull$$$0(1);
            }
            if (notLoadable == null) {
                AbstractPluginInfoFilter.$$$reportNull$$$0(2);
            }
            if (alreadyLoadedPlugins == null) {
                AbstractPluginInfoFilter.$$$reportNull$$$0(3);
            }
            ArrayList<PluginInfo> enabled = new ArrayList<PluginInfo>();
            ArrayList<NotLoadedPlugin> filtered = new ArrayList<NotLoadedPlugin>();
            SimplePluginInfoFilter simpleFilter = this.mySimplePluginInfoFilterFactory.getSimpleFilter(notLoadable, alreadyLoadedPlugins);
            for (PluginInfo info : infos) {
                NotLoadedPlugin nlp = simpleFilter.filter(info);
                if (nlp != null) {
                    filtered.add(nlp);
                    continue;
                }
                enabled.add(info);
            }
            Pair pair = Pair.create(enabled, filtered);
            if (pair == null) {
                AbstractPluginInfoFilter.$$$reportNull$$$0(4);
            }
            return pair;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "simplePluginInfoFilterFactory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notLoadable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alreadyLoadedPlugins";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/plugins/PluginsLookupCollector$AbstractPluginInfoFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/plugins/PluginsLookupCollector$AbstractPluginInfoFilter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "processPlugins";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "processPlugins";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface SimplePluginInfoFilter {
        @Nullable
        public NotLoadedPlugin filter(@NotNull PluginInfo var1);
    }

    public static interface SimplePluginInfoFilterFactory {
        @NotNull
        public SimplePluginInfoFilter getSimpleFilter(@NotNull List<NotLoadedPlugin> var1, @NotNull Collection<PluginData> var2);
    }

    public static interface PluginInfoFilter {
        @NotNull
        public Pair<List<PluginInfo>, List<NotLoadedPlugin>> processPlugins(@NotNull List<PluginInfo> var1, @NotNull List<NotLoadedPlugin> var2, @NotNull Collection<PluginData> var3);
    }
}

