/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.plugins.NotLoadedPlugin;
import jetbrains.buildServer.plugins.PluginData;
import jetbrains.buildServer.plugins.PluginsState;
import jetbrains.buildServer.plugins.bean.PluginInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginsStateImpl
implements PluginsState {
    @NotNull
    private final Map<String, PluginData> myLoadedPlugins;
    @NotNull
    private final Map<String, Collection<NotLoadedPlugin>> myNotLoadedPlugins;

    public PluginsStateImpl(@NotNull Collection<PluginData> loadedPlugins, @NotNull Collection<NotLoadedPlugin> notLoadedPlugins) {
        if (loadedPlugins == null) {
            PluginsStateImpl.$$$reportNull$$$0(0);
        }
        if (notLoadedPlugins == null) {
            PluginsStateImpl.$$$reportNull$$$0(1);
        }
        HashMap<String, PluginData> loaded = new HashMap<String, PluginData>();
        for (PluginData loadedPlugin : loadedPlugins) {
            PluginData clashedId = loaded.put(loadedPlugin.getPluginName(), loadedPlugin);
            if (clashedId == null) continue;
            throw new IllegalArgumentException("There could not be plugin id clashes in loaded plugins");
        }
        this.myLoadedPlugins = loaded;
        HashMap<String, Collection<NotLoadedPlugin>> notLoaded = new HashMap<String, Collection<NotLoadedPlugin>>();
        for (NotLoadedPlugin notLoadedPlugin : notLoadedPlugins) {
            ArrayList<NotLoadedPlugin> collection = (ArrayList<NotLoadedPlugin>)notLoaded.get(notLoadedPlugin.getPlugin().getPluginName());
            if (collection == null) {
                collection = new ArrayList<NotLoadedPlugin>();
                notLoaded.put(notLoadedPlugin.getPlugin().getPluginName(), collection);
            }
            collection.add(notLoadedPlugin);
        }
        this.myNotLoadedPlugins = notLoaded;
    }

    @Override
    @NotNull
    public Collection<PluginInfo> getLoadedPlugins() {
        ArrayList<PluginInfo> res = new ArrayList<PluginInfo>(this.myLoadedPlugins.size());
        for (PluginData value : this.myLoadedPlugins.values()) {
            res.add(value.getPluginInfo());
        }
        ArrayList<PluginInfo> arrayList = res;
        if (arrayList == null) {
            PluginsStateImpl.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<NotLoadedPlugin> getNotLoadedPlugins() {
        ArrayList<NotLoadedPlugin> res = new ArrayList<NotLoadedPlugin>();
        for (Collection<NotLoadedPlugin> value : this.myNotLoadedPlugins.values()) {
            res.addAll(value);
        }
        ArrayList<NotLoadedPlugin> arrayList = res;
        if (arrayList == null) {
            PluginsStateImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<NotLoadedPlugin> findNotLoadedPlugins(@NotNull String id) {
        Collection<NotLoadedPlugin> notLoadedPlugins;
        if (id == null) {
            PluginsStateImpl.$$$reportNull$$$0(4);
        }
        Collection<NotLoadedPlugin> collection = (notLoadedPlugins = this.myNotLoadedPlugins.get(id)) != null ? notLoadedPlugins : Collections.emptyList();
        if (collection == null) {
            PluginsStateImpl.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<PluginInfo> getAllPlugins(@NotNull String id) {
        Collection<NotLoadedPlugin> notLoadedPlugins;
        if (id == null) {
            PluginsStateImpl.$$$reportNull$$$0(6);
        }
        ArrayList<PluginInfo> res = new ArrayList<PluginInfo>();
        PluginData loaded = this.myLoadedPlugins.get(id);
        if (loaded != null) {
            res.add(loaded.getPluginInfo());
        }
        if ((notLoadedPlugins = this.myNotLoadedPlugins.get(id)) != null) {
            for (NotLoadedPlugin notLoadedPlugin : notLoadedPlugins) {
                res.add(notLoadedPlugin.getPlugin());
            }
        }
        ArrayList<PluginInfo> arrayList = res;
        if (arrayList == null) {
            PluginsStateImpl.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<PluginInfo> getAllPlugins() {
        ArrayList<PluginInfo> res = new ArrayList<PluginInfo>(this.getLoadedPlugins());
        for (Collection<NotLoadedPlugin> notLoadedPlugins : this.myNotLoadedPlugins.values()) {
            for (NotLoadedPlugin notLoadedPlugin : notLoadedPlugins) {
                res.add(notLoadedPlugin.getPlugin());
            }
        }
        ArrayList<PluginInfo> arrayList = res;
        if (arrayList == null) {
            PluginsStateImpl.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public PluginInfo findLoadedPlugin(@NotNull String id) {
        PluginData pluginData;
        if (id == null) {
            PluginsStateImpl.$$$reportNull$$$0(9);
        }
        return (pluginData = this.myLoadedPlugins.get(id)) != null ? pluginData.getPluginInfo() : null;
    }

    @Override
    public boolean isPluginLoaded(@NotNull String id) {
        if (id == null) {
            PluginsStateImpl.$$$reportNull$$$0(10);
        }
        return this.findLoadedPlugin(id) != null;
    }

    @Override
    public boolean hasNotLoadedPlugin(@NotNull String id) {
        if (id == null) {
            PluginsStateImpl.$$$reportNull$$$0(11);
        }
        return !this.findNotLoadedPlugins(id).isEmpty();
    }

    @Override
    @Nullable
    public PluginData findPluginData(@NotNull String pluginName) {
        if (pluginName == null) {
            PluginsStateImpl.$$$reportNull$$$0(12);
        }
        return this.myLoadedPlugins.get(pluginName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedPlugins";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notLoadedPlugins";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/plugins/PluginsStateImpl";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/plugins/PluginsStateImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedPlugins";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotLoadedPlugins";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findNotLoadedPlugins";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPlugins";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findNotLoadedPlugins";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllPlugins";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findLoadedPlugin";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isPluginLoaded";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasNotLoadedPlugin";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findPluginData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

