/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.plugins.classLoaders;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrains.buildServer.agent.ClasspathUtil;
import jetbrains.buildServer.plugins.bean.PluginInfo;
import jetbrains.buildServer.plugins.classLoaders.PluginClassLoadingInfo;
import jetbrains.buildServer.plugins.classLoaders.PluginInfoByClassProvider;
import jetbrains.buildServer.plugins.classLoaders.TeamCityPluginClassLoader;
import jetbrains.buildServer.util.FileUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginsSharedClassLoader
extends TeamCityPluginClassLoader
implements PluginInfoByClassProvider {
    private static final Logger LOG = Logger.getInstance((String)PluginsSharedClassLoader.class.getName());
    private final List<Pair<Set<File>, PluginInfo>> myFilesToPlugin;

    public PluginsSharedClassLoader(@Nullable ClassLoader parent, @NotNull Collection<PluginClassLoadingInfo> infos) {
        if (infos == null) {
            PluginsSharedClassLoader.$$$reportNull$$$0(0);
        }
        super(parent, true);
        this.myFilesToPlugin = new ArrayList<Pair<Set<File>, PluginInfo>>();
        for (PluginClassLoadingInfo info : infos) {
            this.addResource(info);
        }
    }

    private void addResource(@NotNull PluginClassLoadingInfo plugin) {
        if (plugin == null) {
            PluginsSharedClassLoader.$$$reportNull$$$0(1);
        }
        HashSet<File> pluginFiles = new HashSet<File>();
        for (File url : plugin.getClasspath()) {
            this.addJar(url);
            pluginFiles.add(FileUtil.getCanonicalFile((File)url));
        }
        this.myFilesToPlugin.add((Pair<Set<File>, PluginInfo>)Pair.create(pluginFiles, (Object)plugin.getPluginInfo()));
    }

    @Override
    @Nullable
    public synchronized PluginInfo findPluginInfoByClass(@NotNull Class<?> clazz) {
        if (clazz == null) {
            PluginsSharedClassLoader.$$$reportNull$$$0(2);
        }
        if (clazz.getClassLoader() != this) {
            return null;
        }
        try {
            String pathname = ClasspathUtil.getClasspathEntry(clazz);
            if (pathname == null) {
                return null;
            }
            File jarFile = FileUtil.getCanonicalFile((File)new File(pathname));
            PluginInfo result = null;
            for (Pair<Set<File>, PluginInfo> entry : this.myFilesToPlugin) {
                if (!((Set)entry.first).contains(jarFile)) continue;
                if (result == null) {
                    result = (PluginInfo)entry.second;
                    continue;
                }
                throw new IllegalStateException("Class " + clazz + " is contained in more than one plugin. Failed to decide.");
            }
            return result;
        }
        catch (IOException e) {
            LOG.warn("Failed to get classpath entry for class " + clazz + " " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return "PluginsSharedClassLoader{parent=" + this.getParent() + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/plugins/classLoaders/PluginsSharedClassLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addResource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findPluginInfoByClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

