/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.plugins.classLoaders;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.ArrayList;
import jetbrains.buildServer.ResourceUtil;
import jetbrains.buildServer.plugins.PluginData;
import jetbrains.buildServer.plugins.classLoaders.PluginStandaloneClassLoader;
import jetbrains.buildServer.plugins.classLoaders.TeamCityClassLoader;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.io.Resource;

public class SpringScriptingClassloadingUtil {
    private static final Logger LOG = Logger.getInstance((String)SpringScriptingClassloadingUtil.class.getName());
    private static boolean ourWarningLogged;

    public static void extendClassLoaderForScriptingLanguagesInSpring(@NotNull PluginData plugin) {
        if (plugin == null) {
            SpringScriptingClassloadingUtil.$$$reportNull$$$0(0);
        }
        try {
            String spring_jar_path = ResourceUtil.getResourceRoot(Resource.class);
            if (spring_jar_path == null) {
                SpringScriptingClassloadingUtil.warnOnce("'spring.jar' location not found, cannot modify classloaders of plugins");
                return;
            }
            File libs = new File(new File(spring_jar_path).getParentFile(), "spring-scripting");
            if (!libs.exists() || !libs.isDirectory()) {
                SpringScriptingClassloadingUtil.warnOnce("Directory with additional jars not found: " + libs.getAbsolutePath());
                return;
            }
            TeamCityClassLoader cl = plugin.getClassloader();
            ArrayList<File> toAdd = new ArrayList<File>(0);
            if (SpringScriptingClassloadingUtil.isGroovyPresent(cl) && !SpringScriptingClassloadingUtil.isGroovyScriptingPresent(cl)) {
                toAdd.add(new File(libs, "spring-scripting-groovy.jar"));
            }
            if (SpringScriptingClassloadingUtil.isJRubyPresent(cl) && !SpringScriptingClassloadingUtil.isJRubyScriptingPresent(cl)) {
                toAdd.add(new File(libs, "spring-scripting-jruby.jar"));
            }
            if (SpringScriptingClassloadingUtil.isBSHPresent(cl) && !SpringScriptingClassloadingUtil.isBSHScriptingPresent(cl)) {
                toAdd.add(new File(libs, "spring-scripting-bsh.jar"));
            }
            if (!toAdd.isEmpty()) {
                if (cl instanceof PluginStandaloneClassLoader) {
                    PluginStandaloneClassLoader standaloneCL = (PluginStandaloneClassLoader)cl;
                    for (File file : toAdd) {
                        standaloneCL.addJar(file);
                    }
                    LOG.info("Added additional libraries " + toAdd + " to plugin '" + plugin.getPluginName() + "' classpath.");
                } else {
                    LOG.warn("Cannot add additional libraries " + toAdd + " for plugin '" + plugin.getPluginName() + "': non-standalone classloader used. See plugin development documentation for details about standalone classloaders.");
                }
            }
        }
        catch (Throwable e) {
            LOG.warnAndDebugDetails("Failed to patch classloader of plugin '" + plugin.getPluginName() + "'", e);
        }
    }

    private static boolean isGroovyPresent(TeamCityClassLoader cl) {
        return cl.findResource("org/codehaus/groovy/control/CompilationFailedException.class") != null;
    }

    private static boolean isGroovyScriptingPresent(TeamCityClassLoader cl) {
        try {
            Class<?> clz = cl.loadClass("org.springframework.scripting.groovy.GroovyScriptFactory");
            return clz.getClassLoader() == cl;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean isJRubyPresent(TeamCityClassLoader cl) {
        return cl.findResource("org/jruby/exceptions/RaiseException.class") != null;
    }

    private static boolean isJRubyScriptingPresent(TeamCityClassLoader cl) {
        try {
            Class<?> clz = cl.loadClass("org.springframework.scripting.jruby.JRubyScriptFactory");
            return clz.getClassLoader() == cl;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean isBSHPresent(TeamCityClassLoader cl) {
        return cl.findResource("bsh/EvalError.class") != null;
    }

    private static boolean isBSHScriptingPresent(TeamCityClassLoader cl) {
        try {
            Class<?> clz = cl.loadClass("org.springframework.scripting.bsh.BshScriptFactory");
            return clz.getClassLoader() == cl;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static void warnOnce(String message) {
        if (!ourWarningLogged) {
            ourWarningLogged = true;
            LOG.error(message);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugin", "jetbrains/buildServer/plugins/classLoaders/SpringScriptingClassloadingUtil", "extendClassLoaderForScriptingLanguagesInSpring"));
    }
}

