/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.plugins.classLoaders;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import jetbrains.buildServer.plugins.classLoaders.CallParentClassLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TeamCityClassLoader
extends URLClassLoader {
    private final boolean myDelegateToParentFirst;
    private final CallParentClassLoader myParentDelegation;
    @Nullable
    private final ClassLoader myParent;

    protected TeamCityClassLoader(@Nullable ClassLoader parent, boolean delegateToParentFirst) {
        super(new URL[0], parent);
        this.myParent = parent;
        this.myDelegateToParentFirst = delegateToParentFirst;
        this.myParentDelegation = CallParentClassLoader.getLoader();
    }

    @Override
    protected final synchronized Class<?> loadClass(@NotNull String name, boolean resolve) throws ClassNotFoundException {
        if (name == null) {
            TeamCityClassLoader.$$$reportNull$$$0(0);
        }
        if ("net.sf.cglib.proxy.Enhancer".equals(name)) {
            throw new ClassNotFoundException("CGLIB should not be available here");
        }
        Class aClass = this.doLoadClass(name);
        if (resolve) {
            this.resolveClass(aClass);
        }
        return aClass;
    }

    @Nullable
    protected Class callParentLoadClass(@NotNull String name) {
        if (name == null) {
            TeamCityClassLoader.$$$reportNull$$$0(1);
        }
        try {
            if (this.myParent != null) {
                return this.myParentDelegation.loadClassFromParent(this.myParent, name);
            }
            return TeamCityClassLoader.getSystemClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @NotNull
    protected Class doLoadClass(@NotNull String name) throws ClassNotFoundException {
        Class<?> clazz;
        Class c;
        if (name == null) {
            TeamCityClassLoader.$$$reportNull$$$0(2);
        }
        if ((c = this.findLoadedClass(name)) != null) {
            Class clazz2 = c;
            if (clazz2 == null) {
                TeamCityClassLoader.$$$reportNull$$$0(3);
            }
            return clazz2;
        }
        if (this.myDelegateToParentFirst && (c = this.callParentLoadClass(name)) != null) {
            Class clazz3 = c;
            if (clazz3 == null) {
                TeamCityClassLoader.$$$reportNull$$$0(4);
            }
            return clazz3;
        }
        try {
            clazz = this.findClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (!this.myDelegateToParentFirst && (c = this.callParentLoadClass(name)) != null) {
                Class clazz4 = c;
                if (clazz4 == null) {
                    TeamCityClassLoader.$$$reportNull$$$0(6);
                }
                return clazz4;
            }
            throw new ClassNotFoundException("Class '" + name + "' was not found");
        }
        if (clazz == null) {
            TeamCityClassLoader.$$$reportNull$$$0(5);
        }
        return clazz;
    }

    @NotNull
    protected Class doLoadClassWithoutParent(@NotNull String name) throws ClassNotFoundException {
        Class<?> c;
        if (name == null) {
            TeamCityClassLoader.$$$reportNull$$$0(7);
        }
        if ((c = this.findLoadedClass(name)) != null) {
            Class<?> clazz = c;
            if (clazz == null) {
                TeamCityClassLoader.$$$reportNull$$$0(8);
            }
            return clazz;
        }
        Class<?> clazz = this.findClass(name);
        if (clazz == null) {
            TeamCityClassLoader.$$$reportNull$$$0(9);
        }
        return clazz;
    }

    @Override
    @Nullable
    public URL getResource(String name) {
        URL resource;
        ClassLoader parent;
        ClassLoader classLoader = parent = this.myParent != null ? this.myParent : TeamCityClassLoader.getSystemClassLoader();
        if (this.myDelegateToParentFirst && (resource = parent.getResource(name)) != null) {
            return resource;
        }
        resource = this.findResource(name);
        if (resource != null) {
            return resource;
        }
        if (!this.myDelegateToParentFirst && (resource = parent.getResource(name)) != null) {
            return resource;
        }
        return null;
    }

    protected void addJar(@NotNull File jar) {
        if (jar == null) {
            TeamCityClassLoader.$$$reportNull$$$0(10);
        }
        this.addURL(TeamCityClassLoader.toUrl(jar));
    }

    @NotNull
    private static URL toUrl(File file) {
        URL uRL;
        try {
            uRL = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to create URL from file " + file, e);
        }
        if (uRL == null) {
            TeamCityClassLoader.$$$reportNull$$$0(11);
        }
        return uRL;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/plugins/classLoaders/TeamCityClassLoader";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/plugins/classLoaders/TeamCityClassLoader";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doLoadClass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doLoadClassWithoutParent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadClass";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "callParentLoadClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doLoadClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doLoadClassWithoutParent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addJar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

