/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.plugins.files;

import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import jetbrains.buildServer.plugins.bean.PluginInfo;
import jetbrains.buildServer.plugins.files.PluginFileSystemLookup;
import jetbrains.buildServer.plugins.loaders.PluginInfosBuilder;
import jetbrains.buildServer.util.FileUtil;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class JarSearcherBase
implements PluginFileSystemLookup {
    private static final Logger LOG = Logger.getLogger(JarSearcherBase.class);
    public static final String TEAMCITY_PLUGIN_XML = "teamcity-plugin.xml";
    private final FileFilter PLUGIN_DIR_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() && !pathname.getName().startsWith(".");
        }
    };

    @NotNull
    public abstract Collection<File> getPluginPaths();

    @Override
    public void loadPluginsFrom(@NotNull PluginInfosBuilder callback) {
        if (callback == null) {
            JarSearcherBase.$$$reportNull$$$0(0);
        }
        Collection<File> paths = this.getPluginPaths();
        for (File path : paths) {
            path.mkdirs();
        }
        if (paths.size() == 0) {
            throw new IllegalArgumentException("There should be at least one folder to search for plugins");
        }
        for (File path : paths) {
            LOG.info((Object)("Scanning plugin folder: " + FileUtil.getCanonicalFile((File)path).getPath()));
            this.loadPluginsFrom(path, callback);
        }
    }

    protected void loadPluginsFrom(@NotNull File _path, @NotNull PluginInfosBuilder callback) {
        File path;
        File[] pluginDirs;
        if (_path == null) {
            JarSearcherBase.$$$reportNull$$$0(1);
        }
        if (callback == null) {
            JarSearcherBase.$$$reportNull$$$0(2);
        }
        if ((pluginDirs = (path = FileUtil.getCanonicalFile((File)_path)).listFiles(this.PLUGIN_DIR_FILTER)) == null) {
            return;
        }
        for (File pluginDir : pluginDirs) {
            LOG.debug((Object)("Found plugin directory: " + pluginDir.getAbsolutePath()));
            this.processPluginDirectory(pluginDir, callback);
        }
    }

    protected boolean isPluginAccepted(@NotNull PluginInfo info) {
        if (info == null) {
            JarSearcherBase.$$$reportNull$$$0(3);
        }
        return true;
    }

    private void processPluginDirectory(@NotNull File pluginDir, @NotNull PluginInfosBuilder callback) {
        PluginInfo pluginInfo;
        if (pluginDir == null) {
            JarSearcherBase.$$$reportNull$$$0(4);
        }
        if (callback == null) {
            JarSearcherBase.$$$reportNull$$$0(5);
        }
        if (this.isPluginAccepted(pluginInfo = this.loadPluginInfo(pluginDir))) {
            callback.pluginInfoFound(pluginInfo);
        }
    }

    @Override
    @NotNull
    public abstract PluginInfo loadPluginInfo(@NotNull File var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDir";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/plugins/files/JarSearcherBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadPluginsFrom";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isPluginAccepted";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processPluginDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

