/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.plugins.files;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.TCStreamUtil;
import jetbrains.buildServer.util.ZipSlipAwareZipInputStream;
import org.jetbrains.annotations.NotNull;

public class PluginFilesUtil {
    public static final UnpackFilter ALL = new UnpackFilter(){

        @Override
        public boolean unpackEntry(@NotNull String entryName, @NotNull File toFile) {
            if (entryName == null) {
                2.$$$reportNull$$$0(0);
            }
            if (toFile == null) {
                2.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "entryName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "toFile";
                    break;
                }
            }
            objectArray[1] = "jetbrains/buildServer/plugins/files/PluginFilesUtil$2";
            objectArray[2] = "unpackEntry";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    public static List<File> listFiles(@NotNull File pluginDir, final @NotNull String ext) {
        if (pluginDir == null) {
            PluginFilesUtil.$$$reportNull$$$0(0);
        }
        if (ext == null) {
            PluginFilesUtil.$$$reportNull$$$0(1);
        }
        if (!pluginDir.exists() || !pluginDir.isDirectory()) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                PluginFilesUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        File[] files = pluginDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(ext);
            }
        });
        if (files == null) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                PluginFilesUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files) {
            list.add(FileUtil.getCanonicalFile((File)file));
        }
        ArrayList<File> arrayList = list;
        if (arrayList == null) {
            PluginFilesUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public static <T extends Throwable> void unpackPlugin(@NotNull File pluginFile, @NotNull File destDir, @NotNull UnpackHandler<T> handler) throws T {
        if (pluginFile == null) {
            PluginFilesUtil.$$$reportNull$$$0(5);
        }
        if (destDir == null) {
            PluginFilesUtil.$$$reportNull$$$0(6);
        }
        if (handler == null) {
            PluginFilesUtil.$$$reportNull$$$0(7);
        }
        PluginFilesUtil.unpackPlugin(pluginFile, destDir, handler, ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Throwable> void unpackPlugin(@NotNull File pluginFile, @NotNull File destDir, @NotNull UnpackHandler<T> handler, @NotNull UnpackFilter filter) throws T {
        block22: {
            ZipSlipAwareZipInputStream zis;
            if (pluginFile == null) {
                PluginFilesUtil.$$$reportNull$$$0(8);
            }
            if (destDir == null) {
                PluginFilesUtil.$$$reportNull$$$0(9);
            }
            if (handler == null) {
                PluginFilesUtil.$$$reportNull$$$0(10);
            }
            if (filter == null) {
                PluginFilesUtil.$$$reportNull$$$0(11);
            }
            try {
                zis = new ZipSlipAwareZipInputStream((InputStream)new BufferedInputStream(new FileInputStream(pluginFile)));
            }
            catch (IOException e) {
                handler.failedToAccessPluginArchive(e);
                return;
            }
            block12: while (true) {
                try {
                    while (true) {
                        ZipEntry ze;
                        if ((ze = zis.getNextEntry()) == null) {
                            break block22;
                        }
                        String relativePath = ze.getName();
                        while (relativePath.startsWith("/") || relativePath.startsWith("\\")) {
                            relativePath = relativePath.substring(1);
                        }
                        File file = new File(destDir, relativePath);
                        if (!filter.unpackEntry(relativePath, file)) continue;
                        handler.unpackingFile(relativePath, file);
                        try {
                            if (ze.isDirectory()) {
                                FileUtil.createDir((File)file);
                                continue block12;
                            }
                            FileUtil.createParentDirs((File)file);
                            if (file.exists()) {
                                FileUtil.delete((File)file);
                            }
                            BufferedInputStream bis = new BufferedInputStream((InputStream)zis);
                            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
                            try {
                                TCStreamUtil.writeBinary((InputStream)bis, (OutputStream)bos);
                                continue block12;
                            }
                            finally {
                                FileUtil.close((Closeable)bos);
                                continue block12;
                            }
                        }
                        catch (IOException e) {
                            handler.failedToUnpackEntry(relativePath, file, e);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    handler.failedToAccessPluginArchive(e);
                    break block22;
                }
            }
            finally {
                FileUtil.close((Closeable)zis);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ext";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/plugins/files/PluginFilesUtil";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginFile";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destDir";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/plugins/files/PluginFilesUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "listFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "listFiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unpackPlugin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface UnpackFilter {
        public boolean unpackEntry(@NotNull String var1, @NotNull File var2);
    }

    public static interface UnpackHandler<T extends Throwable> {
        public void failedToAccessPluginArchive(@NotNull Exception var1) throws T;

        public void unpackingFile(@NotNull String var1, @NotNull File var2) throws T;

        public void failedToUnpackEntry(@NotNull String var1, @NotNull File var2, @NotNull Exception var3) throws T;
    }
}

