/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.plugins.impl;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jetbrains.buildServer.plugins.NotLoadedPlugin;
import jetbrains.buildServer.plugins.PluginData;
import jetbrains.buildServer.plugins.PluginsState;
import jetbrains.buildServer.plugins.PluginsStateImpl;
import jetbrains.buildServer.plugins.PluginsStateProvider;
import jetbrains.buildServer.plugins.bean.PluginInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginsStateProviderImpl
implements PluginsStateProvider {
    @NotNull
    private final List<PluginData> myLoadedPlugins = new CopyOnWriteArrayList<PluginData>();
    @NotNull
    private final List<NotLoadedPlugin> myNotLoadedPlugins = new CopyOnWriteArrayList<NotLoadedPlugin>();

    @Override
    public PluginsState getPluginsState() {
        return new PluginsStateImpl(this.myLoadedPlugins, this.myNotLoadedPlugins);
    }

    public void removeNotLoadedPlugin(@NotNull PluginInfo pluginInfo) {
        if (pluginInfo == null) {
            PluginsStateProviderImpl.$$$reportNull$$$0(0);
        }
        for (NotLoadedPlugin notLoadedPlugin : this.myNotLoadedPlugins) {
            if (!this.isSamePlugin(notLoadedPlugin.getPlugin(), pluginInfo)) continue;
            this.myNotLoadedPlugins.remove(notLoadedPlugin);
        }
    }

    public void addLoadedPlugin(@NotNull PluginData plugin) {
        if (plugin == null) {
            PluginsStateProviderImpl.$$$reportNull$$$0(1);
        }
        this.myLoadedPlugins.add(plugin);
    }

    public void removeLoadedPlugin(@NotNull PluginData pluginData) {
        if (pluginData == null) {
            PluginsStateProviderImpl.$$$reportNull$$$0(2);
        }
        this.myLoadedPlugins.remove(pluginData);
    }

    public void addNotLoadedPlugin(@NotNull NotLoadedPlugin notLoaded) {
        if (notLoaded == null) {
            PluginsStateProviderImpl.$$$reportNull$$$0(3);
        }
        this.myNotLoadedPlugins.add(notLoaded);
    }

    @Nullable
    public PluginData findPluginData(@NotNull String pluginName) {
        if (pluginName == null) {
            PluginsStateProviderImpl.$$$reportNull$$$0(4);
        }
        for (PluginData loadedPlugin : this.myLoadedPlugins) {
            if (!loadedPlugin.getPluginName().equals(pluginName)) continue;
            return loadedPlugin;
        }
        return null;
    }

    public void pluginRemoved(@NotNull PluginInfo deleted) {
        if (deleted == null) {
            PluginsStateProviderImpl.$$$reportNull$$$0(5);
        }
        this.removeNotLoadedPlugin(deleted);
    }

    private boolean isSamePlugin(@NotNull PluginInfo left, @NotNull PluginInfo right) {
        if (left == null) {
            PluginsStateProviderImpl.$$$reportNull$$$0(6);
        }
        if (right == null) {
            PluginsStateProviderImpl.$$$reportNull$$$0(7);
        }
        return left.getPluginName().equals(right.getPluginName()) && (left.getPluginVersion() == null && right.getPluginVersion() == null || left.getPluginVersion() != null && right.getPluginVersion() != null && left.getPluginVersion().equals(right.getPluginVersion()));
    }

    public void setLoadedPlugins(@NotNull List<PluginData> list) {
        if (list == null) {
            PluginsStateProviderImpl.$$$reportNull$$$0(8);
        }
        this.myLoadedPlugins.clear();
        this.myLoadedPlugins.addAll(list);
    }

    public void setNotLoadedPlugins(@NotNull List<NotLoadedPlugin> disabled) {
        if (disabled == null) {
            PluginsStateProviderImpl.$$$reportNull$$$0(9);
        }
        this.myNotLoadedPlugins.clear();
        this.myNotLoadedPlugins.addAll(disabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notLoaded";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleted";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabled";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/plugins/impl/PluginsStateProviderImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "removeNotLoadedPlugin";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addLoadedPlugin";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeLoadedPlugin";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addNotLoadedPlugin";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findPluginData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "pluginRemoved";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isSamePlugin";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "setLoadedPlugins";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "setNotLoadedPlugins";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

