/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.plugins.impl;

import java.util.Collection;
import jetbrains.buildServer.DevelopmentMode;
import jetbrains.buildServer.plugins.PluginData;
import jetbrains.buildServer.plugins.PluginsState;
import jetbrains.buildServer.plugins.PluginsStateProvider;
import jetbrains.buildServer.plugins.ReloadablePlugins;
import jetbrains.buildServer.plugins.bean.PluginDependencyInfo;
import jetbrains.buildServer.plugins.bean.PluginInfo;
import jetbrains.buildServer.plugins.classLoaders.PluginClassLoadingInfo;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReloadablePluginsImpl
implements ReloadablePlugins {
    private static final boolean ALLOW_RELOADABLE_ON_STARTUP = TeamCityProperties.getBooleanOrTrue((String)"teamcity.plugins.allowReloadablePlugins");
    @NotNull
    private final PluginsStateProvider myPluginsStateProvider;

    public ReloadablePluginsImpl(@NotNull PluginsStateProvider pluginsStateProvider) {
        if (pluginsStateProvider == null) {
            ReloadablePluginsImpl.$$$reportNull$$$0(0);
        }
        this.myPluginsStateProvider = pluginsStateProvider;
    }

    @Override
    @Nullable
    public String canUnloadPluginInRuntime(@NotNull PluginInfo pluginInfo) {
        if (pluginInfo == null) {
            ReloadablePluginsImpl.$$$reportNull$$$0(1);
        }
        if (!ALLOW_RELOADABLE_ON_STARTUP) {
            return "plugin reload is disabled on startup by administrator";
        }
        if (!DevelopmentMode.isEnabled && !TeamCityProperties.getBoolean((String)"teamcity.plugins.allowUnloadPluginsInRuntime")) {
            return "plugin reload is currently disabled by administrator";
        }
        PluginsState pluginsState = this.myPluginsStateProvider.getPluginsState();
        PluginData pluginData = pluginsState.findPluginData(pluginInfo.getPluginName());
        if (pluginData == null) {
            return "is not loaded yet";
        }
        if (!pluginData.isAllowUnloadWithoutRestart()) {
            String notReloadableReason = this.getNotReloadableReason(pluginInfo);
            return notReloadableReason != null ? notReloadableReason : "was loaded without unload support";
        }
        Collection<PluginInfo> loadedPlugins = pluginsState.getLoadedPlugins();
        for (PluginInfo loadedPlugin : loadedPlugins) {
            for (PluginDependencyInfo dependency : loadedPlugin.getDependencies()) {
                if (!dependency.getName().equals(pluginInfo.getPluginName())) continue;
                return "there is another plugin depending on unloading one";
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String canReloadPluginInRuntime(@NotNull PluginInfo from, @NotNull PluginInfo to) {
        String cannotUnloadReason;
        if (from == null) {
            ReloadablePluginsImpl.$$$reportNull$$$0(2);
        }
        if (to == null) {
            ReloadablePluginsImpl.$$$reportNull$$$0(3);
        }
        if ((cannotUnloadReason = this.canUnloadPluginInRuntime(from)) != null) {
            return cannotUnloadReason;
        }
        if (from == to) {
            return "same plugin";
        }
        if (!from.getPluginName().equals(to.getPluginName())) {
            return "different plugins";
        }
        return this.canLoad(to, false);
    }

    @Override
    @Nullable
    public String canLoadPluginInRuntime(@NotNull PluginInfo pluginInfo) {
        if (pluginInfo == null) {
            ReloadablePluginsImpl.$$$reportNull$$$0(4);
        }
        return this.canLoad(pluginInfo, true);
    }

    @Nullable
    private String canLoad(@NotNull PluginInfo pluginInfo, boolean checkLoaded) {
        String notReloadableReason;
        if (pluginInfo == null) {
            ReloadablePluginsImpl.$$$reportNull$$$0(5);
        }
        if (!ALLOW_RELOADABLE_ON_STARTUP) {
            return "plugin reload is disabled on startup by administrator";
        }
        if (!TeamCityProperties.getBooleanOrTrue((String)"teamcity.plugins.allowLoadingNewPluginsInRuntime")) {
            return "plugin reload is currently disabled by administrator";
        }
        PluginsState pluginsState = this.myPluginsStateProvider.getPluginsState();
        if (checkLoaded && pluginsState.findPluginData(pluginInfo.getPluginName()) != null) {
            return "is already loaded";
        }
        if (!this.allowLoadNotReloadable() && (notReloadableReason = this.getNotReloadableReason(pluginInfo)) != null) {
            return "cannot load plugin: " + notReloadableReason;
        }
        for (PluginDependencyInfo dependency : pluginInfo.getDependencies()) {
            if (pluginsState.findPluginData(dependency.getName()) != null) continue;
            return "depends on other plugins which are not loaded";
        }
        return null;
    }

    @Override
    public boolean allowLoadNotReloadable() {
        return TeamCityProperties.getBooleanOrTrue((String)"teamcity.plugins.loadNotReloadablePluginsWithWrappers");
    }

    @Override
    public boolean shouldLoadPluginAsUnloadable(@NotNull PluginInfo pluginInfo) {
        if (pluginInfo == null) {
            ReloadablePluginsImpl.$$$reportNull$$$0(6);
        }
        return this.getNotReloadableReason(pluginInfo) == null;
    }

    @Nullable
    private String getNotReloadableReason(@NotNull PluginInfo pluginInfo) {
        if (pluginInfo == null) {
            ReloadablePluginsImpl.$$$reportNull$$$0(7);
        }
        if (!ALLOW_RELOADABLE_ON_STARTUP) {
            return "plugin reload is disabled on startup by administrator";
        }
        PluginClassLoadingInfo classloadingInfo = pluginInfo.getClassloadingInfo();
        if (classloadingInfo != null && !classloadingInfo.useStandaloneClassloader()) {
            return "shared classloader is used";
        }
        if (!(DevelopmentMode.isEnabled || TeamCityProperties.getBooleanOrTrue((String)"teamcity.plugins.forceAllPluginsReloadable") || pluginInfo.isRuntimeReloadAllowed())) {
            return "not marked as reloadable";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsStateProvider";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/plugins/impl/ReloadablePluginsImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "canUnloadPluginInRuntime";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canReloadPluginInRuntime";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canLoadPluginInRuntime";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "canLoad";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldLoadPluginAsUnloadable";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getNotReloadableReason";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

