/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.plugins.spring;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.plugins.PluginData;
import jetbrains.buildServer.plugins.bean.PluginInfo;
import jetbrains.buildServer.plugins.spring.PluginSpringContextDependenciesInjector;
import jetbrains.buildServer.plugins.spring.SpringPluginLoader;
import jetbrains.buildServer.util.CollectionsUtil;
import jetbrains.buildServer.util.Converter;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class PluginSpringContextDependenciesInjectorImpl
implements PluginSpringContextDependenciesInjector {
    private static final Logger LOG = Logger.getInstance((String)PluginSpringContextDependenciesInjectorImpl.class.getName());

    @Override
    public void inject(@NotNull PluginData plugin, @NotNull ConfigurableApplicationContext context) {
        Collection<PluginData> deps;
        if (plugin == null) {
            PluginSpringContextDependenciesInjectorImpl.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PluginSpringContextDependenciesInjectorImpl.$$$reportNull$$$0(1);
        }
        if ((deps = plugin.getParents()).isEmpty()) {
            return;
        }
        final LinkedList errors = new LinkedList();
        List parents = CollectionsUtil.convertAndFilterNulls(deps, (Converter)new Converter<SpringPluginLoader.TeamCityPluginContext, PluginData>(){

            public SpringPluginLoader.TeamCityPluginContext createFrom(@NotNull PluginData source) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (source.getPluginInfo().getSpringPluginInfo() == null) {
                    return null;
                }
                ConfigurableApplicationContext found = source.getSpringContext();
                if (found == null) {
                    errors.add("Spring context for plugin '" + source.getPluginName() + "' is missing");
                    return null;
                }
                if (found instanceof SpringPluginLoader.TeamCityPluginContext) {
                    return (SpringPluginLoader.TeamCityPluginContext)found;
                }
                errors.add("Spring context for plugin '" + source.getPluginName() + "' is not of TeamCityPluginContext type");
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "jetbrains/buildServer/plugins/spring/PluginSpringContextDependenciesInjectorImpl$1", "createFrom"));
            }
        });
        if (!errors.isEmpty()) {
            throw new SpringPluginLoader.PluginLoadError("Cannot inject dependencies as " + errors.size() + (deps.size() > 1 ? " out of " + deps.size() : "") + " " + StringUtil.pluralize((String)"parent", (int)errors.size()) + " " + (errors.size() > 1 ? "are" : "is") + " not available (failed to initialize properly?): " + StringUtil.join((String)", ", errors) + ".");
        }
        context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new InjectorBeanFactoryPostProcessor(parents, plugin.getPluginName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "plugin";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "jetbrains/buildServer/plugins/spring/PluginSpringContextDependenciesInjectorImpl";
        objectArray[2] = "inject";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class InjectorBeanFactoryPostProcessor
    implements BeanFactoryPostProcessor {
        private final List<SpringPluginLoader.TeamCityPluginContext> myParents;
        private final String myPluginName;

        public InjectorBeanFactoryPostProcessor(@NotNull List<SpringPluginLoader.TeamCityPluginContext> parents, @NotNull String pluginName) {
            if (parents == null) {
                InjectorBeanFactoryPostProcessor.$$$reportNull$$$0(0);
            }
            if (pluginName == null) {
                InjectorBeanFactoryPostProcessor.$$$reportNull$$$0(1);
            }
            this.myParents = parents;
            this.myPluginName = pluginName;
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            LOG.debug("Processing bean dependencies for plugin " + this.myPluginName);
            HashMap<String, IdentityHashMap<Object, SpringPluginLoader.TeamCityPluginContext>> collected = new HashMap<String, IdentityHashMap<Object, SpringPluginLoader.TeamCityPluginContext>>();
            for (SpringPluginLoader.TeamCityPluginContext teamCityPluginContext : this.myParents) {
                List<String> perPluginPredefinedNames = teamCityPluginContext.getPerPluginPredefinedNames();
                AutowireCapableBeanFactory factory = teamCityPluginContext.getAutowireCapableBeanFactory();
                if (!(factory instanceof DefaultListableBeanFactory)) {
                    LOG.warn("Incorrect bean factory:" + factory);
                    continue;
                }
                DefaultListableBeanFactory dlbf = (DefaultListableBeanFactory)factory;
                for (String defName : dlbf.getBeanDefinitionNames()) {
                    Object bean;
                    BeanDefinition definition = dlbf.getBeanDefinition(defName);
                    String beanClassName = definition.getBeanClassName();
                    try {
                        bean = dlbf.getBean(defName);
                    }
                    catch (BeansException e) {
                        LOG.debug("Problem due to obtaining bean " + beanClassName + ": " + e.getMessage());
                        continue;
                    }
                    if (perPluginPredefinedNames.contains(defName) || bean.getClass().getName().startsWith("org.springframework")) continue;
                    IdentityHashMap<Object, SpringPluginLoader.TeamCityPluginContext> imap = (IdentityHashMap<Object, SpringPluginLoader.TeamCityPluginContext>)collected.get(defName);
                    if (imap == null) {
                        imap = new IdentityHashMap<Object, SpringPluginLoader.TeamCityPluginContext>();
                        collected.put(defName, imap);
                    }
                    imap.put(bean, teamCityPluginContext);
                }
            }
            for (Map.Entry entry : collected.entrySet()) {
                String name = (String)entry.getKey();
                IdentityHashMap candidates = (IdentityHashMap)entry.getValue();
                if (candidates.size() == 1) {
                    Map.Entry candidate = candidates.entrySet().iterator().next();
                    LOG.debug("Injecting bean with name '" + name + "' from context of plugin '" + ((PluginInfo)((ApplicationContext)candidate.getValue()).getBean(PluginInfo.class)).getPluginName() + "'");
                    beanFactory.registerSingleton(name, candidate.getKey());
                    continue;
                }
                StringBuilder message = new StringBuilder();
                message.append("For bean definition with name '").append(name).append("' ").append(candidates.size()).append(" candidates found:").append('\n');
                for (Map.Entry entry2 : candidates.entrySet()) {
                    message.append("\tFrom context ").append(((PluginInfo)((ApplicationContext)entry2.getValue()).getBean(PluginInfo.class)).getPluginName()).append(" -> ").append(entry2.getKey()).append('\n');
                }
                message.append("They would be prefixed with plugin name");
                LOG.warn(message.toString());
                for (Map.Entry entry3 : candidates.entrySet()) {
                    beanFactory.registerSingleton(((PluginInfo)((ApplicationContext)entry3.getValue()).getBean(PluginInfo.class)).getPluginName() + ":" + name, entry3.getKey());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parents";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pluginName";
                    break;
                }
            }
            objectArray[1] = "jetbrains/buildServer/plugins/spring/PluginSpringContextDependenciesInjectorImpl$InjectorBeanFactoryPostProcessor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

