/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.plugins.spring;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jetbrains.buildServer.plugins.spring.SpringPluginInfo;
import org.jetbrains.annotations.NotNull;
import org.springframework.util.AntPathMatcher;

public abstract class SpringContextXmlFinder {
    private static final Logger LOG = Logger.getInstance((String)SpringContextXmlFinder.class.getName());
    private final Collection<String> myMatcherExtension;

    protected SpringContextXmlFinder(@NotNull SpringPluginInfo info) {
        if (info == null) {
            SpringContextXmlFinder.$$$reportNull$$$0(0);
        }
        this.myMatcherExtension = info.getConfigWildcards();
        for (File pluginPartInfo : info.getPluginJarFiles()) {
            this.findSpringConfigAndExtract(pluginPartInfo);
        }
    }

    protected abstract void onPluginXmlFound(@NotNull File var1, @NotNull ZipFile var2, @NotNull ZipEntry var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findSpringConfigAndExtract(File jar) {
        AntPathMatcher matcher = new AntPathMatcher();
        try (ZipFile file = new ZipFile(jar);){
            Enumeration<? extends ZipEntry> filez = file.entries();
            while (filez.hasMoreElements()) {
                ZipEntry entry = filez.nextElement();
                String entryPath = entry.getName();
                for (String expr : this.myMatcherExtension) {
                    if (!matcher.match(expr, entryPath)) continue;
                    LOG.debug("Found spring config: " + entryPath);
                    this.onPluginXmlFound(jar, file, entry);
                }
            }
        }
        catch (IOException e) {
            LOG.error("Failed to process plugin .jar file: " + jar.getPath() + ", " + e.getMessage(), (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "jetbrains/buildServer/plugins/spring/SpringContextXmlFinder", "<init>"));
    }
}

