/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.plugins.spring;

import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.Used;
import jetbrains.buildServer.plugins.DisposablePerPluginRegistry;
import jetbrains.buildServer.plugins.PluginClassesLoadedListener;
import jetbrains.buildServer.plugins.PluginData;
import jetbrains.buildServer.plugins.PluginManager;
import jetbrains.buildServer.plugins.bean.PluginInfo;
import jetbrains.buildServer.plugins.classLoaders.SpringScriptingClassloadingUtil;
import jetbrains.buildServer.plugins.classLoaders.TeamCityClassLoader;
import jetbrains.buildServer.plugins.spring.PluginContextUpdater;
import jetbrains.buildServer.plugins.spring.PluginSpringConfigsProvider;
import jetbrains.buildServer.plugins.spring.PluginSpringContextDependenciesInjector;
import jetbrains.buildServer.plugins.spring.PluginSpringContextListener;
import jetbrains.buildServer.plugins.spring.PluginSpringContextLoader;
import jetbrains.buildServer.plugins.spring.SpringPluginConfigExtracter;
import jetbrains.buildServer.plugins.spring.SpringPluginInfo;
import jetbrains.buildServer.util.Disposable;
import jetbrains.buildServer.util.EventDispatcher;
import jetbrains.buildServer.util.NamedDaemonThreadFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class SpringPluginLoader
implements PluginClassesLoadedListener,
PluginSpringContextLoader {
    private static final Logger LOG = Logger.getInstance((String)SpringPluginLoader.class.getName());
    @NotNull
    private final Collection<PluginSpringConfigsProvider> myConfigProviders;
    @NotNull
    private final Collection<PluginContextUpdater> myProxyBeansProviders;
    @NotNull
    private final PluginSpringContextDependenciesInjector myInjector;
    @Nullable
    private final ApplicationContext myRootContext;
    @NotNull
    private final EventDispatcher<PluginSpringContextListener> myEvent;

    public SpringPluginLoader(@Nullable ApplicationContext rootContext, @NotNull PluginManager pluginClassesLoader, @NotNull Collection<PluginSpringConfigsProvider> configProviders, @NotNull PluginSpringContextDependenciesInjector injector, @Nullable Collection<PluginSpringContextListener> listeners, @NotNull Collection<PluginContextUpdater> proxyBeansProviders) {
        if (pluginClassesLoader == null) {
            SpringPluginLoader.$$$reportNull$$$0(0);
        }
        if (configProviders == null) {
            SpringPluginLoader.$$$reportNull$$$0(1);
        }
        if (injector == null) {
            SpringPluginLoader.$$$reportNull$$$0(2);
        }
        if (proxyBeansProviders == null) {
            SpringPluginLoader.$$$reportNull$$$0(3);
        }
        this.myEvent = EventDispatcher.create(PluginSpringContextListener.class);
        this.myRootContext = rootContext;
        this.myConfigProviders = configProviders;
        this.myInjector = injector;
        this.myProxyBeansProviders = new ArrayList<PluginContextUpdater>(proxyBeansProviders);
        pluginClassesLoader.addPluginClassesLoadedListener(this);
        if (listeners != null) {
            for (PluginSpringContextListener listener : listeners) {
                this.addSpringListener(listener);
            }
        }
    }

    public SpringPluginLoader(@Nullable ApplicationContext rootContext, @NotNull PluginManager pluginClassesLoader, @NotNull Collection<PluginSpringConfigsProvider> configProviders, @NotNull PluginSpringContextDependenciesInjector injector, @Nullable Collection<PluginSpringContextListener> listeners) {
        if (pluginClassesLoader == null) {
            SpringPluginLoader.$$$reportNull$$$0(4);
        }
        if (configProviders == null) {
            SpringPluginLoader.$$$reportNull$$$0(5);
        }
        if (injector == null) {
            SpringPluginLoader.$$$reportNull$$$0(6);
        }
        this(rootContext, pluginClassesLoader, configProviders, injector, listeners, Collections.emptyList());
    }

    @Override
    public void addSpringListener(@NotNull PluginSpringContextListener listener) {
        if (listener == null) {
            SpringPluginLoader.$$$reportNull$$$0(7);
        }
        this.myEvent.addListener((EventListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pluginClassesLoaded(@NotNull PluginData _plugin) {
        if (_plugin == null) {
            SpringPluginLoader.$$$reportNull$$$0(8);
        }
        Disposable disp = NamedDaemonThreadFactory.patchThreadName((String)("Initializing Spring context for plugin: " + _plugin.getPluginName()));
        try {
            PluginInfo info = _plugin.getPluginInfo();
            SpringPluginInfo plugin = info.getSpringPluginInfo();
            if (plugin == null) {
                return;
            }
            SpringPluginConfigExtracter extracter = this.createExtracter();
            Map<String, byte[]> pluginConfig = extracter.extractSpringConfigFiles(plugin);
            ArrayList<String> configs = new ArrayList<String>();
            ArrayList<Object> singletons = new ArrayList<Object>();
            for (PluginSpringConfigsProvider configProvider : this.myConfigProviders) {
                configs.addAll(configProvider.getPluginResources(info));
                singletons.addAll(configProvider.getPluginSingletons(info));
            }
            ConfigLocations locations = new ConfigLocations(configs, new ArrayList<String>(plugin.getExplicitSpringConfigs()), pluginConfig);
            TeamCityPluginIntermediateContext intermediate = !_plugin.getParents().isEmpty() ? new TeamCityPluginIntermediateContext(this.myRootContext, _plugin, this.myInjector) : null;
            TeamCityPluginContext ctx = new TeamCityPluginContext((ApplicationContext)(intermediate != null ? intermediate : this.myRootContext), _plugin, singletons, locations, this.myProxyBeansProviders);
            ArrayList springConfigs = new ArrayList();
            springConfigs.addAll(locations.getPerPluginConfigLocations());
            springConfigs.addAll(locations.getGlobalConfigLocations());
            LOG.debug("Setting up plugin Application context on: " + springConfigs);
            ((PluginSpringContextListener)this.myEvent.getMulticaster()).contextCreated((ApplicationContext)ctx, info);
            SpringScriptingClassloadingUtil.extendClassLoaderForScriptingLanguagesInSpring(_plugin);
            try {
                if (intermediate != null) {
                    intermediate.refresh();
                }
                _plugin.setSpringContext((ConfigurableApplicationContext)ctx);
                ctx.refresh();
                ((PluginSpringContextListener)this.myEvent.getMulticaster()).contextLoaded((ApplicationContext)ctx, info);
            }
            catch (PluginLoadError t) {
                _plugin.addLoadError(t);
                LOG.error("Error loading plugin '" + info.getPluginName() + "': Failed to initialize spring context: " + t.getMessage());
                ((PluginSpringContextListener)this.myEvent.getMulticaster()).contextFailedToLoad((ApplicationContext)ctx, info, t);
            }
            catch (Throwable t) {
                _plugin.addLoadError(t);
                LOG.error("Error loading plugin '" + info.getPluginName() + "': Failed to initialize spring context: " + t.getMessage(), t);
                ((PluginSpringContextListener)this.myEvent.getMulticaster()).contextFailedToLoad((ApplicationContext)ctx, info, t);
            }
        }
        finally {
            disp.dispose();
        }
    }

    protected SpringPluginConfigExtracter createExtracter() {
        return new SpringPluginConfigExtracter();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginClassesLoader";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configProviders";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxyBeansProviders";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_plugin";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/plugins/spring/SpringPluginLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addSpringListener";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "pluginClassesLoaded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Used(value="log4j configuration")
    static class TeamCityPluginContext
    extends FileSystemXmlApplicationContext {
        private final String myPrefix;
        private final PluginData myPlugin;
        private final ClassLoader myClassLoader;
        private final List<Object> mySingletons;
        private final ConfigLocations myConfigLocations;
        private final Collection<PluginContextUpdater> myPluginContextUpdaters;
        private final List<String> myPerPluginPredefinedNames;

        public TeamCityPluginContext(@Nullable ApplicationContext parent, @NotNull PluginData plugin, @NotNull List<Object> singletons, @NotNull ConfigLocations configLocations, Collection<PluginContextUpdater> pluginContextUpdaters) {
            if (plugin == null) {
                TeamCityPluginContext.$$$reportNull$$$0(0);
            }
            if (singletons == null) {
                TeamCityPluginContext.$$$reportNull$$$0(1);
            }
            if (configLocations == null) {
                TeamCityPluginContext.$$$reportNull$$$0(2);
            }
            super(parent);
            this.myPerPluginPredefinedNames = new ArrayList<String>();
            this.myPrefix = "jonnyzzz://" + plugin.getPluginName() + "/";
            this.myPlugin = plugin;
            this.myClassLoader = plugin.getClassloader();
            this.mySingletons = singletons;
            this.myConfigLocations = configLocations;
            this.myPluginContextUpdaters = pluginContextUpdaters;
            this.setAllowBeanDefinitionOverriding(true);
            this.setDisplayName("Plugin " + plugin.getPluginName());
            this.setClassLoader(this.myClassLoader);
        }

        protected void destroyBeans() {
            try {
                Collection values = this.getBeansOfType(DisposablePerPluginRegistry.class).values();
                for (DisposablePerPluginRegistry value : values) {
                    value.beforeDispose();
                }
                for (DisposablePerPluginRegistry value : values) {
                    value.dispose();
                }
            }
            catch (Exception ex) {
                LOG.warnAndDebugDetails("Error occurred during destroying beans for plugin " + this.myPlugin, (Throwable)ex);
            }
            super.destroyBeans();
        }

        protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
            super.prepareBeanFactory(beanFactory);
            String name = this.myPlugin.getPluginName();
            beanFactory.registerSingleton("plugin-descriptor-" + name, (Object)this.myPlugin.getPluginInfo());
            if (this.myClassLoader instanceof TeamCityClassLoader) {
                beanFactory.registerSingleton("plugin-classloader-" + name, (Object)this.myClassLoader);
            }
            int i = 0;
            for (Object o : this.mySingletons) {
                beanFactory.registerSingleton("singleton-" + o.getClass().getName() + "@" + i++, o);
            }
            for (PluginContextUpdater provider : this.myPluginContextUpdaters) {
                provider.updatePluginContext(beanFactory, this.myPlugin);
            }
        }

        public Resource getResource(@NotNull String location) {
            if (location == null) {
                TeamCityPluginContext.$$$reportNull$$$0(3);
            }
            if (location.startsWith(this.myPrefix)) {
                String resource = location.substring(this.myPrefix.length());
                byte[] bytes = (byte[])this.myConfigLocations.getPluginConfigs().get(resource);
                if (bytes != null) {
                    return new ByteArrayResource(bytes, "plugin: " + this.myPlugin.getPluginName() + "#" + resource);
                }
            }
            return super.getResource(location);
        }

        protected void loadBeanDefinitions(XmlBeanDefinitionReader reader) throws BeansException, IOException {
            Resource[] configResources = this.getConfigResources();
            if (configResources != null) {
                reader.loadBeanDefinitions(configResources);
            }
            ArrayList<String> customPrefixedConfigs = new ArrayList<String>();
            for (String key : this.myConfigLocations.getPluginConfigs().keySet()) {
                customPrefixedConfigs.add(this.myPrefix + key);
            }
            this.doLoadBeanDefinitions(reader, this.myConfigLocations.getPerPluginConfigLocations());
            BeanDefinitionRegistry factory = reader.getBeanFactory();
            String[] names = factory.getBeanDefinitionNames();
            Collections.addAll(this.myPerPluginPredefinedNames, names);
            this.doLoadBeanDefinitions(reader, this.myConfigLocations.getGlobalConfigLocations());
            this.doLoadBeanDefinitions(reader, customPrefixedConfigs);
        }

        private void doLoadBeanDefinitions(XmlBeanDefinitionReader reader, List<String> locations) {
            for (String location : locations) {
                HashSet resources = new HashSet();
                int count = reader.loadBeanDefinitions(location, resources);
                LOG.debug("Loaded " + count + " bean definitions from resource " + resources);
            }
        }

        public List<String> getPerPluginPredefinedNames() {
            return this.myPerPluginPredefinedNames;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "plugin";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "singletons";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configLocations";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "location";
                    break;
                }
            }
            objectArray2[1] = "jetbrains/buildServer/plugins/spring/SpringPluginLoader$TeamCityPluginContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getResource";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @Used(value="log4j configuration")
    static class TeamCityPluginIntermediateContext
    extends FileSystemXmlApplicationContext {
        @NotNull
        private final PluginData myPlugin;
        @NotNull
        private final PluginSpringContextDependenciesInjector myDependenciesInjector;

        public TeamCityPluginIntermediateContext(@Nullable ApplicationContext parent, @NotNull PluginData plugin, @NotNull PluginSpringContextDependenciesInjector injector) {
            if (plugin == null) {
                TeamCityPluginIntermediateContext.$$$reportNull$$$0(0);
            }
            if (injector == null) {
                TeamCityPluginIntermediateContext.$$$reportNull$$$0(1);
            }
            super(parent);
            this.myPlugin = plugin;
            this.myDependenciesInjector = injector;
            this.setDisplayName("Plugin " + plugin.getPluginName() + " dependencies");
            this.setClassLoader(plugin.getClassloader());
        }

        protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
            super.prepareBeanFactory(beanFactory);
            this.myDependenciesInjector.inject(this.myPlugin, (ConfigurableApplicationContext)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "plugin";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "injector";
                    break;
                }
            }
            objectArray[1] = "jetbrains/buildServer/plugins/spring/SpringPluginLoader$TeamCityPluginIntermediateContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ConfigLocations {
        private final List<String> myPerPluginConfigLocations;
        private final List<String> myGlobalConfigLocations;
        private final Map<String, byte[]> myPluginConfigs;

        private ConfigLocations(@NotNull List<String> perPluginConfigLocations, @NotNull List<String> globalConfigLocations, @NotNull Map<String, byte[]> pluginConfigs) {
            if (perPluginConfigLocations == null) {
                ConfigLocations.$$$reportNull$$$0(0);
            }
            if (globalConfigLocations == null) {
                ConfigLocations.$$$reportNull$$$0(1);
            }
            if (pluginConfigs == null) {
                ConfigLocations.$$$reportNull$$$0(2);
            }
            this.myPerPluginConfigLocations = perPluginConfigLocations;
            this.myGlobalConfigLocations = globalConfigLocations;
            this.myPluginConfigs = pluginConfigs;
        }

        private List<String> getPerPluginConfigLocations() {
            return this.myPerPluginConfigLocations;
        }

        private List<String> getGlobalConfigLocations() {
            return this.myGlobalConfigLocations;
        }

        private Map<String, byte[]> getPluginConfigs() {
            return this.myPluginConfigs;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "perPluginConfigLocations";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "globalConfigLocations";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pluginConfigs";
                    break;
                }
            }
            objectArray[1] = "jetbrains/buildServer/plugins/spring/SpringPluginLoader$ConfigLocations";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class PluginLoadError
    extends RuntimeException {
        PluginLoadError(String message) {
            super(message);
        }
    }
}

