/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.plugins.xml;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import jetbrains.buildServer.plugins.xml.PluginXmlParseException;
import jetbrains.buildServer.util.XMLParser;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ValidatingXmlLoader<T> {
    private static final Logger LOG = Logger.getInstance((String)ValidatingXmlLoader.class.getName());
    @NotNull
    private final Class myClass;
    @NotNull
    private final String myPath;

    public ValidatingXmlLoader(@NotNull Class clazz, @NotNull String path) {
        if (clazz == null) {
            ValidatingXmlLoader.$$$reportNull$$$0(0);
        }
        if (path == null) {
            ValidatingXmlLoader.$$$reportNull$$$0(1);
        }
        this.myClass = clazz;
        this.myPath = path;
    }

    public T parse(final @NotNull File pluginXml, @NotNull Parser<T> parser) throws PluginXmlParseException {
        if (pluginXml == null) {
            ValidatingXmlLoader.$$$reportNull$$$0(2);
        }
        if (parser == null) {
            ValidatingXmlLoader.$$$reportNull$$$0(3);
        }
        return new XmlLoader(){

            @Override
            protected Document buildDocument(@NotNull SAXBuilder builder) throws JDOMException, IOException, PluginXmlParseException {
                if (builder == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!pluginXml.isFile()) {
                    throw new PluginXmlParseException("File " + pluginXml.getPath() + " was not found");
                }
                return builder.build(pluginXml);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "jetbrains/buildServer/plugins/xml/ValidatingXmlLoader$1", "buildDocument"));
            }
        }.parse(parser);
    }

    public T parse(final @NotNull InputStream stream, @NotNull Parser<T> parser) throws PluginXmlParseException {
        if (stream == null) {
            ValidatingXmlLoader.$$$reportNull$$$0(4);
        }
        if (parser == null) {
            ValidatingXmlLoader.$$$reportNull$$$0(5);
        }
        return new XmlLoader(){

            @Override
            protected Document buildDocument(@NotNull SAXBuilder builder) throws JDOMException, IOException {
                if (builder == null) {
                    2.$$$reportNull$$$0(0);
                }
                return builder.build(stream);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "jetbrains/buildServer/plugins/xml/ValidatingXmlLoader$2", "buildDocument"));
            }
        }.parse(parser);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginXml";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/plugins/xml/ValidatingXmlLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "parse";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Parser<T> {
        @Nullable
        public T parseDocument(@NotNull Element var1) throws PluginXmlParseException;
    }

    private abstract class XmlLoader {
        private XmlLoader() {
        }

        public T parse(@NotNull Parser<T> parser) throws PluginXmlParseException {
            if (parser == null) {
                XmlLoader.$$$reportNull$$$0(0);
            }
            try {
                final String schemaUrl = "urn:resource:" + ValidatingXmlLoader.this.myClass.getCanonicalName() + ":" + ValidatingXmlLoader.this.myPath;
                SAXBuilder builder = XMLParser.createSAXBuilder((boolean)true);
                builder.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)schemaUrl);
                builder.setEntityResolver((EntityResolver)new XMLParser.SafeEntityResolver(){

                    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
                        InputStream stream;
                        if (schemaUrl.equals(systemId) && (stream = ValidatingXmlLoader.this.myClass.getResourceAsStream(ValidatingXmlLoader.this.myPath)) != null) {
                            InputSource source = new InputSource(stream);
                            source.setPublicId(publicId);
                            source.setSystemId(systemId);
                            return source;
                        }
                        return super.resolveEntity(publicId, systemId);
                    }
                });
                Document doc = this.buildDocument(builder);
                return parser.parseDocument(doc.getRootElement());
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
                throw new PluginXmlParseException(e);
            }
            catch (IOException e) {
                throw new PluginXmlParseException("Failed to read plugin descriptor. " + e.getMessage(), e);
            }
            catch (JDOMException e) {
                throw new PluginXmlParseException("Failed to parse plugin descriptor. " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new PluginXmlParseException("Unexpected exception in parsing plugin descriptor. " + e.getMessage(), e);
            }
        }

        protected abstract Document buildDocument(@NotNull SAXBuilder var1) throws JDOMException, IOException, PluginXmlParseException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "jetbrains/buildServer/plugins/xml/ValidatingXmlLoader$XmlLoader", "parse"));
        }
    }
}

