/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.plugins.xml.agent;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jetbrains.buildServer.plugins.AgentExtensionType;
import jetbrains.buildServer.plugins.xml.PluginXmlParseException;
import jetbrains.buildServer.plugins.xml.ValidatingXmlLoader;
import jetbrains.buildServer.plugins.xml.agent.AgentPluginXml;
import jetbrains.buildServer.plugins.xml.agent.AgentPluginXmlParser;
import jetbrains.buildServer.util.StringUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class AgentPluginXmlParserImpl
implements AgentPluginXmlParser,
ValidatingXmlLoader.Parser<AgentPluginXml> {
    private static final String XSD_FILE = "agent-plugin-descriptor.xsd";
    private final ValidatingXmlLoader<AgentPluginXml> myLoader = new ValidatingXmlLoader(this.getClass(), "agent-plugin-descriptor.xsd");

    @Override
    @NotNull
    public AgentPluginXml parsePluginDescriptor(@NotNull File xml) throws PluginXmlParseException {
        if (xml == null) {
            AgentPluginXmlParserImpl.$$$reportNull$$$0(0);
        }
        AgentPluginXml agentPluginXml = this.myLoader.parse(xml, (ValidatingXmlLoader.Parser<AgentPluginXml>)this);
        if (agentPluginXml == null) {
            AgentPluginXmlParserImpl.$$$reportNull$$$0(1);
        }
        return agentPluginXml;
    }

    @Override
    @NotNull
    public AgentPluginXml parsePluginDescriptor(@NotNull InputStream is) throws PluginXmlParseException {
        if (is == null) {
            AgentPluginXmlParserImpl.$$$reportNull$$$0(2);
        }
        AgentPluginXml agentPluginXml = this.myLoader.parse(is, (ValidatingXmlLoader.Parser<AgentPluginXml>)this);
        if (agentPluginXml == null) {
            AgentPluginXmlParserImpl.$$$reportNull$$$0(3);
        }
        return agentPluginXml;
    }

    private Collection<String> parseExecutableFiles(@NotNull Element deployment) {
        Element layout;
        if (deployment == null) {
            AgentPluginXmlParserImpl.$$$reportNull$$$0(4);
        }
        if ((layout = deployment.getChild("layout")) == null) {
            return Collections.emptyList();
        }
        Element executableFiles = layout.getChild("executable-files");
        if (executableFiles == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Object _include : executableFiles.getChildren("include")) {
            Element incl = (Element)_include;
            String name = incl.getAttributeValue("name");
            if (StringUtil.isEmptyOrSpaces((String)name)) continue;
            list.add(name);
        }
        return list;
    }

    @Override
    public AgentPluginXml parseDocument(@NotNull Element doc) throws PluginXmlParseException {
        if (doc == null) {
            AgentPluginXmlParserImpl.$$$reportNull$$$0(5);
        }
        if (!"teamcity-agent-plugin".equals(doc.getName())) {
            throw new PluginXmlParseException("Wrong xml");
        }
        List<AgentPluginXml.Dependency> deps = this.parseDependencies(doc);
        Element toolDeployment = doc.getChild("tool-deployment");
        if (toolDeployment != null) {
            return new AgentPluginXml(false, AgentExtensionType.TOOL, this.parseExecutableFiles(toolDeployment), deps);
        }
        Element deployment = doc.getChild("plugin-deployment");
        if (deployment != null) {
            boolean useStandaloneClassloader = "true".equalsIgnoreCase(deployment.getAttributeValue("use-separate-classloader"));
            return new AgentPluginXml(useStandaloneClassloader, AgentExtensionType.PLUGIN, this.parseExecutableFiles(deployment), deps);
        }
        throw new PluginXmlParseException("Unexpected xml");
    }

    @NotNull
    private List<AgentPluginXml.Dependency> parseDependencies(@NotNull Element deployment) throws PluginXmlParseException {
        if (deployment == null) {
            AgentPluginXmlParserImpl.$$$reportNull$$$0(6);
        }
        Element deps = deployment.getChild("dependencies");
        ArrayList<AgentPluginXml.Dependency> result = new ArrayList<AgentPluginXml.Dependency>();
        if (deps == null) {
            ArrayList<AgentPluginXml.Dependency> arrayList = result;
            if (arrayList == null) {
                AgentPluginXmlParserImpl.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        AgentPluginXmlParserImpl.parseDependencyType(deps, "plugin", result);
        AgentPluginXmlParserImpl.parseDependencyType(deps, "tool", result);
        ArrayList<AgentPluginXml.Dependency> arrayList = result;
        if (arrayList == null) {
            AgentPluginXmlParserImpl.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static void parseDependencyType(@NotNull Element deps, @NotNull String type, @NotNull ArrayList<AgentPluginXml.Dependency> result) throws PluginXmlParseException {
        if (deps == null) {
            AgentPluginXmlParserImpl.$$$reportNull$$$0(9);
        }
        if (type == null) {
            AgentPluginXmlParserImpl.$$$reportNull$$$0(10);
        }
        if (result == null) {
            AgentPluginXmlParserImpl.$$$reportNull$$$0(11);
        }
        for (Object o : deps.getChildren(type)) {
            String name = ((Element)o).getAttributeValue("name");
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                throw new PluginXmlParseException("Attribute 'name' for tag '" + type + "' should not be empty");
            }
            result.add(new AgentPluginXml.Dependency(name, Boolean.parseBoolean(((Element)o).getAttributeValue("optional"))));
        }
    }

    @Override
    @NotNull
    public AgentPluginXml getDefaultDescriptor(@NotNull AgentExtensionType type) {
        if (type == null) {
            AgentPluginXmlParserImpl.$$$reportNull$$$0(12);
        }
        AgentPluginXml agentPluginXml = new AgentPluginXml(false, type, Collections.emptyList(), Collections.emptyList());
        if (agentPluginXml == null) {
            AgentPluginXmlParserImpl.$$$reportNull$$$0(13);
        }
        return agentPluginXml;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xml";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/plugins/xml/agent/AgentPluginXmlParserImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "is";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployment";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deps";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/plugins/xml/agent/AgentPluginXmlParserImpl";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePluginDescriptor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDependencies";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parsePluginDescriptor";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseExecutableFiles";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseDocument";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseDependencies";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseDependencyType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

