/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.problems;

import com.intellij.openapi.diagnostic.Logger;
import jetbrains.buildServer.BuildProblemData;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.problems.FailureTextNormalizer;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildProblemUtil {
    public static final String DESCRIPTION = "description";
    public static final String IDENTITY = "identity";
    public static final String TYPE = "type";
    public static final String ADDITIONAL_DATA = "additionalData";
    private static final Logger LOG = Logger.getInstance((String)BuildProblemUtil.class.getName());

    public static BuildProblemData createBuildProblem(@NotNull String type, @NotNull String description) {
        if (type == null) {
            BuildProblemUtil.$$$reportNull$$$0(0);
        }
        if (description == null) {
            BuildProblemUtil.$$$reportNull$$$0(1);
        }
        return BuildProblemUtil.createBuildProblemWithAdditionalData(type, description, null);
    }

    public static BuildProblemData createBuildProblem(@NotNull String type, @NotNull String description, @Nullable String workingDir) {
        if (type == null) {
            BuildProblemUtil.$$$reportNull$$$0(2);
        }
        if (description == null) {
            BuildProblemUtil.$$$reportNull$$$0(3);
        }
        return BuildProblemUtil.createBuildProblemWithAdditionalData(type, description, null, workingDir);
    }

    public static BuildProblemData createBuildProblemWithAdditionalData(@NotNull String type, @NotNull String description, @Nullable String additionalData) {
        if (type == null) {
            BuildProblemUtil.$$$reportNull$$$0(4);
        }
        if (description == null) {
            BuildProblemUtil.$$$reportNull$$$0(5);
        }
        return BuildProblemUtil.createBuildProblemWithAdditionalData(type, description, additionalData, null);
    }

    public static BuildProblemData createBuildProblem(@NotNull String type, @NotNull String description, @Nullable String additionalData, @Nullable String workingDir) {
        if (type == null) {
            BuildProblemUtil.$$$reportNull$$$0(6);
        }
        if (description == null) {
            BuildProblemUtil.$$$reportNull$$$0(7);
        }
        return BuildProblemUtil.createBuildProblemWithAdditionalData(type, description, additionalData, workingDir);
    }

    public static BuildProblemData createBuildProblemWithAdditionalData(@NotNull String type, @NotNull String description, @Nullable String additionalData, @Nullable String workingDir) {
        if (type == null) {
            BuildProblemUtil.$$$reportNull$$$0(8);
        }
        if (description == null) {
            BuildProblemUtil.$$$reportNull$$$0(9);
        }
        return BuildProblemData.createBuildProblem((String)BuildProblemUtil.getIdentityForText(description, workingDir), (String)type, (String)description, (String)additionalData);
    }

    @NotNull
    public static String getIdentityForText(@NotNull String text) {
        if (text == null) {
            BuildProblemUtil.$$$reportNull$$$0(10);
        }
        String string = BuildProblemUtil.getIdentityForText(text, null);
        if (string == null) {
            BuildProblemUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static String getIdentityForText(@NotNull String text, @Nullable String workingDir) {
        if (text == null) {
            BuildProblemUtil.$$$reportNull$$$0(12);
        }
        String string = String.valueOf(BuildProblemUtil.normalizeText(text, workingDir).hashCode());
        if (string == null) {
            BuildProblemUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static BuildProblemData createSingletonBuildProblem(String type, String description) {
        return BuildProblemData.createBuildProblem((String)type, (String)type, (String)description);
    }

    @NotNull
    private static String normalizeText(@NotNull String text, @Nullable String baseDir) {
        if (text == null) {
            BuildProblemUtil.$$$reportNull$$$0(14);
        }
        String string = FailureTextNormalizer.normalizeText(text, baseDir);
        if (string == null) {
            BuildProblemUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static BuildProblemData createFromServiceMessage(@NotNull ServiceMessage serviceMessage, @Nullable String workingDir) throws IllegalArgumentException {
        String type;
        String description;
        if (serviceMessage == null) {
            BuildProblemUtil.$$$reportNull$$$0(16);
        }
        if (StringUtil.isEmptyOrSpaces((String)(description = BuildProblemUtil.getAttributeValue(DESCRIPTION, serviceMessage)))) {
            throw new IllegalArgumentException("\"description\" attribute must be a non-empty value for \"buildProblem\" service message");
        }
        String identity = BuildProblemUtil.getAttributeValue(IDENTITY, serviceMessage);
        if (StringUtil.isNotEmpty((String)identity) && identity.length() > 60) {
            identity = null;
            String err = "\"identity\" attribute will be ignored as it's longer than maximum supported threshold 60 characters. Build problem identity will be calculated based on the \"description\" attribute";
            LOG.warn("\"identity\" attribute will be ignored as it's longer than maximum supported threshold 60 characters. Build problem identity will be calculated based on the \"description\" attribute: " + serviceMessage.asString().substring(2));
        }
        if (StringUtil.isEmptyOrSpaces((String)(type = BuildProblemUtil.getAttributeValue(TYPE, serviceMessage)))) {
            type = "TC_SERVICE_MESSAGE";
        }
        String additionalData = BuildProblemUtil.getAttributeValue(ADDITIONAL_DATA, serviceMessage);
        if (StringUtil.isEmptyOrSpaces((String)identity)) {
            BuildProblemData buildProblemData = BuildProblemUtil.createBuildProblemWithAdditionalData(type, description, additionalData, workingDir);
            if (buildProblemData == null) {
                BuildProblemUtil.$$$reportNull$$$0(17);
            }
            return buildProblemData;
        }
        BuildProblemData buildProblemData = BuildProblemData.createBuildProblem((String)identity, (String)type, (String)description, (String)additionalData);
        if (buildProblemData == null) {
            BuildProblemUtil.$$$reportNull$$$0(18);
        }
        return buildProblemData;
    }

    @Nullable
    private static String getAttributeValue(@NotNull String name, @NotNull ServiceMessage serviceMessage) {
        if (name == null) {
            BuildProblemUtil.$$$reportNull$$$0(19);
        }
        if (serviceMessage == null) {
            BuildProblemUtil.$$$reportNull$$$0(20);
        }
        return (String)serviceMessage.getAttributes().get(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = TYPE;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = DESCRIPTION;
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/problems/BuildProblemUtil";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceMessage";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/problems/BuildProblemUtil";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentityForText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeText";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromServiceMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createBuildProblem";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createBuildProblemWithAdditionalData";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIdentityForText";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "normalizeText";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createFromServiceMessage";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

