/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.problems;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FailureTextNormalizer {
    private static final Pattern LINE_SEPARATOR = Pattern.compile("\r?\n");
    private static final Pattern LINE_NUMBER_DOT_NET = Pattern.compile("\\(\\d+, \\d+\\):");
    private static final Pattern LINE_NUMBER_JAVA = Pattern.compile(":\\d+: ");

    @NotNull
    public static String normalizeText(@NotNull String text) {
        if (text == null) {
            FailureTextNormalizer.$$$reportNull$$$0(0);
        }
        String string = FailureTextNormalizer.normalizeText(text, null);
        if (string == null) {
            FailureTextNormalizer.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String normalizeText(@NotNull String text, @Nullable String baseDir) {
        if (text == null) {
            FailureTextNormalizer.$$$reportNull$$$0(2);
        }
        String string = FailureTextNormalizer.normalizeLines(Arrays.asList(LINE_SEPARATOR.split(text)), baseDir);
        if (string == null) {
            FailureTextNormalizer.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String normalizeLines(@NotNull List<String> lines, @Nullable String baseDir) {
        if (lines == null) {
            FailureTextNormalizer.$$$reportNull$$$0(4);
        }
        StringBuilder res = new StringBuilder();
        FailureTextNormalizer.normalizeLines(lines, baseDir, res);
        String string = res.toString();
        if (string == null) {
            FailureTextNormalizer.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static void normalizeLines(@NotNull List<String> lines, @Nullable String baseDir, @NotNull StringBuilder normalizedText) {
        if (lines == null) {
            FailureTextNormalizer.$$$reportNull$$$0(6);
        }
        if (normalizedText == null) {
            FailureTextNormalizer.$$$reportNull$$$0(7);
        }
        StringBuilder result = new StringBuilder();
        String unifiedBaseDir = StringUtil.removeTailingSlash((String)FailureTextNormalizer.unify(baseDir));
        for (String rawLine : lines) {
            for (String subLine : LINE_SEPARATOR.split(rawLine)) {
                FailureTextNormalizer.append(result, FailureTextNormalizer.normalizeLine(unifiedBaseDir, FailureTextNormalizer.unify(subLine)));
            }
        }
        FailureTextNormalizer.removeSpaces(result, normalizedText);
    }

    @Nullable
    private static String normalizeLine(@Nullable String baseDir, @Nullable String line) {
        if (StringUtil.isEmptyOrSpaces((String)line)) {
            return null;
        }
        if (StringUtil.isNotEmpty((String)baseDir)) {
            line = line.replace(baseDir, "");
        }
        return LINE_NUMBER_JAVA.matcher(LINE_NUMBER_DOT_NET.matcher(line).replaceAll("")).replaceAll("");
    }

    @Nullable
    private static String unify(@Nullable String path) {
        return path == null ? null : path.replace('\\', '/').toLowerCase().trim();
    }

    private static void append(@NotNull StringBuilder sb, @Nullable String s) {
        if (sb == null) {
            FailureTextNormalizer.$$$reportNull$$$0(8);
        }
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return;
        }
        sb.append(s);
    }

    private static void removeSpaces(@Nullable StringBuilder before, @Nullable StringBuilder after) {
        if (before == null || after == null) {
            return;
        }
        for (int i = 0; i < before.length(); ++i) {
            Character c = Character.valueOf(before.charAt(i));
            if (Character.isWhitespace(c.charValue())) continue;
            after.append(c);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/problems/FailureTextNormalizer";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedText";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/problems/FailureTextNormalizer";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "normalizeText";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "normalizeLines";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

