/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.remoteDebug;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteDebugHelper {
    @NotNull
    public static final String REMOTE_DEBUG_PATCHES_TO_DELETE_PARAM = "teamcity.remote.debug.patches.to.delete";
    @NotNull
    private static final String REMOTE_DEBUG_RUNNER_FLAG = "teamcity.remote.debug.runner.enabled";
    @NotNull
    private static final String REMOTE_DEBUG_RUNNER_PARAM_PREFIX = "teamcity.remote.debug.runner.param[";
    @NotNull
    private static final String REMOTE_DEBUG_RUNNER_INCREMENTAL_PARAM_PREFIX = "teamcity.remote.debug.runner.incremental.param[";
    @NotNull
    private static final String REMOTE_DEBUG_RUNNER_PARAM_SUFFIX = "]";
    @NotNull
    private final String myRunnerFlag;
    @NotNull
    private final String myRunnerParamPrefix;
    @NotNull
    private final String myRunnerIncrementalParamPrefix;
    @NotNull
    private final String myRunnerParamSuffix;

    public RemoteDebugHelper() {
        this(REMOTE_DEBUG_RUNNER_FLAG, REMOTE_DEBUG_RUNNER_PARAM_PREFIX, REMOTE_DEBUG_RUNNER_INCREMENTAL_PARAM_PREFIX, REMOTE_DEBUG_RUNNER_PARAM_SUFFIX);
    }

    protected RemoteDebugHelper(@NotNull String runnerFlag, @NotNull String runnerParamPrefix, @NotNull String runnerIncrementalParamPrefix, @NotNull String runnerParamSuffix) {
        if (runnerFlag == null) {
            RemoteDebugHelper.$$$reportNull$$$0(0);
        }
        if (runnerParamPrefix == null) {
            RemoteDebugHelper.$$$reportNull$$$0(1);
        }
        if (runnerIncrementalParamPrefix == null) {
            RemoteDebugHelper.$$$reportNull$$$0(2);
        }
        if (runnerParamSuffix == null) {
            RemoteDebugHelper.$$$reportNull$$$0(3);
        }
        this.myRunnerFlag = runnerFlag;
        this.myRunnerParamPrefix = runnerParamPrefix;
        this.myRunnerIncrementalParamPrefix = runnerIncrementalParamPrefix;
        this.myRunnerParamSuffix = runnerParamSuffix;
    }

    public void storeRemoteDebugRunnerParams(@NotNull Map<String, String> params, @NotNull Map<String, String> runnerParams, @NotNull Map<String, String> runnerIncrementalParams) {
        if (params == null) {
            RemoteDebugHelper.$$$reportNull$$$0(4);
        }
        if (runnerParams == null) {
            RemoteDebugHelper.$$$reportNull$$$0(5);
        }
        if (runnerIncrementalParams == null) {
            RemoteDebugHelper.$$$reportNull$$$0(6);
        }
        params.put(this.myRunnerFlag, "true");
        this.doStoreRemoteDebugRunnerParams(params, runnerParams, this.myRunnerParamPrefix);
        this.doStoreRemoteDebugRunnerParams(params, runnerIncrementalParams, this.myRunnerIncrementalParamPrefix);
    }

    private void doStoreRemoteDebugRunnerParams(@NotNull Map<String, String> params, @NotNull Map<String, String> runnerParams, @NotNull String runnerParamPrefix) {
        if (params == null) {
            RemoteDebugHelper.$$$reportNull$$$0(7);
        }
        if (runnerParams == null) {
            RemoteDebugHelper.$$$reportNull$$$0(8);
        }
        if (runnerParamPrefix == null) {
            RemoteDebugHelper.$$$reportNull$$$0(9);
        }
        String runnerParamFormat = runnerParamPrefix + "%s" + this.myRunnerParamSuffix;
        for (Map.Entry<String, String> param : runnerParams.entrySet()) {
            params.put(String.format(runnerParamFormat, param.getKey()), param.getValue());
        }
    }

    public boolean isRemoteDebugStep(@NotNull Map<String, String> params) {
        if (params == null) {
            RemoteDebugHelper.$$$reportNull$$$0(10);
        }
        return Boolean.parseBoolean(params.get(this.myRunnerFlag));
    }

    @NotNull
    public Map<String, String> extractRemoteDebugRunnerParams(@NotNull Map<String, String> params) {
        if (params == null) {
            RemoteDebugHelper.$$$reportNull$$$0(11);
        }
        Map<String, String> map = this.doExtractRemoteDebugRunnerParams(params, this.myRunnerParamPrefix);
        if (map == null) {
            RemoteDebugHelper.$$$reportNull$$$0(12);
        }
        return map;
    }

    @NotNull
    public Map<String, String> extractRemoteDebugRunnerIncrementalParams(@NotNull Map<String, String> params) {
        if (params == null) {
            RemoteDebugHelper.$$$reportNull$$$0(13);
        }
        Map<String, String> map = this.doExtractRemoteDebugRunnerParams(params, this.myRunnerIncrementalParamPrefix);
        if (map == null) {
            RemoteDebugHelper.$$$reportNull$$$0(14);
        }
        return map;
    }

    @NotNull
    private Map<String, String> doExtractRemoteDebugRunnerParams(@NotNull Map<String, String> params, @NotNull String runnerParamPrefix) {
        if (params == null) {
            RemoteDebugHelper.$$$reportNull$$$0(15);
        }
        if (runnerParamPrefix == null) {
            RemoteDebugHelper.$$$reportNull$$$0(16);
        }
        HashMap<String, String> runnerParams = new HashMap<String, String>();
        for (Map.Entry<String, String> param : params.entrySet()) {
            String runnerParamName = this.extractRunnerParamName(param.getKey(), runnerParamPrefix);
            if (runnerParamName == null) continue;
            runnerParams.put(runnerParamName, param.getValue());
        }
        HashMap<String, String> hashMap = runnerParams;
        if (hashMap == null) {
            RemoteDebugHelper.$$$reportNull$$$0(17);
        }
        return hashMap;
    }

    @Nullable
    private String extractRunnerParamName(@NotNull String paramName, @NotNull String runnerParamPrefix) {
        if (paramName == null) {
            RemoteDebugHelper.$$$reportNull$$$0(18);
        }
        if (runnerParamPrefix == null) {
            RemoteDebugHelper.$$$reportNull$$$0(19);
        }
        if (paramName.startsWith(runnerParamPrefix) && paramName.endsWith(this.myRunnerParamSuffix)) {
            return paramName.substring(runnerParamPrefix.length(), paramName.length() - this.myRunnerParamSuffix.length());
        }
        return null;
    }

    @NotNull
    public static String patchIdsToString(@NotNull Collection<String> patchIds) {
        if (patchIds == null) {
            RemoteDebugHelper.$$$reportNull$$$0(20);
        }
        String string = StringUtil.join((String)",", patchIds);
        if (string == null) {
            RemoteDebugHelper.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public static Collection<Long> patchIdsFromString(@NotNull String patchIds) {
        if (patchIds == null) {
            RemoteDebugHelper.$$$reportNull$$$0(22);
        }
        ArrayList<Long> result = new ArrayList<Long>();
        for (String patchId : StringUtil.split((String)patchIds)) {
            try {
                result.add(Long.parseLong(patchId));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        ArrayList<Long> arrayList = result;
        if (arrayList == null) {
            RemoteDebugHelper.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 21: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 21: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerFlag";
                break;
            }
            case 1: 
            case 9: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerParamPrefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerIncrementalParamPrefix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerParamSuffix";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerParams";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerIncrementalParams";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/remoteDebug/RemoteDebugHelper";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramName";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/remoteDebug/RemoteDebugHelper";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "extractRemoteDebugRunnerParams";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "extractRemoteDebugRunnerIncrementalParams";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "doExtractRemoteDebugRunnerParams";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "patchIdsToString";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "patchIdsFromString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "storeRemoteDebugRunnerParams";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doStoreRemoteDebugRunnerParams";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isRemoteDebugStep";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "extractRemoteDebugRunnerParams";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 21: 
            case 23: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractRemoteDebugRunnerIncrementalParams";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doExtractRemoteDebugRunnerParams";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "extractRunnerParamName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "patchIdsToString";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "patchIdsFromString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 21: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

