/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import jetbrains.buildServer.serverSide.StartupConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataDirectoryLocationResolver {
    public static final String TEAMCITY_DATA_PATH_PROPERTY = "teamcity.data.path";
    public static final String TEAMCITY_DATA_PATH_ENV = "TEAMCITY_DATA_PATH";

    private DataDirectoryLocationResolver() {
    }

    @NotNull
    public static File determineDataDir() {
        File file = DataDirectoryLocationResolver.determineDataDir(System.getProperties(), System.getenv(), null);
        if (file == null) {
            DataDirectoryLocationResolver.$$$reportNull$$$0(0);
        }
        return file;
    }

    @NotNull
    public static File determineDataDir(@Nullable Logger logger) {
        File file = DataDirectoryLocationResolver.determineDataDir(System.getProperties(), System.getenv(), logger);
        if (file == null) {
            DataDirectoryLocationResolver.$$$reportNull$$$0(1);
        }
        return file;
    }

    @NotNull
    public static File determineDataDir(@NotNull Properties systemProps, @NotNull Map<String, String> envVars) {
        if (systemProps == null) {
            DataDirectoryLocationResolver.$$$reportNull$$$0(2);
        }
        if (envVars == null) {
            DataDirectoryLocationResolver.$$$reportNull$$$0(3);
        }
        File file = DataDirectoryLocationResolver.determineDataDir(systemProps, envVars, null);
        if (file == null) {
            DataDirectoryLocationResolver.$$$reportNull$$$0(4);
        }
        return file;
    }

    @NotNull
    public static File determineDataDir(@NotNull Properties systemProps, @NotNull Map<String, String> envVars, @Nullable Logger logger) {
        String userHome;
        String dataDirPath;
        String envName;
        String envValue;
        if (systemProps == null) {
            DataDirectoryLocationResolver.$$$reportNull$$$0(5);
        }
        if (envVars == null) {
            DataDirectoryLocationResolver.$$$reportNull$$$0(6);
        }
        File dataDir = null;
        String determineSource = null;
        String propName = TEAMCITY_DATA_PATH_PROPERTY;
        String propValue = systemProps.getProperty(propName);
        if (propValue != null) {
            dataDir = new File(propValue);
            determineSource = "JVM property " + propName;
        }
        if (dataDir == null && (envValue = envVars.get(envName = TEAMCITY_DATA_PATH_ENV)) != null) {
            dataDir = new File(envValue);
            determineSource = "environment variable " + envName;
        }
        if (dataDir == null && (dataDirPath = StartupConfiguration.getProperty((String)TEAMCITY_DATA_PATH_PROPERTY)) != null) {
            dataDir = new File(dataDirPath);
            determineSource = StartupConfiguration.getDescription();
        }
        if (dataDir == null && (userHome = systemProps.getProperty("user.home")) != null) {
            dataDir = new File(userHome, ".BuildServer");
            determineSource = "user home directory";
        }
        if (dataDir == null) {
            dataDir = new File("/BuildServer");
            determineSource = "root of the file system, because neither JVM property nor environment variable nor user home directory were defined";
        }
        if (logger != null) {
            logger.info("The TeamCity Data Directory path is determined using the " + determineSource);
        }
        File file = dataDir;
        if (file == null) {
            DataDirectoryLocationResolver.$$$reportNull$$$0(7);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/serverSide/DataDirectoryLocationResolver";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemProps";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envVars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "determineDataDir";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/serverSide/DataDirectoryLocationResolver";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "determineDataDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

