/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import jetbrains.buildServer.serverSide.JvmMonitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JvmMonitoring {
    private static final Class ourMonitoredVmClass = JvmMonitoring.getMonitoredVmClass();
    private static final Class ourMonitorClass = JvmMonitoring.getMonitorClass();
    private static final Method ourMonitorGetValueMethod = JvmMonitoring.getMonitorGetValueMethod();
    private static final Object ourMonitoredVM = JvmMonitoring.getVm();
    private static final JvmMonitor ourSafePointMonitor = JvmMonitoring.initSafePointMonitor();
    private static final JvmMonitor ourFrequencyMonitor = JvmMonitoring.initFrequencyMonitor();

    @NotNull
    static JvmMonitor getSafePointMonitor() {
        JvmMonitor jvmMonitor = ourSafePointMonitor;
        if (jvmMonitor == null) {
            JvmMonitoring.$$$reportNull$$$0(0);
        }
        return jvmMonitor;
    }

    @NotNull
    static JvmMonitor getFrequencyMonitor() {
        JvmMonitor jvmMonitor = ourFrequencyMonitor;
        if (jvmMonitor == null) {
            JvmMonitoring.$$$reportNull$$$0(1);
        }
        return jvmMonitor;
    }

    @Nullable
    private static Class getMonitoredVmClass() {
        try {
            return Class.forName("sun.jvmstat.monitor.MonitoredVm");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Nullable
    private static Class getMonitorClass() {
        try {
            return Class.forName("sun.jvmstat.monitor.Monitor");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Nullable
    private static Method getMonitorGetValueMethod() {
        if (ourMonitorClass == null) {
            return null;
        }
        try {
            return ourMonitorClass.getMethod("getValue", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (RuntimeException e) {
            if (!"java.lang.reflect.InaccessibleObjectException".equals(e.getClass().getName())) {
                throw e;
            }
            return null;
        }
    }

    @Nullable
    private static Object getVm() {
        try {
            Class<?> monitoredHostClass = Class.forName("sun.jvmstat.monitor.MonitoredHost");
            Class<?> vmIndentifierClass = Class.forName("sun.jvmstat.monitor.VmIdentifier");
            Method getMonitoredHostMethod = monitoredHostClass.getMethod("getMonitoredHost", String.class);
            if (getMonitoredHostMethod == null) {
                return null;
            }
            Object monitoredHost = getMonitoredHostMethod.invoke(monitoredHostClass, new Object[]{null});
            if (monitoredHost == null) {
                return null;
            }
            Method getMonitoredVmMethod = monitoredHostClass.getMethod("getMonitoredVm", vmIndentifierClass);
            if (getMonitoredVmMethod == null) {
                return null;
            }
            Constructor<?> c = vmIndentifierClass.getConstructor(String.class);
            if (c == null) {
                return null;
            }
            Object vmId = c.newInstance(ManagementFactory.getRuntimeMXBean().getName());
            return getMonitoredVmMethod.invoke(monitoredHost, vmId);
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    private static JvmMonitor initSafePointMonitor() {
        JvmMonitor jvmMonitor = JvmMonitoring.getMonitor("sun.rt.safepointTime");
        if (jvmMonitor == null) {
            JvmMonitoring.$$$reportNull$$$0(2);
        }
        return jvmMonitor;
    }

    @NotNull
    private static JvmMonitor initFrequencyMonitor() {
        JvmMonitor jvmMonitor = JvmMonitoring.getMonitor("sun.os.hrt.frequency");
        if (jvmMonitor == null) {
            JvmMonitoring.$$$reportNull$$$0(3);
        }
        return jvmMonitor;
    }

    @NotNull
    private static JvmMonitor getMonitor(@NotNull String name) {
        JvmMonitorImpl jvmMonitorImpl;
        block13: {
            Object monitor;
            block11: {
                EmptyJvmMonitor emptyJvmMonitor;
                block12: {
                    Method findByNameMethod;
                    block9: {
                        EmptyJvmMonitor emptyJvmMonitor2;
                        block10: {
                            block7: {
                                EmptyJvmMonitor emptyJvmMonitor3;
                                block8: {
                                    if (name == null) {
                                        JvmMonitoring.$$$reportNull$$$0(4);
                                    }
                                    try {
                                        if (ourMonitoredVmClass != null && ourMonitorGetValueMethod != null && ourMonitoredVM != null) break block7;
                                        emptyJvmMonitor3 = new EmptyJvmMonitor();
                                        if (emptyJvmMonitor3 != null) break block8;
                                    }
                                    catch (Exception e) {
                                        EmptyJvmMonitor emptyJvmMonitor4 = new EmptyJvmMonitor();
                                        if (emptyJvmMonitor4 == null) {
                                            JvmMonitoring.$$$reportNull$$$0(9);
                                        }
                                        return emptyJvmMonitor4;
                                    }
                                    JvmMonitoring.$$$reportNull$$$0(5);
                                }
                                return emptyJvmMonitor3;
                            }
                            findByNameMethod = ourMonitoredVmClass.getMethod("findByName", String.class);
                            if (findByNameMethod != null) break block9;
                            emptyJvmMonitor2 = new EmptyJvmMonitor();
                            if (emptyJvmMonitor2 != null) break block10;
                            JvmMonitoring.$$$reportNull$$$0(6);
                        }
                        return emptyJvmMonitor2;
                    }
                    monitor = findByNameMethod.invoke(ourMonitoredVM, name);
                    if (monitor != null) break block11;
                    emptyJvmMonitor = new EmptyJvmMonitor();
                    if (emptyJvmMonitor != null) break block12;
                    JvmMonitoring.$$$reportNull$$$0(7);
                }
                return emptyJvmMonitor;
            }
            jvmMonitorImpl = new JvmMonitorImpl(ourMonitorGetValueMethod, monitor);
            if (jvmMonitorImpl != null) break block13;
            JvmMonitoring.$$$reportNull$$$0(8);
        }
        return jvmMonitorImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/serverSide/JvmMonitoring";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSafePointMonitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrequencyMonitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "initSafePointMonitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "initFrequencyMonitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/serverSide/JvmMonitoring";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMonitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMonitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EmptyJvmMonitor
    implements JvmMonitor {
        private EmptyJvmMonitor() {
        }

        @Override
        @Nullable
        public Object getValue() {
            return null;
        }
    }

    private static class JvmMonitorImpl
    implements JvmMonitor {
        private final Method myGetValueMethod;
        private final Object myMonitor;

        public JvmMonitorImpl(@NotNull Method getValueMethod, @NotNull Object monitor) {
            if (getValueMethod == null) {
                JvmMonitorImpl.$$$reportNull$$$0(0);
            }
            if (monitor == null) {
                JvmMonitorImpl.$$$reportNull$$$0(1);
            }
            this.myGetValueMethod = getValueMethod;
            this.myMonitor = monitor;
        }

        @Override
        @Nullable
        public Object getValue() {
            try {
                return this.myGetValueMethod.invoke(this.myMonitor, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "getValueMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "monitor";
                    break;
                }
            }
            objectArray[1] = "jetbrains/buildServer/serverSide/JvmMonitoring$JvmMonitorImpl";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

