/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide.identifiers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.messages.serviceMessages.MapSerializerUtil;
import jetbrains.buildServer.serverSide.InvalidIdentifierException;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.serverSide.identifiers.EntityId;
import jetbrains.buildServer.serverSide.identifiers.OccupiedIdsChecker;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdentifiersUtil {
    public static final String EXT_ID_PARTS_DELIMITER = "_";
    public static final int EXT_ID_LENGTH = 225;
    public static final int CONFIG_ID_LENGTH = 80;
    private static final String DUMMY_CONFIG_ID = "00000000-0000-4000-B000-000000000000";
    private static final Pattern WORD_PATTERN = Pattern.compile("[A-Z0-9]+", 2);
    public static final EntityId<String> ourInaccessibleStringEntityId = new EntityId<String>("-1", "-1", "00000000-0000-4000-B000-000000000000", null, null);
    public static final EntityId<String> ourDummyEntityId = new EntityId<String>("__dummy_bt_id", "__dummy_bt_id", "00000000-0000-4000-B000-000000000000", null, null);
    private static final Pattern CONFIG_ID_PATTERN = Pattern.compile("^[A-Za-z_0-9\\-]+$", 32);

    public static void validateExternalIdReference(@NotNull String id, String idKindName) throws InvalidIdentifierException {
        if (id == null) {
            IdentifiersUtil.$$$reportNull$$$0(0);
        }
        if (TeamCityProperties.getBooleanOrTrue((String)"teamcity.settings.extIdRefsValidation.enabled")) {
            IdentifiersUtil.validateExternalId(id, idKindName + " reference");
        }
    }

    public static void validateExternalId(@NotNull String id, String idKindName) throws InvalidIdentifierException {
        if (id == null) {
            IdentifiersUtil.$$$reportNull$$$0(1);
        }
        IdentifiersUtil.validateExternalId(id, idKindName, 225);
    }

    public static void validateExternalId(@NotNull String id, String idKindName, int maxLength) throws InvalidIdentifierException {
        if (id == null) {
            IdentifiersUtil.$$$reportNull$$$0(2);
        }
        if (id.trim().length() == 0) {
            throw new InvalidIdentifierException(idKindName + " must not be empty.", id);
        }
        String prefix = idKindName + " \"" + id + "\" is invalid: ";
        String rule = "ID should start with a latin letter and contain only latin letters, digits and underscores";
        if (maxLength > 0) {
            rule = rule + " (at most " + maxLength + " characters).";
        }
        int n = id.length();
        for (int i = 0; i < n; ++i) {
            char c = id.charAt(i);
            if (i == 0 && !Character.isLetter(c)) {
                throw new InvalidIdentifierException(prefix + "starts with non-letter character '" + c + "'. " + rule, id);
            }
            if (Character.isLetter(c)) {
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
                throw new InvalidIdentifierException(prefix + "contains non-latin letter '" + c + "'. " + rule, id);
            }
            if (c >= '0' && c <= '9' || c == '_') continue;
            throw new InvalidIdentifierException(prefix + "contains unsupported character '" + c + "'. " + rule, id);
        }
        if (!MapSerializerUtil.isValidJavaIdentifier((String)id)) {
            throw new InvalidIdentifierException(prefix + "it is not a valid java/javascript identifier. " + rule, id);
        }
        if (maxLength > 0 && n > maxLength) {
            throw new InvalidIdentifierException(prefix + "it is " + n + " characters long while the maximum length is " + maxLength + ". " + rule, id);
        }
    }

    @NotNull
    public static String generateExternalIdByName(@NotNull String name, boolean requireFirstLetter, boolean adjustCase, int limiLength) {
        if (name == null) {
            IdentifiersUtil.$$$reportNull$$$0(3);
        }
        StringBuilder b = new StringBuilder(name.length());
        Matcher m = WORD_PATTERN.matcher(name);
        while (m.find()) {
            int len = b.length();
            boolean capitalize = len == 0 || !Character.isDigit(b.charAt(len - 1));
            String word = m.group();
            assert (word != null);
            assert (word.length() > 0);
            if (adjustCase) {
                if (StringUtil.isUpperCase((String)word)) {
                    word = word.toLowerCase();
                }
                if (capitalize && Character.isLowerCase(word.charAt(0))) {
                    word = IdentifiersUtil.capitalize1stLetter(word);
                }
            }
            b.append(word);
        }
        if (b.length() == 0 || requireFirstLetter && !Character.isLetter(b.charAt(0))) {
            b.insert(0, "id");
        }
        if (b.length() > limiLength) {
            b.delete(limiLength, b.length());
            while (b.length() >= 2 && b.charAt(b.length() - 1) == '_') {
                b.delete(b.length() - 1, b.length());
            }
        }
        assert (b.length() > 0);
        String string = b.toString();
        if (string == null) {
            IdentifiersUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static String capitalize1stLetter(@NotNull String word) {
        if (word == null) {
            IdentifiersUtil.$$$reportNull$$$0(5);
        }
        return word.substring(0, 1).toUpperCase() + word.substring(1);
    }

    @NotNull
    public static String generateUniqueExternalIdByUserString(@Nullable String parentId, @NotNull String name, boolean adjustCase, @NotNull OccupiedIdsChecker occupiedIdsChecker) {
        String part1;
        if (name == null) {
            IdentifiersUtil.$$$reportNull$$$0(6);
        }
        if (occupiedIdsChecker == null) {
            IdentifiersUtil.$$$reportNull$$$0(7);
        }
        String string = part1 = parentId == null ? "" : parentId.trim();
        while (part1.startsWith(EXT_ID_PARTS_DELIMITER)) {
            part1 = part1.substring(1);
        }
        while (part1.endsWith(EXT_ID_PARTS_DELIMITER)) {
            part1 = part1.substring(0, part1.length() - 1);
        }
        boolean part1exists = part1.length() > 0;
        String part2 = IdentifiersUtil.generateExternalIdByName(name.trim(), !part1exists, adjustCase, 225);
        String pretendentRoot = part1exists ? part1 + EXT_ID_PARTS_DELIMITER + part2 : part2;
        String pretendent = StringUtil.truncateStringValue((String)pretendentRoot, (int)225);
        int k = 1;
        while (occupiedIdsChecker.isOccupied(pretendent)) {
            String suffix = EXT_ID_PARTS_DELIMITER + ++k;
            int limit = 225 - suffix.length();
            pretendent = StringUtil.truncateStringValue((String)pretendentRoot, (int)limit) + suffix;
        }
        String string2 = pretendent;
        if (string2 == null) {
            IdentifiersUtil.$$$reportNull$$$0(8);
        }
        return string2;
    }

    static void validateConfigId(@NotNull String newConfigId) {
        if (newConfigId == null) {
            IdentifiersUtil.$$$reportNull$$$0(9);
        }
        if (newConfigId.length() > 80) {
            throw new InvalidIdentifierException("Provided uuid (" + newConfigId + ") is too long (it must be at most " + 80 + " characters)", newConfigId);
        }
        if (!CONFIG_ID_PATTERN.matcher(newConfigId).matches()) {
            throw new InvalidIdentifierException("Provided uuid (" + newConfigId + ") is not valid (uuid can contain the following characters: [A-Za-z_0-9\\-])", newConfigId);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/serverSide/identifiers/IdentifiersUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occupiedIdsChecker";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newConfigId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/serverSide/identifiers/IdentifiersUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateExternalIdByName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "generateUniqueExternalIdByUserString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validateExternalIdReference";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "validateExternalId";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generateExternalIdByName";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "capitalize1stLetter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateUniqueExternalIdByUserString";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validateConfigId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

