/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide.parameters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import jetbrains.buildServer.parameters.ParametersProvider;
import jetbrains.buildServer.parameters.ProcessingResult;
import jetbrains.buildServer.parameters.ReferencesResolverUtil;
import jetbrains.buildServer.parameters.ValueResolver;
import jetbrains.buildServer.parameters.impl.ProcessingResultImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GetOnlyValueResolver
implements ValueResolver {
    private final ParametersProvider myProvider;
    private boolean myUseOriginalWhenNoValFullyResolved;
    private boolean myFullyResolved;
    private boolean myHasFullyResolvedVals;

    public GetOnlyValueResolver(@NotNull ParametersProvider provider) {
        if (provider == null) {
            GetOnlyValueResolver.$$$reportNull$$$0(0);
        }
        this.myUseOriginalWhenNoValFullyResolved = true;
        this.myProvider = provider;
    }

    public void setUseOriginalWhenNoValFullyResolved(boolean useOriginalWhenNoValFullyResolved) {
        this.myUseOriginalWhenNoValFullyResolved = useOriginalWhenNoValFullyResolved;
    }

    @NotNull
    public ProcessingResult resolve(@NotNull String str) {
        if (str == null) {
            GetOnlyValueResolver.$$$reportNull$$$0(1);
        }
        this.myFullyResolved = true;
        this.myHasFullyResolvedVals = false;
        StringBuilder resolved = new StringBuilder();
        Stack<Object> tokens = new Stack<Object>();
        this.parse(str, tokens, null);
        while (!tokens.isEmpty()) {
            Object token = tokens.pop();
            if (token instanceof String) {
                resolved.append(ReferencesResolverUtil.unescape((String)((String)token)));
                continue;
            }
            if (!(token instanceof Ref)) continue;
            Ref ref = (Ref)token;
            String refName = ref.getName();
            String refVal = this.myProvider.get(refName);
            if (refVal != null) {
                this.parse(refVal, tokens, ref);
                continue;
            }
            this.myFullyResolved = false;
            resolved.append("%").append(refName).append("%");
        }
        String result = resolved.toString();
        if (this.myFullyResolved) {
            ProcessingResultImpl processingResultImpl = new ProcessingResultImpl(result, !str.equals(result), this.myFullyResolved);
            if (processingResultImpl == null) {
                GetOnlyValueResolver.$$$reportNull$$$0(2);
            }
            return processingResultImpl;
        }
        if (this.myUseOriginalWhenNoValFullyResolved && !this.myHasFullyResolvedVals) {
            ProcessingResultImpl processingResultImpl = new ProcessingResultImpl(str, false, false);
            if (processingResultImpl == null) {
                GetOnlyValueResolver.$$$reportNull$$$0(3);
            }
            return processingResultImpl;
        }
        ProcessingResultImpl processingResultImpl = new ProcessingResultImpl(result, !str.equals(result), this.myFullyResolved);
        if (processingResultImpl == null) {
            GetOnlyValueResolver.$$$reportNull$$$0(4);
        }
        return processingResultImpl;
    }

    private void parse(@NotNull String value, @NotNull Stack<Object> acc, final @Nullable Ref parent) {
        if (value == null) {
            GetOnlyValueResolver.$$$reportNull$$$0(5);
        }
        if (acc == null) {
            GetOnlyValueResolver.$$$reportNull$$$0(6);
        }
        final ArrayList tokens = new ArrayList();
        final AtomicBoolean fullyResolvedValue = new AtomicBoolean(true);
        ReferencesResolverUtil.resolve((String)value, (ReferencesResolverUtil.ReferencesResolverListener)new ReferencesResolverUtil.ReferencesResolverListener(){

            public void appendText(@NotNull String text) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                tokens.add(text);
            }

            public boolean appendReference(@NotNull String referenceKey) {
                if (referenceKey == null) {
                    1.$$$reportNull$$$0(1);
                }
                fullyResolvedValue.set(false);
                if (parent != null && parent.isCycle(referenceKey)) {
                    GetOnlyValueResolver.this.myFullyResolved = false;
                    return false;
                }
                if (!ReferencesResolverUtil.isValidReference((String)referenceKey) && GetOnlyValueResolver.this.myProvider.get(referenceKey) == null) {
                    GetOnlyValueResolver.this.myFullyResolved = false;
                    return false;
                }
                tokens.add(new Ref(referenceKey, parent));
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceKey";
                        break;
                    }
                }
                objectArray2[1] = "jetbrains/buildServer/serverSide/parameters/GetOnlyValueResolver$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "appendText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "appendReference";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (fullyResolvedValue.get()) {
            this.myHasFullyResolvedVals = true;
        }
        for (int i = tokens.size() - 1; i >= 0; --i) {
            acc.push(tokens.get(i));
        }
    }

    @NotNull
    public Map<String, String> resolve(@NotNull Map<String, String> unresolved) {
        if (unresolved == null) {
            GetOnlyValueResolver.$$$reportNull$$$0(7);
        }
        HashMap<String, String> result = new HashMap<String, String>(unresolved.size());
        for (Map.Entry<String, ProcessingResult> e : this.resolveWithDetails(unresolved).entrySet()) {
            result.put(e.getKey(), e.getValue().getResult());
        }
        HashMap<String, String> hashMap = result;
        if (hashMap == null) {
            GetOnlyValueResolver.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    @NotNull
    public Map<String, ProcessingResult> resolveWithDetails(@NotNull Map<String, String> unresolved) {
        if (unresolved == null) {
            GetOnlyValueResolver.$$$reportNull$$$0(9);
        }
        HashMap<String, ProcessingResult> result = new HashMap<String, ProcessingResult>(unresolved.size());
        for (Map.Entry<String, String> e : unresolved.entrySet()) {
            result.put(e.getKey(), this.resolve(e.getValue()));
        }
        HashMap<String, ProcessingResult> hashMap = result;
        if (hashMap == null) {
            GetOnlyValueResolver.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/serverSide/parameters/GetOnlyValueResolver";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acc";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unresolved";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/serverSide/parameters/GetOnlyValueResolver";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveWithDetails";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveWithDetails";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Ref {
        private final String myName;
        @Nullable
        private final Ref myParent;

        Ref(@NotNull String name, @Nullable Ref parent) {
            if (name == null) {
                Ref.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myParent = parent;
        }

        @NotNull
        String getName() {
            String string = this.myName;
            if (string == null) {
                Ref.$$$reportNull$$$0(1);
            }
            return string;
        }

        boolean isCycle(@NotNull String refName) {
            if (refName == null) {
                Ref.$$$reportNull$$$0(2);
            }
            Ref ref = this;
            while (ref != null) {
                if (ref.getName().equals(refName)) {
                    return true;
                }
                ref = ref.myParent;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/serverSide/parameters/GetOnlyValueResolver$Ref";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/serverSide/parameters/GetOnlyValueResolver$Ref";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isCycle";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

