/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.spring;

import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jetbrains.buildServer.DevelopmentMode;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.CglibSubclassingInstantiationStrategy;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;

public class InstantiationStrategySelector
implements BeanFactoryPostProcessor {
    private static final Logger LOG = Logger.getInstance((String)InstantiationStrategySelector.class.getName());

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof AbstractAutowireCapableBeanFactory)) {
            return;
        }
        AbstractAutowireCapableBeanFactory abf = (AbstractAutowireCapableBeanFactory)beanFactory;
        CglibSubclassingInstantiationStrategy host = new CglibSubclassingInstantiationStrategy();
        abf.setInstantiationStrategy(new InstantiationStrategy((InstantiationStrategy)host){
            final /* synthetic */ InstantiationStrategy val$host;
            {
                this.val$host = instantiationStrategy;
            }

            public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner) throws BeansException {
                Class clazz = beanDefinition.getBeanClass();
                if (!this.isSpringClass(clazz)) {
                    if (!Modifier.isPublic(clazz.getModifiers())) {
                        this.log("Spring selected non-public class to create instance: " + clazz);
                    }
                    if (!this.hasPublicConstructor(clazz)) {
                        this.log("Spring selected non-public constructor to create instance: " + clazz);
                    }
                }
                return this.val$host.instantiate(beanDefinition, beanName, owner);
            }

            public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner, Constructor<?> ctor, Object[] args) throws BeansException {
                Class<?> clazz = ctor.getDeclaringClass();
                if (!this.isSpringClass(clazz)) {
                    if (!Modifier.isPublic(ctor.getModifiers())) {
                        this.log("Spring selected non-public constructor to create instance: " + ctor);
                    }
                    if (!Modifier.isPublic(clazz.getModifiers())) {
                        this.log("Spring selected non-public class to create instance: " + clazz);
                    }
                }
                return this.val$host.instantiate(beanDefinition, beanName, owner, ctor, args);
            }

            public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner, Object factoryBean, Method factoryMethod, Object[] args) throws BeansException {
                if (!this.isSpringClass(factoryMethod.getDeclaringClass()) && !Modifier.isPublic(factoryMethod.getModifiers())) {
                    this.log("Spring selected non-public factory method to create instance: " + factoryMethod);
                }
                return this.val$host.instantiate(beanDefinition, beanName, owner, factoryBean, factoryMethod, args);
            }

            private void log(@NotNull String message) {
                if (message == null) {
                    1.$$$reportNull$$$0(0);
                }
                LOG.warn(message);
                if (DevelopmentMode.isEnabled) {
                    System.out.println(message);
                }
            }

            private boolean hasPublicConstructor(@NotNull Class<?> clazz) {
                if (clazz == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (Constructor<?> constructor : clazz.getConstructors()) {
                    if (!Modifier.isPublic(constructor.getModifiers())) continue;
                    return true;
                }
                return false;
            }

            private boolean isSpringClass(@NotNull Class<?> clazz) {
                if (clazz == null) {
                    1.$$$reportNull$$$0(2);
                }
                return clazz.getCanonicalName().startsWith("org.springframework.");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "clazz";
                        break;
                    }
                }
                objectArray2[1] = "jetbrains/buildServer/spring/InstantiationStrategySelector$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "log";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "hasPublicConstructor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSpringClass";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }
}

