/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.spring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import jetbrains.buildServer.CachedSpringAccessor;
import jetbrains.buildServer.DefaultSpringAccessor;
import jetbrains.buildServer.ServiceLocatorImpl;
import jetbrains.buildServer.ServiceNotFoundException;
import jetbrains.buildServer.log.LogInitializer;
import jetbrains.buildServer.spring.SpringContext;
import jetbrains.buildServer.spring.SpringSubContainerDescriptor;
import jetbrains.buildServer.spring.SpringSubContainerFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class SpringSubContainerFactoryImpl
implements SpringSubContainerFactory {
    private final ApplicationContext myApplicationContext;

    public SpringSubContainerFactoryImpl(ApplicationContext applicationContext) {
        this.myApplicationContext = applicationContext;
    }

    @Override
    public SpringContext createSubContext(@NotNull SpringSubContainerDescriptor descr) {
        if (descr == null) {
            SpringSubContainerFactoryImpl.$$$reportNull$$$0(0);
        }
        TeamCitySpringSubContainer ctx = new TeamCitySpringSubContainer(this.myApplicationContext, descr);
        ctx.refresh();
        return new SpringContextImpl(ctx).getSingletonService(SpringContext.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descr", "jetbrains/buildServer/spring/SpringSubContainerFactoryImpl", "createSubContext"));
    }

    private static class TeamCitySpringSubContainer
    extends FileSystemXmlApplicationContext {
        private final SpringSubContainerDescriptor myDescr;

        public TeamCitySpringSubContainer(ApplicationContext parent, SpringSubContainerDescriptor descr) {
            super(parent);
            this.myDescr = descr;
            this.setAllowBeanDefinitionOverriding(true);
            this.setDisplayName("SubContext: " + descr.getDisplayName());
            ArrayList<String> configs = new ArrayList<String>(descr.getConfigs());
            configs.add("classpath*:/META-INF/shared-spring-sub-container.xml");
            configs.add("classpath*:/META-INF/teamcity-global-spring-settings.xml");
            this.setConfigLocations(configs.toArray(new String[configs.size()]));
        }

        /*
         * WARNING - void declaration
         */
        protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
            super.prepareBeanFactory(beanFactory);
            for (Map.Entry<Class<?>, Object> entry : this.myDescr.getOverrideObjects().entrySet()) {
                beanFactory.registerResolvableDependency(entry.getKey(), entry.getValue());
            }
            BeanDefinitionRegistry r = (BeanDefinitionRegistry)beanFactory;
            for (Class<?> clazz : this.myDescr.getRegisterBeans()) {
                RootBeanDefinition definition = new RootBeanDefinition(clazz);
                definition.setAutowireMode(3);
                r.registerBeanDefinition(clazz.getName() + "-" + System.currentTimeMillis(), (BeanDefinition)definition);
            }
            RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(SpringContextImpl.class);
            rootBeanDefinition.setAutowireMode(3);
            r.registerBeanDefinition("teamcity-sub-container-spring-xml-bean", (BeanDefinition)rootBeanDefinition);
            boolean bl = false;
            for (Object o : this.myDescr.getPredefinedObjects()) {
                void var4_8;
                beanFactory.registerSingleton("sub-bean-" + o.getClass().getName() + "#" + (int)(++var4_8), o);
            }
        }

        protected void resetCommonCaches() {
            if (!LogInitializer.isUnitTest()) {
                super.resetCommonCaches();
            }
        }
    }

    public static class SpringContextImpl
    implements SpringContext {
        private final TeamCitySpringSubContainer myContainer;
        private final ServiceLocatorImpl myServiceLocator;

        public SpringContextImpl(@NotNull TeamCitySpringSubContainer container) {
            if (container == null) {
                SpringContextImpl.$$$reportNull$$$0(0);
            }
            this.myServiceLocator = new ServiceLocatorImpl();
            this.myContainer = container;
            this.myServiceLocator.setSpringAccessor(new CachedSpringAccessor(new DefaultSpringAccessor((ApplicationContext)this.myContainer)));
        }

        @NotNull
        public <T> T getSingletonService(@NotNull Class<T> serviceClass) throws ServiceNotFoundException {
            if (serviceClass == null) {
                SpringContextImpl.$$$reportNull$$$0(1);
            }
            T t = this.myServiceLocator.getSingletonService(serviceClass);
            if (t == null) {
                SpringContextImpl.$$$reportNull$$$0(2);
            }
            return t;
        }

        public <T> T findSingletonService(@NotNull Class<T> serviceClass) {
            if (serviceClass == null) {
                SpringContextImpl.$$$reportNull$$$0(3);
            }
            return this.myServiceLocator.findSingletonService(serviceClass);
        }

        @NotNull
        public <T> Collection<T> getServices(@NotNull Class<T> serviceClass) {
            if (serviceClass == null) {
                SpringContextImpl.$$$reportNull$$$0(4);
            }
            Collection<T> collection = this.myServiceLocator.getServices(serviceClass);
            if (collection == null) {
                SpringContextImpl.$$$reportNull$$$0(5);
            }
            return collection;
        }

        public void dispose() {
            this.myContainer.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serviceClass";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/spring/SpringSubContainerFactoryImpl$SpringContextImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/spring/SpringSubContainerFactoryImpl$SpringContextImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSingletonService";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getServices";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getSingletonService";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findSingletonService";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getServices";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

