/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SizePresenter {
    public static final long KiB = 1024L;
    public static final long MiB = 0x100000L;
    public static final long GiB = 0x40000000L;
    public static final long TiB = 0x10000000000L;
    public static final String TB_POSTFIX = " TB";
    public static final String GB_POSTFIX = " GB";
    public static final String MB_POSTFIX = " MB";
    public static final String KB_POSTFIX = " KB";
    public static final String B_POSTFIX = " B";

    private static String format(double d) {
        return (long)d + "." + (long)(d * 10.0) % 10L;
    }

    public static String toString(@Nullable Long bytesSize) {
        if (bytesSize == null) {
            return "NA";
        }
        double sz = bytesSize.doubleValue();
        if (sz > 3.221225472E12) {
            return SizePresenter.format(sz / 1.099511627776E12) + TB_POSTFIX;
        }
        if (sz > 3.145728E9) {
            return SizePresenter.format(sz / 1.073741824E9) + GB_POSTFIX;
        }
        if (sz > 3072000.0) {
            return SizePresenter.format(sz / 1048576.0) + MB_POSTFIX;
        }
        if (sz > 3000.0) {
            return SizePresenter.format(sz / 1024.0) + KB_POSTFIX;
        }
        return SizePresenter.format(sz) + B_POSTFIX;
    }

    public static String toStringPrecise(@Nullable Long bytesSize) {
        if (bytesSize == null) {
            return "NA";
        }
        if (bytesSize % 0x10000000000L == 0L) {
            return Long.toString(bytesSize / 0x10000000000L) + TB_POSTFIX;
        }
        if (bytesSize % 0x40000000L == 0L) {
            return Long.toString(bytesSize / 0x40000000L) + GB_POSTFIX;
        }
        if (bytesSize % 0x100000L == 0L) {
            return Long.toString(bytesSize / 0x100000L) + MB_POSTFIX;
        }
        if (bytesSize % 1024L == 0L) {
            return Long.toString(bytesSize / 1024L) + KB_POSTFIX;
        }
        return Long.toString(bytesSize);
    }

    public static long parseSize(@NotNull String configurationValue) throws NumberFormatException {
        String value;
        if (configurationValue == null) {
            SizePresenter.$$$reportNull$$$0(0);
        }
        if ((value = configurationValue.replace(" ", "").trim().toLowerCase()).length() >= 3) {
            if (value.endsWith("kb")) {
                return SizePresenter.parseSize(value.substring(0, value.length() - 2)) * 1024L;
            }
            if (value.endsWith("mb")) {
                return SizePresenter.parseSize(value.substring(0, value.length() - 2)) * 0x100000L;
            }
            if (value.endsWith("gb")) {
                return SizePresenter.parseSize(value.substring(0, value.length() - 2)) * 0x40000000L;
            }
            if (value.endsWith("tb")) {
                return SizePresenter.parseSize(value.substring(0, value.length() - 2)) * 0x10000000000L;
            }
        }
        if (value.length() >= 4) {
            if (value.endsWith("kib")) {
                return SizePresenter.parseSize(value.substring(0, value.length() - 3)) * 1024L;
            }
            if (value.endsWith("mib")) {
                return SizePresenter.parseSize(value.substring(0, value.length() - 3)) * 0x100000L;
            }
            if (value.endsWith("gib")) {
                return SizePresenter.parseSize(value.substring(0, value.length() - 3)) * 0x40000000L;
            }
            if (value.endsWith("tib")) {
                return SizePresenter.parseSize(value.substring(0, value.length() - 3)) * 0x10000000000L;
            }
        }
        return Long.parseLong(configurationValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationValue", "jetbrains/buildServer/util/SizePresenter", "parseSize"));
    }
}

