/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.ArrayList;
import java.util.List;
import jetbrains.buildServer.util.AbstractStringMatcherBuilder;
import jetbrains.buildServer.util.StringMatcher;
import jetbrains.buildServer.util.StringMatcherHelper;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringMatcherSequencedBuilder
extends AbstractStringMatcherBuilder {
    @Override
    @NotNull
    public StringMatcher build() throws IllegalStateException {
        List<AbstractStringMatcherBuilder.MatchPart> parts = this.getParts();
        StringMatcherSequencedBuilder.validate(parts);
        final Matcher matcher = new Matcher(parts);
        StringMatcherHelper stringMatcherHelper = new StringMatcherHelper(this.hasPattern(), new StringMatcherHelper.Function<String, StringMatcher.MatchResult>(){

            @Override
            public StringMatcher.MatchResult apply(String s) {
                return matcher.match(s);
            }
        });
        if (stringMatcherHelper == null) {
            StringMatcherSequencedBuilder.$$$reportNull$$$0(0);
        }
        return stringMatcherHelper;
    }

    private static void validate(@NotNull List<AbstractStringMatcherBuilder.MatchPart> parts) throws IllegalStateException {
        if (parts == null) {
            StringMatcherSequencedBuilder.$$$reportNull$$$0(1);
        }
        boolean groupOpened = false;
        boolean canBeFollowedByAny = true;
        for (AbstractStringMatcherBuilder.MatchPart part : parts) {
            switch (part.getType()) {
                case GROUP_START: {
                    if (groupOpened) {
                        throw new IllegalStateException("New group starting without ending already started one");
                    }
                    groupOpened = true;
                    break;
                }
                case GROUP_END: {
                    if (!groupOpened) {
                        throw new IllegalStateException("Group ending without opening");
                    }
                    groupOpened = false;
                    break;
                }
                case ANY: {
                    if (!canBeFollowedByAny) {
                        throw new IllegalStateException("Two consecutive 'any' tokens");
                    }
                    canBeFollowedByAny = false;
                    break;
                }
                case STATIC: {
                    canBeFollowedByAny = true;
                }
            }
        }
        if (groupOpened) {
            throw new IllegalStateException("Group is not ended at the end");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/StringMatcherSequencedBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/StringMatcherSequencedBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Ranges {
        private int myFirstUnmatchedEndIndex = -1;
        @NotNull
        private final List<StringMatcher.MatchResult.Range> myRanges = new ArrayList<StringMatcher.MatchResult.Range>();
        private int myCurrentStartIndex = -1;

        private Ranges() {
        }

        void addStart(int index) {
            int prevLastIndex;
            if (this.myCurrentStartIndex != -1) {
                throw new IllegalStateException("Wrong groups nesting: cannot open group at index " + index + " as the previous group was opened at " + this.myCurrentStartIndex + " is not yet closed");
            }
            if (!this.myRanges.isEmpty() && (prevLastIndex = this.myRanges.get((int)(this.myRanges.size() - 1)).endIndex) > index) {
                throw new IllegalStateException("Invalid group open index " + index + ": should be greater than previous group closing index " + prevLastIndex);
            }
            this.myCurrentStartIndex = index;
        }

        void addEnd(int index) {
            if (this.myCurrentStartIndex == -1) {
                if (this.myRanges.isEmpty()) {
                    this.myFirstUnmatchedEndIndex = index;
                    return;
                }
                throw new IllegalStateException("Wrong groups nesting: cannot close group at index " + index + " as the previous group is closed at " + this.myRanges.get((int)(this.myRanges.size() - 1)).endIndex + " and new one is not opened");
            }
            if (this.myCurrentStartIndex >= index) {
                throw new IllegalStateException("Invalid group close index " + index + ": should be greater than open index " + this.myCurrentStartIndex);
            }
            this.myRanges.add(new StringMatcher.MatchResult.Range(this.myCurrentStartIndex, index));
            this.myCurrentStartIndex = -1;
        }

        private static StringMatcher.MatchResult.Range mapRange(StringMatcher.MatchResult.Range range, int baseIndex) {
            if (baseIndex == 0) {
                return range;
            }
            return new StringMatcher.MatchResult.Range(baseIndex + range.startIndex, baseIndex + range.endIndex);
        }

        public void addTo(@NotNull List<StringMatcher.MatchResult.Range> ranges, int base) {
            if (ranges == null) {
                Ranges.$$$reportNull$$$0(0);
            }
            if (this.myFirstUnmatchedEndIndex != -1) {
                if (ranges.isEmpty() || ranges.get((int)(ranges.size() - 1)).endIndex != -1) {
                    throw new IllegalStateException("Invalid ranges: group is closed at index " + (base + this.myFirstUnmatchedEndIndex) + " withotu prior opening");
                }
                ranges.get((int)(ranges.size() - 1)).endIndex = base + this.myFirstUnmatchedEndIndex;
            }
            if (this.myRanges.isEmpty()) {
                if (this.myCurrentStartIndex != -1) {
                    if (!ranges.isEmpty() && ranges.get((int)(ranges.size() - 1)).endIndex == -1) {
                        throw new IllegalStateException("Invalid ranges: group is opened at index " + ranges.get((int)(ranges.size() - 1)).startIndex + " and then opened again at index " + (base + this.myCurrentStartIndex));
                    }
                    ranges.add(new StringMatcher.MatchResult.Range(base + this.myCurrentStartIndex, -1));
                }
                return;
            }
            if (!ranges.isEmpty() && ranges.get((int)(ranges.size() - 1)).endIndex == -1) {
                if (this.myRanges.get((int)0).startIndex != -1) {
                    throw new IllegalStateException("Invalid ranges: group is opened at index " + ranges.get((int)(ranges.size() - 1)).startIndex + " and then opened again at index " + this.myRanges.get((int)0).startIndex);
                }
                ranges.get((int)(ranges.size() - 1)).endIndex = base + this.myRanges.get((int)0).endIndex;
                boolean first = true;
                for (StringMatcher.MatchResult.Range range : this.myRanges) {
                    if (first) {
                        first = false;
                        continue;
                    }
                    ranges.add(Ranges.mapRange(range, base));
                }
            } else {
                for (StringMatcher.MatchResult.Range range : this.myRanges) {
                    ranges.add(Ranges.mapRange(range, base));
                }
            }
            if (this.myCurrentStartIndex != -1) {
                if (!ranges.isEmpty() && ranges.get((int)(ranges.size() - 1)).endIndex == -1) {
                    ranges.get((int)(ranges.size() - 1)).endIndex = base + this.myCurrentStartIndex;
                } else {
                    ranges.add(new StringMatcher.MatchResult.Range(base + this.myCurrentStartIndex, -1));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "jetbrains/buildServer/util/StringMatcherSequencedBuilder$Ranges", "addTo"));
        }
    }

    private static class TextAccumulator {
        @NotNull
        private final StringBuilder myText;
        @NotNull
        private final Ranges myRanges;

        private TextAccumulator(@NotNull String text) {
            if (text == null) {
                TextAccumulator.$$$reportNull$$$0(0);
            }
            this.myText = new StringBuilder(text);
            this.myRanges = new Ranges();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/util/StringMatcherSequencedBuilder$TextAccumulator", "<init>"));
        }
    }

    private static class MatcherPart {
        private final boolean myAnyPrefix;
        @Nullable
        private final String myText;
        @Nullable
        private final Ranges myRanges;

        private MatcherPart(boolean anyPrefix, @Nullable TextAccumulator textAccumulator) {
            this.myAnyPrefix = anyPrefix;
            if (textAccumulator == null) {
                this.myText = null;
                this.myRanges = null;
            } else {
                this.myText = textAccumulator.myText.toString();
                this.myRanges = textAccumulator.myRanges;
            }
        }
    }

    private static class Matcher {
        private final List<MatcherPart> myMatcherParts;

        public Matcher(@NotNull List<AbstractStringMatcherBuilder.MatchPart> parts) {
            if (parts == null) {
                Matcher.$$$reportNull$$$0(0);
            }
            this.myMatcherParts = new ArrayList<MatcherPart>();
            this.init(parts);
        }

        private void init(@NotNull List<AbstractStringMatcherBuilder.MatchPart> parts) {
            if (parts == null) {
                Matcher.$$$reportNull$$$0(1);
            }
            boolean currentAny = false;
            TextAccumulator currentText = null;
            block6: for (AbstractStringMatcherBuilder.MatchPart part : parts) {
                switch (part.getType()) {
                    case ANY: {
                        if (currentText != null) {
                            this.myMatcherParts.add(new MatcherPart(currentAny, currentText));
                            currentText = null;
                        } else if (currentAny) {
                            throw new IllegalStateException("Wrong pattern: any+any");
                        }
                        currentAny = true;
                        continue block6;
                    }
                    case STATIC: {
                        if (currentText == null) {
                            currentText = new TextAccumulator(part.getText());
                            continue block6;
                        }
                        currentText.myText.append(part.getText());
                        continue block6;
                    }
                    case GROUP_START: {
                        if (currentText == null) {
                            currentText = new TextAccumulator("");
                        }
                        currentText.myRanges.addStart(currentText.myText.length());
                        continue block6;
                    }
                    case GROUP_END: {
                        if (currentText == null) {
                            currentText = new TextAccumulator("");
                        }
                        currentText.myRanges.addEnd(currentText.myText.length());
                        continue block6;
                    }
                }
                throw new IllegalStateException("Unknown part type '" + (Object)((Object)part.getType()) + "'");
            }
            if (currentAny || currentText != null) {
                this.myMatcherParts.add(new MatcherPart(currentAny, currentText));
            }
        }

        public StringMatcher.MatchResult match(@NotNull String text) {
            MatcherPart lastPart;
            if (text == null) {
                Matcher.$$$reportNull$$$0(2);
            }
            int matcherPartsCount = this.myMatcherParts.size();
            final int[] textStartIndexes = new int[matcherPartsCount];
            StringMatcher.MatchResult.Range[] anyRanges = null;
            int parsedIndex = 0;
            if (matcherPartsCount > 1 && (lastPart = this.myMatcherParts.get(matcherPartsCount - 1)).myText != null && !text.endsWith(lastPart.myText)) {
                return StringMatcher.MatchResult.noMatch();
            }
            for (int partIndex = 0; partIndex < matcherPartsCount; ++partIndex) {
                if (parsedIndex >= text.length()) {
                    return StringMatcher.MatchResult.noMatch();
                }
                MatcherPart matcherPart = this.myMatcherParts.get(partIndex);
                if (StringUtil.isEmpty((String)matcherPart.myText)) {
                    if (!matcherPart.myAnyPrefix) {
                        throw new IllegalStateException("Invalid matching: empty MatcherPart");
                    }
                    if (anyRanges == null) {
                        anyRanges = new StringMatcher.MatchResult.Range[matcherPartsCount];
                    }
                    anyRanges[partIndex] = new StringMatcher.MatchResult.Range(parsedIndex, text.length());
                    textStartIndexes[partIndex] = parsedIndex = text.length();
                    continue;
                }
                if (matcherPart.myAnyPrefix) {
                    int textIndex = text.indexOf(matcherPart.myText, parsedIndex + 1);
                    if (textIndex == -1) {
                        return StringMatcher.MatchResult.noMatch();
                    }
                    if (anyRanges == null) {
                        anyRanges = new StringMatcher.MatchResult.Range[matcherPartsCount];
                    }
                    anyRanges[partIndex] = new StringMatcher.MatchResult.Range(parsedIndex, textIndex);
                    parsedIndex = textIndex + matcherPart.myText.length();
                } else {
                    if (!text.startsWith(matcherPart.myText)) {
                        return StringMatcher.MatchResult.noMatch();
                    }
                    parsedIndex += matcherPart.myText.length();
                    if (anyRanges == null) {
                        anyRanges = new StringMatcher.MatchResult.Range[matcherPartsCount];
                    }
                    anyRanges[partIndex] = null;
                }
                textStartIndexes[partIndex] = parsedIndex - matcherPart.myText.length();
            }
            if (parsedIndex != text.length()) {
                return StringMatcher.MatchResult.noMatch();
            }
            final StringMatcher.MatchResult.Range[] finalAnyRanges = anyRanges;
            return StringMatcher.MatchResult.match(new StringMatcher.MatchResult.Supplier<List<StringMatcher.MatchResult.Range>>(){
                private List<StringMatcher.MatchResult.Range> cached = null;

                @Override
                public List<StringMatcher.MatchResult.Range> get() {
                    if (this.cached == null) {
                        this.cached = new ArrayList<StringMatcher.MatchResult.Range>(textStartIndexes.length);
                        for (int i = 0; i < textStartIndexes.length; ++i) {
                            Ranges ranges;
                            StringMatcher.MatchResult.Range additionalRange = finalAnyRanges[i];
                            if (additionalRange != null && (this.cached.isEmpty() || this.cached.get((int)(this.cached.size() - 1)).endIndex != -1)) {
                                this.cached.add(additionalRange);
                            }
                            if ((ranges = ((MatcherPart)myMatcherParts.get(i)).myRanges) == null) continue;
                            ranges.addTo(this.cached, textStartIndexes[i]);
                        }
                        if (!this.cached.isEmpty() && this.cached.get((int)(this.cached.size() - 1)).endIndex == -1) {
                            throw new IllegalStateException("Group is opened at " + this.cached.get((int)(this.cached.size() - 1)).startIndex + " and is not closed till the end");
                        }
                    }
                    return this.cached;
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parts";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "jetbrains/buildServer/util/StringMatcherSequencedBuilder$Matcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "init";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "match";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

