/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import jetbrains.buildServer.util.TimeIntervalSupplier;
import org.jetbrains.annotations.NotNull;

public class TimeIntervalAction {
    private static final Runnable EMPTY_ACTION = new Runnable(){

        @Override
        public void run() {
        }
    };
    private final TimeIntervalSupplier myDelaySupplier;
    private final Runnable myDefaultAction;
    private final AtomicLong myLastActionStartTime;
    private final AtomicLong myLastActionFinishTime;

    /*
     * WARNING - void declaration
     */
    public TimeIntervalAction(final long delayMs, @NotNull Runnable runnable) {
        void defaultAction;
        if (runnable == null) {
            TimeIntervalAction.$$$reportNull$$$0(0);
        }
        this(new TimeIntervalSupplier(){

            @Override
            public long get() {
                return delayMs;
            }
        }, (Runnable)defaultAction);
    }

    public TimeIntervalAction(@NotNull TimeIntervalSupplier delaySupplier, @NotNull Runnable defaultAction) {
        if (delaySupplier == null) {
            TimeIntervalAction.$$$reportNull$$$0(1);
        }
        if (defaultAction == null) {
            TimeIntervalAction.$$$reportNull$$$0(2);
        }
        this.myLastActionStartTime = new AtomicLong(-1L);
        this.myLastActionFinishTime = new AtomicLong(-1L);
        this.myDelaySupplier = delaySupplier;
        this.myDefaultAction = defaultAction;
    }

    public TimeIntervalAction(@NotNull TimeIntervalSupplier delaySupplier) {
        if (delaySupplier == null) {
            TimeIntervalAction.$$$reportNull$$$0(3);
        }
        this(delaySupplier, EMPTY_ACTION);
    }

    public TimeIntervalAction(long delayMs) {
        this(delayMs, EMPTY_ACTION);
    }

    public boolean execute() {
        return this.executeCustomAction(this.myDefaultAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeCustomAction(@NotNull Runnable action) {
        if (action == null) {
            TimeIntervalAction.$$$reportNull$$$0(4);
        }
        long lastStartTime = this.myLastActionStartTime.get();
        long curTime = System.nanoTime();
        if ((lastStartTime == -1L || TimeUnit.NANOSECONDS.toMillis(curTime - lastStartTime) > this.myDelaySupplier.get()) && this.myLastActionStartTime.compareAndSet(lastStartTime, curTime)) {
            try {
                action.run();
                boolean bl = true;
                return bl;
            }
            finally {
                AtomicLong atomicLong = this.myLastActionStartTime;
                synchronized (atomicLong) {
                    if (this.myLastActionStartTime.get() == curTime) {
                        this.myLastActionFinishTime.set(System.nanoTime());
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetLastActionTime() {
        AtomicLong atomicLong = this.myLastActionStartTime;
        synchronized (atomicLong) {
            this.myLastActionStartTime.set(-1L);
            this.myLastActionFinishTime.set(-1L);
        }
    }

    public long getLastActionTime() {
        return this.myLastActionFinishTime.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultAction";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delaySupplier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/util/TimeIntervalAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "executeCustomAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

