/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TomcatVersion {
    private static final Pattern APACHE_TOMCAT_SERVER_INFO_PATTERN = Pattern.compile("^\\QApache Tomcat/\\E(\\d+)\\.(\\d+)(?:\\.(\\d+))?");

    @Nullable
    public static Version getTomcatVersion() {
        try {
            Class<?> cl = TomcatVersion.class.getClassLoader().loadClass("org.apache.catalina.util.ServerInfo");
            String serverInfo = (String)cl.getMethod("getServerInfo", new Class[0]).invoke(null, new Object[0]);
            String serverNumber = (String)cl.getMethod("getServerNumber", new Class[0]).invoke(null, new Object[0]);
            if (serverNumber == null) {
                return null;
            }
            return TomcatVersion.fromServerInfo(serverInfo);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Nullable
    public static Version fromServerInfo(@Nullable String serverInfo) {
        if (serverInfo == null) {
            return null;
        }
        if (!serverInfo.startsWith("Apache Tomcat")) {
            return null;
        }
        try {
            Matcher matcher = APACHE_TOMCAT_SERVER_INFO_PATTERN.matcher(serverInfo);
            boolean found = matcher.find();
            if (!found) {
                return null;
            }
            int vMajor = Integer.parseInt(TomcatVersion.getGroupOrZero(matcher, 1));
            int vMinor = Integer.parseInt(TomcatVersion.getGroupOrZero(matcher, 2));
            int vBuild = Integer.parseInt(TomcatVersion.getGroupOrZero(matcher, 3));
            return new Version(vMajor, vMinor, vBuild);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @NotNull
    private static String getGroupOrZero(Matcher matcher, int group) {
        String value = matcher.group(group);
        String string = value != null ? value : "0";
        if (string == null) {
            TomcatVersion.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/TomcatVersion", "getGroupOrZero"));
    }

    public static class Version {
        private final int myMajor;
        private final int myMinor;
        private final int myBuild;

        public Version(int major, int minor, int build) {
            this.myMajor = major;
            this.myMinor = minor;
            this.myBuild = build;
        }

        public int getMajor() {
            return this.myMajor;
        }

        public int getMinor() {
            return this.myMinor;
        }

        public int getBuild() {
            return this.myBuild;
        }

        public String toString() {
            return this.myMajor + "." + this.myMinor + "." + this.myBuild;
        }
    }
}

