/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import jetbrains.buildServer.TempFolderProvider;
import jetbrains.buildServer.util.FileUtil;
import org.jetbrains.annotations.NotNull;

public class Win32RegistryAccessorUnpacker {
    private static final String EXE = "JetRegistry.exe";
    private static final String[] RESOURCE_PATHS = new String[]{"JetRegistry.exe"};
    private final TempFolderProvider myTempFolders;
    private File myExeFile;
    private File myTempFolder;

    public Win32RegistryAccessorUnpacker(TempFolderProvider tempFolders) {
        this.myTempFolders = tempFolders;
    }

    public synchronized void dispose() {
        if (this.myExeFile != null && this.myExeFile.exists()) {
            FileUtil.delete((File)this.myExeFile);
            this.myExeFile = null;
        }
        if (this.myTempFolder != null && this.myTempFolder.exists()) {
            FileUtil.delete((File)this.myTempFolder);
            this.myTempFolder = null;
        }
    }

    @NotNull
    public synchronized File getExe() throws IOException {
        if (this.myExeFile == null || !this.myExeFile.exists()) {
            if (this.myTempFolder != null) {
                FileUtil.delete((File)this.myTempFolder);
            }
            File tempPath = this.myTempFolders.getTempDirectory();
            this.myTempFolder = FileUtil.createTempDirectory((String)"TeamCity", (String)"jetRegistry", (File)tempPath);
            for (String path : RESOURCE_PATHS) {
                File f = new File(this.myTempFolder, path);
                FileUtil.copyResource(this.getClass(), (String)("/bin/" + path), (File)f);
                if (!path.equals(EXE)) continue;
                this.myExeFile = f;
            }
            if (!this.myExeFile.exists()) {
                throw new FileNotFoundException("Failed to extract windows registry accessor executable. Windows registry will be unavailable.");
            }
        }
        File file = this.myExeFile;
        if (file == null) {
            Win32RegistryAccessorUnpacker.$$$reportNull$$$0(0);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/Win32RegistryAccessorUnpacker", "getExe"));
    }
}

