/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import jetbrains.buildServer.ExecResult;
import jetbrains.buildServer.SimpleCommandLineProcessRunner;
import jetbrains.buildServer.util.Bitness;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.Win32RegistryAccessor;
import jetbrains.buildServer.util.Win32RegistryAccessorUnpacker;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class Win32RegistryNativeAccessorImpl
implements Win32RegistryAccessor {
    private static final Logger LOG = Logger.getLogger(Win32RegistryNativeAccessorImpl.class);
    private final Win32RegistryAccessorUnpacker myUnpacker;

    public Win32RegistryNativeAccessorImpl(Win32RegistryAccessorUnpacker unpacker) {
        this.myUnpacker = unpacker;
    }

    private <T> T execute(@NotNull List<String> args, @NotNull ParseOutputAction<T> action) {
        if (args == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(0);
        }
        if (action == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(1);
        }
        if (!SystemInfo.isWindows) {
            return action.getDefault();
        }
        try {
            GeneralCommandLine cmd = new GeneralCommandLine();
            cmd.setExePath(this.myUnpacker.getExe().getAbsolutePath());
            cmd.addParameters(args);
            ExecResult res = SimpleCommandLineProcessRunner.runCommand((GeneralCommandLine)cmd, (byte[])new byte[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Executing JetRegistry with ('|' is arg separator): " + StringUtil.join(args, (String)"|")));
                LOG.debug((Object)("ExitCode: " + res.getExitCode()));
                LOG.debug((Object)("Output:\n" + res.getStdout()));
                LOG.debug((Object)("Error:\n" + res.getStderr()));
            }
            return action.parse(res.getExitCode(), res.getStdout().trim() + res.getStderr().trim());
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to read windows registry. " + e.getMessage()));
            LOG.debug((Object)("Windows registry with arguments (where '|' is separator): " + StringUtil.join(args, (String)"|") + ". " + e.getMessage()), (Throwable)e);
            return action.getDefault();
        }
    }

    private <T> T execute(@NotNull Win32RegistryAccessor.Hive hive, @NotNull Bitness bitness, @NotNull Command command, @NotNull String path, @NotNull Collection<String> extra, @NotNull ParseOutputAction<T> action) {
        if (hive == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(2);
        }
        if (bitness == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(3);
        }
        if (command == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(4);
        }
        if (path == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(5);
        }
        if (extra == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(6);
        }
        if (action == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(7);
        }
        if (!SystemInfo.isWindows) {
            return action.getDefault();
        }
        boolean isW2k = SystemInfo.isWindows2000;
        if (isW2k && bitness == Bitness.BIT64) {
            return action.getDefault();
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.hiveToKey(hive));
        args.add(isW2k ? "native" : this.bitnessToKey(bitness));
        args.add(command.getCommand());
        args.add(this.pathToKey(path));
        args.addAll(extra);
        return this.execute(args, action);
    }

    @NotNull
    private String hiveToKey(@NotNull Win32RegistryAccessor.Hive hive) {
        if (hive == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(8);
        }
        switch (hive) {
            case LOCAL_MACHINE: {
                if ("hklm" == null) {
                    Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(9);
                }
                return "hklm";
            }
            case CLASSES_ROOT: {
                if ("hkcr" == null) {
                    Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(10);
                }
                return "hkcr";
            }
            case CURRENT_USER: {
                if ("hkcu" == null) {
                    Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(11);
                }
                return "hkcu";
            }
        }
        throw new RuntimeException("Unsupported key: " + hive);
    }

    @NotNull
    private String bitnessToKey(@NotNull Bitness bitness) {
        if (bitness == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(12);
        }
        switch (bitness) {
            case BIT64: {
                if ("x64" == null) {
                    Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(13);
                }
                return "x64";
            }
            case BIT32: {
                if ("x86" == null) {
                    Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(14);
                }
                return "x86";
            }
        }
        throw new RuntimeException("Unsupported bitness: " + bitness);
    }

    private String pathToKey(@NotNull String path) {
        if (path == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(15);
        }
        return path.replace('/', '\\');
    }

    @NotNull
    public Set<String> listSubKeys(@NotNull Win32RegistryAccessor.Hive hive, @NotNull Bitness bitness, @NotNull String keyPath) {
        if (hive == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(16);
        }
        if (bitness == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(17);
        }
        if (keyPath == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(18);
        }
        Set<String> set = this.execute(hive, bitness, Command.ListKeys, keyPath, Collections.emptyList(), this.getSetParser());
        if (set == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(19);
        }
        return set;
    }

    public String readRegistryText(@NotNull Win32RegistryAccessor.Hive hive, @NotNull Bitness bitness, @NotNull String keyPath, @NotNull String entryName) {
        if (hive == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(20);
        }
        if (bitness == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(21);
        }
        if (keyPath == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(22);
        }
        if (entryName == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(23);
        }
        return this.execute(hive, bitness, Command.Get, keyPath, Collections.singleton(entryName.trim()), this.getStringParser());
    }

    public File readRegistryFile(@NotNull Win32RegistryAccessor.Hive hive, @NotNull Bitness bitness, @NotNull String keyPath, @NotNull String entryName) {
        String path;
        if (hive == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(24);
        }
        if (bitness == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(25);
        }
        if (keyPath == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(26);
        }
        if (entryName == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(27);
        }
        if ((path = this.readRegistryText(hive, bitness, keyPath, entryName)) != null) {
            File file = new File(path);
            if (!file.isAbsolute()) {
                return null;
            }
            return file.exists() ? file : null;
        }
        return null;
    }

    @NotNull
    public Set<String> listValueNames(@NotNull Win32RegistryAccessor.Hive hive, @NotNull Bitness bitness, @NotNull String keyPath) {
        if (hive == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(28);
        }
        if (bitness == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(29);
        }
        if (keyPath == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(30);
        }
        Set<String> set = this.execute(hive, bitness, Command.ListValues, keyPath, Collections.emptyList(), this.getSetParser());
        if (set == null) {
            Win32RegistryNativeAccessorImpl.$$$reportNull$$$0(31);
        }
        return set;
    }

    private ParseOutputAction<Set<String>> getSetParser() {
        return new ParseOutputAction<Set<String>>(){

            @Override
            public Set<String> parse(int exitCode, String output) {
                if (exitCode != 0) {
                    return this.getDefault();
                }
                String[] strings = output.split("[\\r\\n]+");
                TreeSet<String> set = new TreeSet<String>();
                for (String s : strings) {
                    if ((s = s.trim()).length() <= 0) continue;
                    set.add(s);
                }
                return set;
            }

            @Override
            public Set<String> getDefault() {
                return Collections.emptySet();
            }
        };
    }

    private ParseOutputAction<String> getStringParser() {
        return new ParseOutputAction<String>(){

            @Override
            public String parse(int exitCode, String output) {
                if (exitCode != 0) {
                    return this.getDefault();
                }
                return output.trim();
            }

            @Override
            public String getDefault() {
                return null;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 19: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 19: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: 
            case 8: 
            case 16: 
            case 20: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hive";
                break;
            }
            case 3: 
            case 12: 
            case 17: 
            case 21: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bitness";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extra";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 19: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/Win32RegistryNativeAccessorImpl";
                break;
            }
            case 18: 
            case 22: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPath";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/Win32RegistryNativeAccessorImpl";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "hiveToKey";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "bitnessToKey";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "listSubKeys";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "listValueNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hiveToKey";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 19: 
            case 31: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "bitnessToKey";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "pathToKey";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "listSubKeys";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "readRegistryText";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "readRegistryFile";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "listValueNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 19: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum Command {
        ListKeys("list-keys"),
        ListValues("list-values"),
        Get("get");

        private final String myCommand;

        private Command(String command) {
            this.myCommand = command;
        }

        @NotNull
        public String getCommand() {
            String string = this.myCommand;
            if (string == null) {
                Command.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/Win32RegistryNativeAccessorImpl$Command", "getCommand"));
        }
    }

    private static interface ParseOutputAction<T> {
        public T parse(int var1, String var2);

        public T getDefault();
    }
}

