/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import jetbrains.buildServer.util.CloseAwareInputStream;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.XmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class XmlXppAbstractParser {
    private static final XmlReturn XMLRETURN = new XmlReturn(){};
    private XmlTextTrimInfo myTrimInfo = new XmlTextTrimInfo(){

        @Override
        public long getMaxSize() {
            return 0x500000L;
        }

        @Override
        public String getTrimText(long actualSize) {
            return "\r\nText was trimmed. Actual size was: " + StringUtil.formatFileSize((long)actualSize);
        }
    };

    public void setTrimInfo(@NotNull XmlTextTrimInfo info) {
        if (info == null) {
            XmlXppAbstractParser.$$$reportNull$$$0(0);
        }
        this.myTrimInfo = info;
    }

    public void parse(File file) throws IOException {
        this.parse(new BufferedInputStream(new FileInputStream(file)));
    }

    public void parse(InputStream file) throws IOException {
        try (CloseAwareInputStream is = new CloseAwareInputStream(file);){
            this.parseWithSAX(new InputSource((InputStream)is));
        }
    }

    private void parseWithSAX(InputSource input) throws SAXException, IOException {
        XMLReader xmlReader = this.createXMLReader();
        xmlReader.setContentHandler(new ContentHandler(){
            private StateInfo myState;

            @Override
            public void setDocumentLocator(Locator locator) {
            }

            @Override
            public void startDocument() throws SAXException {
                this.myState = new StateInfo("<root>", null);
                ArrayList<XmlHandler> list = new ArrayList<XmlHandler>(XmlXppAbstractParser.this.getRootHandlers());
                this.myState.setHandlers(list.toArray(new XmlHandler[list.size()]));
            }

            @Override
            public void endDocument() throws SAXException {
                this.myState.finished();
                this.myState = null;
            }

            @Override
            public void startPrefixMapping(String prefix, String uri) throws SAXException {
            }

            @Override
            public void endPrefixMapping(String prefix) throws SAXException {
            }

            @Override
            public void startElement(String uri, final String localName, String qName, final Attributes atts) throws SAXException {
                if (this.myState == null) {
                    return;
                }
                XmlHandler[] handlers = this.myState.getHandlers();
                this.myState = new StateInfo(localName, this.myState);
                for (XmlHandler handler : handlers) {
                    if (!handler.accepts(localName)) continue;
                    final StateInfo info = this.myState;
                    handler.processElement(new XmlElementInfo(){

                        @Override
                        @NotNull
                        public XmlElementVisitor visitChildren(XmlHandler ... handlers) {
                            if (handlers == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            info.setHandlers(handlers);
                            StateInfo stateInfo = info;
                            if (stateInfo == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return stateInfo;
                        }

                        @Override
                        public String getAttribute(@NotNull String name) {
                            if (name == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            return atts.getValue(name);
                        }

                        @Override
                        @NotNull
                        public Map<String, String> getAttributes() {
                            int length = atts.getLength();
                            HashMap<String, String> attributes = new HashMap<String, String>(length);
                            for (int i = 0; i < length; ++i) {
                                attributes.put(atts.getLocalName(i), atts.getValue(i));
                            }
                            HashMap<String, String> hashMap = attributes;
                            if (hashMap == null) {
                                1.$$$reportNull$$$0(3);
                            }
                            return hashMap;
                        }

                        @Override
                        @NotNull
                        public XmlElementVisitor visitText(@NotNull TextHandler handler) {
                            if (handler == null) {
                                1.$$$reportNull$$$0(4);
                            }
                            info.setTextHandler(handler);
                            StateInfo stateInfo = info;
                            if (stateInfo == null) {
                                1.$$$reportNull$$$0(5);
                            }
                            return stateInfo;
                        }

                        @Override
                        @NotNull
                        public XmlReturn noDeep() {
                            XmlReturn xmlReturn = XMLRETURN;
                            if (xmlReturn == null) {
                                1.$$$reportNull$$$0(6);
                            }
                            return xmlReturn;
                        }

                        @Override
                        @NotNull
                        public String getLocalName() {
                            String string = localName;
                            if (string == null) {
                                1.$$$reportNull$$$0(7);
                            }
                            return string;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n2;
                            String string;
                            switch (n) {
                                default: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                                case 1: 
                                case 3: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    n2 = 3;
                                    break;
                                }
                                case 1: 
                                case 3: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    n2 = 2;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n2];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "handlers";
                                    break;
                                }
                                case 1: 
                                case 3: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "jetbrains/buildServer/util/XmlXppAbstractParser$4$1";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "name";
                                    break;
                                }
                                case 4: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "handler";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "jetbrains/buildServer/util/XmlXppAbstractParser$4$1";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "visitChildren";
                                    break;
                                }
                                case 3: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getAttributes";
                                    break;
                                }
                                case 5: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "visitText";
                                    break;
                                }
                                case 6: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "noDeep";
                                    break;
                                }
                                case 7: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getLocalName";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "visitChildren";
                                    break;
                                }
                                case 1: 
                                case 3: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray;
                                    objectArray[2] = "getAttribute";
                                    break;
                                }
                                case 4: {
                                    objectArray = objectArray;
                                    objectArray[2] = "visitText";
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n) {
                                default: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                                case 1: 
                                case 3: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    });
                    return;
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (this.myState != null) {
                    this.myState.finished();
                    this.myState = this.myState.getParentState();
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.myState != null) {
                    this.myState.append(ch, start, length);
                }
            }

            @Override
            public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
                if (this.myState != null) {
                    this.myState.append(ch, start, length);
                }
            }

            @Override
            public void processingInstruction(String target, String data) throws SAXException {
            }

            @Override
            public void skippedEntity(String name) throws SAXException {
            }

            class Capturer {
                private final TextHandler myHandler;
                private final StringBuilder myText = new StringBuilder();
                private long mySize = 0L;
                private boolean myTextFound = false;

                Capturer(TextHandler handler) {
                    this.myHandler = handler;
                }

                public void finished() {
                    if (!this.myTextFound) {
                        this.myHandler.setText("");
                    } else {
                        if (this.mySize > XmlXppAbstractParser.this.myTrimInfo.getMaxSize()) {
                            this.myText.append(XmlXppAbstractParser.this.myTrimInfo.getTrimText(this.mySize));
                        }
                        this.myHandler.setText(this.myText.toString());
                    }
                }

                public void append(char[] ch, int start, int length) {
                    this.myTextFound = true;
                    this.mySize += (long)length;
                    long pLength = Math.min((long)length, XmlXppAbstractParser.this.myTrimInfo.getMaxSize() - (long)this.myText.length());
                    if (pLength > 0L) {
                        this.myText.append(ch, start, (int)pLength);
                    }
                }
            }

            class StateInfo
            implements XmlElementVisitor {
                private final String myElementName;
                private final StateInfo myParentState;
                private final List<XmlAction> myActions;
                private Capturer myTextHandler;
                private XmlHandler[] myHandlers;

                StateInfo(@Nullable String elementName, StateInfo parentState) {
                    if (elementName == null) {
                        StateInfo.$$$reportNull$$$0(0);
                    }
                    this.myActions = new ArrayList<XmlAction>(1);
                    this.myHandlers = new XmlHandler[0];
                    this.myElementName = elementName;
                    this.myParentState = parentState;
                }

                public String toString() {
                    return (this.myParentState != null ? this.myParentState + "/" : "") + this.myElementName;
                }

                public XmlHandler[] getHandlers() {
                    return this.myHandlers;
                }

                public void setHandlers(@NotNull XmlHandler[] handlers) {
                    if (handlers == null) {
                        StateInfo.$$$reportNull$$$0(1);
                    }
                    this.myHandlers = handlers;
                }

                @Nullable
                public StateInfo getParentState() {
                    return this.myParentState;
                }

                public void setTextHandler(TextHandler textHandler) {
                    if (this.myTextHandler != null) {
                        throw new IllegalArgumentException();
                    }
                    this.myTextHandler = new Capturer(textHandler);
                }

                public void finished() {
                    if (this.myTextHandler != null) {
                        this.myTextHandler.finished();
                    }
                    for (XmlAction action : this.myActions) {
                        action.apply();
                    }
                    for (XmlHandler handler : this.myHandlers) {
                        if (!(handler instanceof CloseableHandler)) continue;
                        ((CloseableHandler)((Object)handler)).close();
                    }
                }

                @Override
                public XmlReturn than(@NotNull XmlAction action) {
                    if (action == null) {
                        StateInfo.$$$reportNull$$$0(2);
                    }
                    this.myActions.add(action);
                    return XMLRETURN;
                }

                public void append(char[] ch, int start, int length) {
                    if (this.myTextHandler == null) {
                        return;
                    }
                    this.myTextHandler.append(ch, start, length);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "elementName";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "handlers";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "action";
                            break;
                        }
                    }
                    objectArray2[1] = "jetbrains/buildServer/util/XmlXppAbstractParser$4$StateInfo";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "<init>";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "setHandlers";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "than";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }
        });
        xmlReader.parse(input);
    }

    @NotNull
    private XMLReader createXMLReader() throws SAXException {
        XMLReader xMLReader = XmlUtil.createXMLReader((boolean)false);
        if (xMLReader == null) {
            XmlXppAbstractParser.$$$reportNull$$$0(1);
        }
        return xMLReader;
    }

    protected abstract List<XmlHandler> getRootHandlers();

    protected static XmlHandler elementsPath(final @NotNull Handler deeper, String ... path) {
        if (deeper == null) {
            XmlXppAbstractParser.$$$reportNull$$$0(2);
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(path));
        final String last = (String)list.get(list.size() - 1);
        list.remove(list.size() - 1);
        return XmlXppAbstractParser.elementsPath(new XmlHandler(){

            @Override
            public boolean accepts(@NotNull String name) {
                if (name == null) {
                    5.$$$reportNull$$$0(0);
                }
                return last.equals(name);
            }

            @Override
            public XmlReturn processElement(@NotNull XmlElementInfo reader) {
                if (reader == null) {
                    5.$$$reportNull$$$0(1);
                }
                return deeper.processElement(reader);
            }

            public String toString() {
                return last + "/" + deeper.toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reader";
                        break;
                    }
                }
                objectArray2[1] = "jetbrains/buildServer/util/XmlXppAbstractParser$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "accepts";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, list);
    }

    @NotNull
    protected static XmlHandler elementsPath(final @NotNull TextHandler text, String ... path) {
        if (text == null) {
            XmlXppAbstractParser.$$$reportNull$$$0(3);
        }
        XmlHandler xmlHandler = XmlXppAbstractParser.elementsPath(new Handler(){

            @Override
            public XmlReturn processElement(@NotNull XmlElementInfo reader) {
                if (reader == null) {
                    6.$$$reportNull$$$0(0);
                }
                return reader.visitText(text);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "jetbrains/buildServer/util/XmlXppAbstractParser$6", "processElement"));
            }
        }, path);
        if (xmlHandler == null) {
            XmlXppAbstractParser.$$$reportNull$$$0(4);
        }
        return xmlHandler;
    }

    protected static XmlHandler elementsPatternPath(final @NotNull Handler deeper, final String patternPath) {
        if (deeper == null) {
            XmlXppAbstractParser.$$$reportNull$$$0(5);
        }
        final Pattern pt = Pattern.compile(patternPath);
        return new XmlHandler(){

            @Override
            public boolean accepts(@NotNull String name) {
                if (name == null) {
                    7.$$$reportNull$$$0(0);
                }
                return pt.matcher(name).matches();
            }

            @Override
            public XmlReturn processElement(@NotNull XmlElementInfo reader) {
                if (reader == null) {
                    7.$$$reportNull$$$0(1);
                }
                return deeper.processElement(reader);
            }

            public String toString() {
                return "[ " + patternPath + " ]/" + deeper.toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reader";
                        break;
                    }
                }
                objectArray2[1] = "jetbrains/buildServer/util/XmlXppAbstractParser$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "accepts";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    protected static XmlHandler elementsPath(XmlHandler deeper, List<String> list) {
        Collections.reverse(list);
        for (final String element : list) {
            final XmlHandler actualDeeper = deeper;
            deeper = new XmlHandler(){

                @Override
                public boolean accepts(@NotNull String name) {
                    if (name == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    return element.equals(name);
                }

                @Override
                public XmlReturn processElement(@NotNull XmlElementInfo reader) {
                    if (reader == null) {
                        8.$$$reportNull$$$0(1);
                    }
                    return reader.visitChildren(actualDeeper);
                }

                public String toString() {
                    return element + "/" + actualDeeper.toString();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "name";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "reader";
                            break;
                        }
                    }
                    objectArray2[1] = "jetbrains/buildServer/util/XmlXppAbstractParser$8";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "accepts";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processElement";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        return deeper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/XmlXppAbstractParser";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deeper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/XmlXppAbstractParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createXMLReader";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setTrimInfo";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "elementsPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "elementsPatternPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface TextHandler {
        public void setText(@NotNull String var1);
    }

    protected static interface XmlTextTrimInfo {
        public long getMaxSize();

        public String getTrimText(long var1);
    }

    protected static interface XmlReturn {
    }

    protected static interface XmlAction {
        public void apply();
    }

    protected static interface XmlElementVisitor
    extends XmlReturn {
        public XmlReturn than(@NotNull XmlAction var1);
    }

    protected static interface XmlElementInfo {
        @NotNull
        public XmlElementVisitor visitChildren(XmlHandler ... var1);

        @Nullable
        public String getAttribute(@NotNull String var1);

        @NotNull
        public Map<String, String> getAttributes();

        @NotNull
        public XmlElementVisitor visitText(@NotNull TextHandler var1);

        @NotNull
        public XmlReturn noDeep();

        @NotNull
        public String getLocalName();
    }

    protected static interface CloseableHandler
    extends Handler {
        public void close();
    }

    protected static interface XmlHandler
    extends Handler {
        public boolean accepts(@NotNull String var1);
    }

    protected static interface Handler {
        public XmlReturn processElement(@NotNull XmlElementInfo var1);
    }
}

