/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.graph;

import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import jetbrains.buildServer.util.graph.BFSVisitor;
import jetbrains.buildServer.util.graph.DAG;
import jetbrains.buildServer.util.graph.DAGs;
import jetbrains.buildServer.util.graph.Edge;
import org.jetbrains.annotations.NotNull;

public class DAGUtil {
    @NotNull
    public static <T> Pair<DAG<T>, List<T>> removeCycles(@NotNull Collection<Pair<T, T>> edges) {
        if (edges == null) {
            DAGUtil.$$$reportNull$$$0(0);
        }
        ArrayList<Pair<T, T>> ed = new ArrayList<Pair<T, T>>(edges);
        DAG graph = DAGs.createFromEdges(ed);
        HashSet visited = new HashSet();
        HashSet<T> allNodes = new HashSet<T>(graph.getAllNodes());
        HashSet<T> cycle = new HashSet<T>();
        boolean found = true;
        while (!allNodes.isEmpty() && found) {
            found = false;
            HashSet layer = new HashSet();
            for (Object e : allNodes) {
                List<T> parents = graph.getParents(e);
                if (!visited.containsAll(parents)) continue;
                visited.add(e);
                found = true;
                layer.add(e);
            }
            allNodes.removeAll(layer);
            if (found || allNodes.isEmpty()) continue;
            cycle.addAll(allNodes);
        }
        if (cycle.isEmpty()) {
            Pair pair = Pair.create(graph, Collections.emptyList());
            if (pair == null) {
                DAGUtil.$$$reportNull$$$0(1);
            }
            return pair;
        }
        ArrayList<Pair> filtered = new ArrayList<Pair>(ed.size());
        for (Pair pair : ed) {
            if (cycle.contains(pair.first) || cycle.contains(pair.second)) continue;
            filtered.add(pair);
        }
        DAG dag = DAGs.createFromEdges(filtered);
        Pair pair = Pair.create(dag, new ArrayList(cycle));
        if (pair == null) {
            DAGUtil.$$$reportNull$$$0(2);
        }
        return pair;
    }

    public static <T> Collection<Pair<T, T>> omitRedundantEdges(@NotNull Collection<Pair<T, T>> edges) {
        if (edges == null) {
            DAGUtil.$$$reportNull$$$0(3);
        }
        DAG<T> dag = DAGs.createFromEdges(edges);
        HashSet<Edge<T>> excludedEdges = new HashSet<Edge<T>>();
        for (T n : dag.getAllNodes()) {
            List<T> parents = dag.getParents(n);
            HashSet<Pair> processed = new HashSet<Pair>();
            if (parents.size() <= 1) continue;
            block1: for (T parent : parents) {
                if (dag.getChildren(parent).size() == 1) continue;
                for (T child : parents) {
                    if (parent == child || processed.contains(Pair.create(parent, child)) || !DAGUtil.isChildReachable(dag, parent, child, n)) continue;
                    excludedEdges.add(Edge.createEdge(n, parent));
                    processed.add(Pair.create(child, parent));
                    continue block1;
                }
            }
        }
        if (!excludedEdges.isEmpty()) {
            ArrayList<Pair<T, T>> newEdges = new ArrayList<Pair<T, T>>();
            for (Pair<T, T> e : edges) {
                if (excludedEdges.contains(e)) continue;
                newEdges.add(e);
            }
            return newEdges;
        }
        return edges;
    }

    private static <T> boolean isChildReachable(@NotNull DAG<T> dag, final @NotNull T parent, final @NotNull T child, final @NotNull T stopNode) {
        if (dag == null) {
            DAGUtil.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            DAGUtil.$$$reportNull$$$0(5);
        }
        if (child == null) {
            DAGUtil.$$$reportNull$$$0(6);
        }
        if (stopNode == null) {
            DAGUtil.$$$reportNull$$$0(7);
        }
        final boolean[] res = new boolean[1];
        dag.reverseBreadthFirstSearch(parent, new BFSVisitor<T>(){

            @Override
            public boolean discover(@NotNull T node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (node == parent) {
                    return true;
                }
                if (node == stopNode) {
                    return false;
                }
                if (res[0]) {
                    return false;
                }
                res[0] = child == node;
                return !res[0];
            }

            @Override
            public void searchFinished() {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "jetbrains/buildServer/util/graph/DAGUtil$1", "discover"));
            }
        });
        return res[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edges";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/graph/DAGUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dag";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/graph/DAGUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "removeCycles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeCycles";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "omitRedundantEdges";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isChildReachable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

