/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.graph;

import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.util.graph.DAG;
import jetbrains.buildServer.util.graph.DAGImpl;
import jetbrains.buildServer.util.graph.EmptyDAG;
import jetbrains.buildServer.util.graph.ReachabilityIndex;
import jetbrains.buildServer.util.graph.ReachabilityIndexBuilder;
import jetbrains.buildServer.util.graph.ReachabilityIndexExt;
import jetbrains.buildServer.util.graph.ReachabilityIndexImpl;
import org.jetbrains.annotations.NotNull;

public final class DAGs {
    @NotNull
    public static <T> DAG<T> emptyDAG() {
        EmptyDAG emptyDAG = new EmptyDAG();
        if (emptyDAG == null) {
            DAGs.$$$reportNull$$$0(0);
        }
        return emptyDAG;
    }

    @NotNull
    public static <T> DAG<T> createFromEdges(@NotNull Collection<? extends Pair<T, T>> edges) {
        if (edges == null) {
            DAGs.$$$reportNull$$$0(1);
        }
        DAGImpl dAGImpl = new DAGImpl(new EmptyDAG(), edges);
        if (dAGImpl == null) {
            DAGs.$$$reportNull$$$0(2);
        }
        return dAGImpl;
    }

    @NotNull
    public static <T> DAG<T> insertNodes(@NotNull DAG<T> dag, Map<T, List<T>> nodes) {
        if (dag == null) {
            DAGs.$$$reportNull$$$0(3);
        }
        DAG<T> dAG = DAGs.insertNodes(dag, nodes, true);
        if (dAG == null) {
            DAGs.$$$reportNull$$$0(4);
        }
        return dAG;
    }

    @NotNull
    public static <T> DAG<T> insertNodes(@NotNull DAG<T> dag, Map<T, List<T>> nodes, boolean insertBetweenNodes) {
        if (dag == null) {
            DAGs.$$$reportNull$$$0(5);
        }
        if (nodes.isEmpty()) {
            DAG<T> dAG = dag;
            if (dAG == null) {
                DAGs.$$$reportNull$$$0(6);
            }
            return dAG;
        }
        Collection<Pair<T, T>> edges = dag.getAllEdges();
        ArrayList<Object> newEdges = new ArrayList<Object>();
        HashMap<T, T> subst = new HashMap<T, T>();
        for (Map.Entry<T, List<T>> entry : nodes.entrySet()) {
            T node = entry.getKey();
            List<T> newNodes = entry.getValue();
            T parent = node;
            for (int i = newNodes.size() - 1; i >= 0; --i) {
                T newNode = newNodes.get(i);
                newEdges.add(Pair.create(newNode, parent));
                parent = newNode;
            }
            subst.put(node, parent);
        }
        if (insertBetweenNodes) {
            for (Pair pair : edges) {
                Object newParent = subst.get(pair.second);
                if (newParent != null) {
                    newEdges.add(Pair.create((Object)pair.first, newParent));
                    continue;
                }
                newEdges.add(pair);
            }
        } else {
            newEdges.addAll(edges);
        }
        DAG<T> dAG = DAGs.createFromEdges(newEdges);
        if (dAG == null) {
            DAGs.$$$reportNull$$$0(7);
        }
        return dAG;
    }

    @NotNull
    public static <T> ReachabilityIndex<T> createReachabilityIndex(@NotNull DAG<T> dag) {
        if (dag == null) {
            DAGs.$$$reportNull$$$0(8);
        }
        ReachabilityIndexImpl<T> reachabilityIndexImpl = new ReachabilityIndexBuilder<T>(dag).build();
        if (reachabilityIndexImpl == null) {
            DAGs.$$$reportNull$$$0(9);
        }
        return reachabilityIndexImpl;
    }

    @NotNull
    public static <T> ReachabilityIndexExt<T> createReachabilityIndexExt(@NotNull DAG<T> dag) {
        if (dag == null) {
            DAGs.$$$reportNull$$$0(10);
        }
        ReachabilityIndexExt<T> reachabilityIndexExt = new ReachabilityIndexBuilder<T>(dag).buildExt();
        if (reachabilityIndexExt == null) {
            DAGs.$$$reportNull$$$0(11);
        }
        return reachabilityIndexExt;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/graph/DAGs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edges";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyDAG";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/graph/DAGs";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromEdges";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "insertNodes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createReachabilityIndex";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createReachabilityIndexExt";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createFromEdges";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insertNodes";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createReachabilityIndex";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createReachabilityIndexExt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

