/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.graph;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import jetbrains.buildServer.util.graph.CycleDetectedException;
import jetbrains.buildServer.util.graph.DFSVisitor;
import jetbrains.buildServer.util.graph.DepthFirstSearch;
import jetbrains.buildServer.util.graph.Vertex;
import org.jetbrains.annotations.NotNull;

final class DFS<T>
implements DepthFirstSearch<T> {
    private final Map<Vertex<T>, Color> myColors;
    private final Stack<Vertex<T>> myStack;
    private final Stack<Vertex<T>> myPaused;
    private final DFSVisitor<T> myCallback;
    private final Vertex<T> myStart;
    private boolean myFinished;
    private final boolean myForward;

    DFS(@NotNull Vertex<T> start, @NotNull DFSVisitor<T> callback, boolean forward) {
        if (start == null) {
            DFS.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            DFS.$$$reportNull$$$0(1);
        }
        this.myColors = new HashMap<Vertex<T>, Color>();
        this.myStack = new Stack();
        this.myPaused = new Stack();
        this.myStart = start;
        this.myCallback = callback;
        this.myForward = forward;
    }

    @Override
    @NotNull
    public T getStart() {
        T t = this.myStart.getValue();
        if (t == null) {
            DFS.$$$reportNull$$$0(2);
        }
        return t;
    }

    @Override
    public void run() {
        this.forgetPausedSearch();
        this.runWhile(this.allNodesAreVisited());
    }

    @Override
    public void runWhile(@NotNull DepthFirstSearch.Predicate<T> predicate) {
        if (predicate == null) {
            DFS.$$$reportNull$$$0(3);
        }
        if (this.isFinished()) {
            return;
        }
        if (this.notInPausedSearch()) {
            this.pauseAt(this.myStart);
        }
        this.restorePausedSearch();
        this.visit(predicate);
    }

    private void forgetPausedSearch() {
        this.myPaused.clear();
        this.myFinished = false;
    }

    private boolean notInPausedSearch() {
        return this.myPaused.isEmpty();
    }

    private Vertex<T> pauseAt(Vertex<T> v) {
        return this.myPaused.push(v);
    }

    private boolean isFinished() {
        return this.myFinished;
    }

    private void restorePausedSearch() {
        while (!this.myPaused.isEmpty()) {
            this.myStack.push(this.myPaused.pop());
        }
    }

    private void visit(@NotNull DepthFirstSearch.Predicate<T> predicate) {
        if (predicate == null) {
            DFS.$$$reportNull$$$0(4);
        }
        while (!this.isEmpty()) {
            Vertex<T> v = this.peek();
            T value = v.getValue();
            if (predicate.apply(value)) {
                switch (this.getColor(v)) {
                    case WHITE: {
                        this.setColor(v, Color.GREY);
                        if (!this.myCallback.discover(value)) break;
                        this.pushNeighbours(v);
                        break;
                    }
                    case GREY: {
                        this.pop();
                        this.setColor(v, Color.BLACK);
                        this.myCallback.finish(value);
                        break;
                    }
                    case BLACK: {
                        this.pop();
                    }
                }
                continue;
            }
            this.pop();
            this.pauseAt(v);
        }
        if (this.myPaused.isEmpty()) {
            this.myFinished = true;
        }
    }

    private void pushNeighbours(Vertex<T> vertex) {
        List<Vertex<T>> neighbours = this.myForward ? vertex.getParents() : vertex.getChildren();
        block4: for (int i = neighbours.size() - 1; i >= 0; --i) {
            Vertex<T> n = neighbours.get(i);
            switch (this.getColor(n)) {
                case WHITE: {
                    this.push(n);
                    continue block4;
                }
                case GREY: {
                    throw new CycleDetectedException(vertex.getValue(), n.getValue());
                }
            }
        }
    }

    private void setColor(Vertex<T> v, Color color) {
        this.myColors.put(v, color);
    }

    private Color getColor(Vertex<T> v) {
        Color result = this.myColors.get(v);
        if (result == null) {
            result = Color.WHITE;
            this.myColors.put(v, result);
        }
        return result;
    }

    private boolean isEmpty() {
        return this.myStack.isEmpty();
    }

    private Vertex<T> peek() {
        return this.myStack.peek();
    }

    private Vertex<T> pop() {
        return this.myStack.pop();
    }

    private void push(Vertex<T> v) {
        this.myStack.push(v);
    }

    private DepthFirstSearch.Predicate<T> allNodesAreVisited() {
        return new AlwaysTrue();
    }

    public String toString() {
        return "DFS from " + this.myStart;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/graph/DFS";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/graph/DFS";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runWhile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AlwaysTrue<T>
    implements DepthFirstSearch.Predicate<T> {
        private AlwaysTrue() {
        }

        @Override
        public boolean apply(@NotNull T node) {
            if (node == null) {
                AlwaysTrue.$$$reportNull$$$0(0);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "jetbrains/buildServer/util/graph/DFS$AlwaysTrue", "apply"));
        }
    }

    private static enum Color {
        WHITE,
        GREY,
        BLACK;

    }
}

