/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.impl;

import java.io.File;
import java.io.IOException;
import jetbrains.buildServer.ExtensionHolder;
import jetbrains.buildServer.util.ArchiveExtractor;
import jetbrains.buildServer.util.ArchiveExtractorManager;
import jetbrains.buildServer.util.ArchiveFileSelector;
import jetbrains.buildServer.util.UnsupportedArchiveTypeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArchiveExtractorManagerImpl
implements ArchiveExtractorManager {
    private final ExtensionHolder myExtensionHolder;

    public ArchiveExtractorManagerImpl(ExtensionHolder extensionHolder) {
        this.myExtensionHolder = extensionHolder;
    }

    public void extractFiles(@NotNull File archive, @NotNull ArchiveFileSelector selector) throws IOException, UnsupportedArchiveTypeException {
        ArchiveExtractor extractor;
        if (archive == null) {
            ArchiveExtractorManagerImpl.$$$reportNull$$$0(0);
        }
        if (selector == null) {
            ArchiveExtractorManagerImpl.$$$reportNull$$$0(1);
        }
        if ((extractor = this.lookupExtractor(archive)) == null) {
            throw new UnsupportedArchiveTypeException(archive);
        }
        extractor.extractFiles(archive, selector);
    }

    @Nullable
    private ArchiveExtractor lookupExtractor(File file) {
        for (ArchiveExtractor extractor : this.myExtensionHolder.getExtensions(ArchiveExtractor.class)) {
            if (!extractor.isSupported(file)) continue;
            return extractor;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "archive";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "selector";
                break;
            }
        }
        objectArray[1] = "jetbrains/buildServer/util/impl/ArchiveExtractorManagerImpl";
        objectArray[2] = "extractFiles";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

