/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.impl;

import com.intellij.openapi.util.io.StreamUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jetbrains.buildServer.util.ArchiveExtractor;
import jetbrains.buildServer.util.ArchiveFileSelector;
import jetbrains.buildServer.util.FileUtil;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.jetbrains.annotations.NotNull;

public abstract class CommonsCompressArchiveExtractorBase
implements ArchiveExtractor {
    protected abstract ArchiveInputStream createReader(@NotNull File var1, @NotNull InputStream var2) throws ArchiveException, IOException;

    protected void postProcessEntry(@NotNull ArchiveEntry entry, @NotNull File file) {
        if (entry == null) {
            CommonsCompressArchiveExtractorBase.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CommonsCompressArchiveExtractorBase.$$$reportNull$$$0(1);
        }
        file.setLastModified(entry.getLastModifiedDate().getTime());
    }

    private void extractFiles(@NotNull ArchiveInputStream archiveStream, @NotNull ArchiveFileSelector selector) throws IOException {
        ArchiveEntry entry;
        if (archiveStream == null) {
            CommonsCompressArchiveExtractorBase.$$$reportNull$$$0(2);
        }
        if (selector == null) {
            CommonsCompressArchiveExtractorBase.$$$reportNull$$$0(3);
        }
        while ((entry = archiveStream.getNextEntry()) != null) {
            File destinationFile = selector.getDestinationFile(entry.getName());
            if (destinationFile == null) continue;
            if (entry.isDirectory()) {
                destinationFile.mkdirs();
                this.postProcessEntry(entry, destinationFile);
                continue;
            }
            File parentDir = destinationFile.getParentFile();
            if (parentDir != null) {
                parentDir.mkdirs();
            }
            CommonsCompressArchiveExtractorBase.copyStreamToFile((InputStream)archiveStream, destinationFile);
            this.postProcessEntry(entry, destinationFile);
        }
    }

    private void extractFiles(@NotNull File archive, @NotNull InputStream archiveStream, @NotNull ArchiveFileSelector selector) throws IOException {
        if (archive == null) {
            CommonsCompressArchiveExtractorBase.$$$reportNull$$$0(4);
        }
        if (archiveStream == null) {
            CommonsCompressArchiveExtractorBase.$$$reportNull$$$0(5);
        }
        if (selector == null) {
            CommonsCompressArchiveExtractorBase.$$$reportNull$$$0(6);
        }
        try {
            ArchiveInputStream extractor = this.createReader(archive, archiveStream);
            this.extractFiles(extractor, selector);
        }
        catch (ArchiveException e) {
            throw new IOException("Unable to create archive extractor: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractFiles(@NotNull File archive, @NotNull ArchiveFileSelector selector) throws IOException {
        if (archive == null) {
            CommonsCompressArchiveExtractorBase.$$$reportNull$$$0(7);
        }
        if (selector == null) {
            CommonsCompressArchiveExtractorBase.$$$reportNull$$$0(8);
        }
        try (FileInputStream archiveStream = new FileInputStream(archive);){
            this.extractFiles(archive, archiveStream, selector);
        }
    }

    private static void copyStreamToFile(InputStream input, File target) throws IOException {
        FileOutputStream writer = new FileOutputStream(target);
        try {
            StreamUtil.copyStreamContent((InputStream)input, (OutputStream)writer);
        }
        finally {
            FileUtil.close((Closeable)writer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveStream";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archive";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/util/impl/CommonsCompressArchiveExtractorBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "postProcessEntry";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "extractFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

