/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.impl;

import com.intellij.openapi.util.io.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import jetbrains.buildServer.util.BinaryDataCache;
import jetbrains.buildServer.util.impl.EhCacheFix_TW_51168;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentBinaryDataCache
implements BinaryDataCache {
    private static final String EH_CACHE_NAME = "contentCache";
    @NotNull
    private final CacheManager myCacheManager;
    @NotNull
    private final Cache myCache;

    public PersistentBinaryDataCache(@NotNull File dir) {
        if (dir == null) {
            PersistentBinaryDataCache.$$$reportNull$$$0(0);
        }
        this(dir, 100, 1000, 86400);
    }

    public PersistentBinaryDataCache(@NotNull File dir, int maxElementsInMemory, int maxElementsOnDisk, int timeToLiveSeconds) {
        if (dir == null) {
            PersistentBinaryDataCache.$$$reportNull$$$0(1);
        }
        Configuration configuration = new Configuration();
        configuration.addDiskStore(new DiskStoreConfiguration());
        configuration.getDiskStoreConfiguration().setPath(EhCacheFix_TW_51168.patchDiskPath((String)dir.getPath()));
        configuration.addDefaultCache(new CacheConfiguration());
        CacheConfiguration cacheConfiguration = configuration.getDefaultCacheConfiguration();
        cacheConfiguration.setName(EH_CACHE_NAME);
        cacheConfiguration.setMaxElementsInMemory(maxElementsInMemory);
        cacheConfiguration.setOverflowToDisk(true);
        if (timeToLiveSeconds >= 0) {
            cacheConfiguration.setTimeToLiveSeconds((long)timeToLiveSeconds);
        }
        cacheConfiguration.setEternal(timeToLiveSeconds < 0);
        cacheConfiguration.setDiskPersistent(true);
        cacheConfiguration.setOverflowToDisk(true);
        cacheConfiguration.setMaxElementsOnDisk(maxElementsOnDisk);
        cacheConfiguration.setClearOnFlush(false);
        this.myCacheManager = new CacheManager(configuration);
        this.myCacheManager.addCache(EH_CACHE_NAME);
        this.myCache = this.myCacheManager.getCache(EH_CACHE_NAME);
    }

    @Override
    public void put(@NotNull String key, @Nullable InputStream stream) {
        if (key == null) {
            PersistentBinaryDataCache.$$$reportNull$$$0(2);
        }
        try {
            this.putBytes(key, stream != null ? StreamUtil.loadFromStream((InputStream)stream) : null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void putBytes(@NotNull String key, @Nullable byte[] bytes) {
        if (key == null) {
            PersistentBinaryDataCache.$$$reportNull$$$0(3);
        }
        this.myCache.put(new Element((Serializable)((Object)key), (Serializable)bytes));
    }

    @Override
    public boolean hasEntry(@NotNull String key) {
        if (key == null) {
            PersistentBinaryDataCache.$$$reportNull$$$0(4);
        }
        return this.myCache.isKeyInCache((Object)key);
    }

    @Override
    @Nullable
    public BinaryDataCache.Entry get(@NotNull String key) {
        Element element;
        if (key == null) {
            PersistentBinaryDataCache.$$$reportNull$$$0(5);
        }
        return (element = this.myCache.get((Serializable)((Object)key))) != null ? new DefaultEntry(element) : null;
    }

    @NotNull
    public Collection<String> getKeys() {
        List list = this.myCache.getKeys();
        if (list == null) {
            PersistentBinaryDataCache.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    public void invalidate(@NotNull String key) {
        if (key == null) {
            PersistentBinaryDataCache.$$$reportNull$$$0(7);
        }
        this.myCache.remove((Serializable)((Object)key));
    }

    public void shutdown() {
        this.myCache.flush();
        this.myCacheManager.shutdown();
    }

    public void flush() {
        this.myCache.flush();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/impl/PersistentBinaryDataCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/impl/PersistentBinaryDataCache";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putBytes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasEntry";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invalidate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DefaultEntry
    implements BinaryDataCache.Entry {
        @NotNull
        private final Element myElement;

        private DefaultEntry(@NotNull Element element) {
            if (element == null) {
                DefaultEntry.$$$reportNull$$$0(0);
            }
            this.myElement = element;
        }

        @Override
        @NotNull
        public String getKey() {
            String string = (String)((Object)this.myElement.getKey());
            if (string == null) {
                DefaultEntry.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public byte[] getBytes() {
            Serializable value = this.myElement.getValue();
            return value != null ? (byte[])value : null;
        }

        @Override
        public InputStream getStream() {
            byte[] value = this.getBytes();
            return value != null ? new ByteArrayInputStream(value) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/util/impl/PersistentBinaryDataCache$DefaultEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/util/impl/PersistentBinaryDataCache$DefaultEntry";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

