/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.impl;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.SystemInfo;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import jetbrains.buildServer.log.Loggers;
import jetbrains.buildServer.util.impl.CommonsCompressArchiveExtractorBase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.ArchiveUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TarArchiveExtractor
extends CommonsCompressArchiveExtractorBase {
    @Override
    protected ArchiveInputStream createReader(@NotNull File archive, @NotNull InputStream archiveStream) throws ArchiveException, IOException {
        BufferedInputStream in;
        if (archive == null) {
            TarArchiveExtractor.$$$reportNull$$$0(0);
        }
        if (archiveStream == null) {
            TarArchiveExtractor.$$$reportNull$$$0(1);
        }
        if (this.isGZip(in = new BufferedInputStream(archiveStream))) {
            in = new GzipCompressorInputStream((InputStream)in);
        } else if (this.isBZip(in)) {
            in = new BZip2CompressorInputStream((InputStream)in);
        }
        return new TarArchiveInputStream((InputStream)in);
    }

    @Override
    protected void postProcessEntry(@NotNull ArchiveEntry entry, @NotNull File file) {
        if (entry == null) {
            TarArchiveExtractor.$$$reportNull$$$0(2);
        }
        if (file == null) {
            TarArchiveExtractor.$$$reportNull$$$0(3);
        }
        super.postProcessEntry(entry, file);
        if (!(entry instanceof TarArchiveEntry)) {
            return;
        }
        TarArchiveEntry tarEntry = (TarArchiveEntry)entry;
        if (SystemInfo.isUnix) {
            TarArchiveExtractor.chmodFile(file, tarEntry.getMode());
        }
    }

    private static void chmodFile(@NotNull File file, int mode) {
        if (file == null) {
            TarArchiveExtractor.$$$reportNull$$$0(4);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        int filteredMode = mode & 0xFFF;
        commandLine.setExePath("chmod");
        commandLine.addParameter("0" + Integer.toOctalString(filteredMode));
        commandLine.addParameter(file.getAbsolutePath());
        String processCaption = commandLine.getCommandLineString();
        try {
            String s;
            Process process = commandLine.createProcess();
            process.getOutputStream().close();
            BufferedReader stderr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((s = stderr.readLine()) != null) {
                Loggers.AGENT.warn(processCaption + " stderr: " + s);
            }
            BufferedReader stdout = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((s = stdout.readLine()) != null) {
                Loggers.AGENT.debug(processCaption + " stdout: " + s);
            }
            int rc = process.waitFor();
            if (rc != 0) {
                Loggers.AGENT.warn(processCaption + ": non-zero exit code " + rc);
            }
        }
        catch (Throwable t) {
            Loggers.AGENT.warn("Exception while executing " + processCaption, t);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean isSupported(@NotNull File archive) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public byte[] getSignature(InputStream in) {
        try {
            byte[] signature = new byte[512];
            in.mark(signature.length);
            int signatureLength = in.read(signature);
            in.reset();
            if (signatureLength > 10) {
                return signature;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public boolean isTar(InputStream in) {
        byte[] sig = this.getSignature(in);
        if (sig == null) {
            return false;
        }
        return TarArchiveExtractor.tarSignatureMatches(sig, sig.length);
    }

    public boolean isGZip(InputStream in) {
        byte[] sig = this.getSignature(in);
        if (sig == null) {
            return false;
        }
        return sig[0] == 31 && sig[1] == -117;
    }

    public boolean isBZip(InputStream in) {
        byte[] sig = this.getSignature(in);
        if (sig == null) {
            return false;
        }
        return sig[0] == 66 && sig[1] == 90;
    }

    private static boolean tarSignatureMatches(byte[] signature, int length) {
        if (!TarArchiveInputStream.matches((byte[])signature, (int)length)) {
            return ArchiveUtils.matchAsciiBuffer((String)"ustar\u0000", (byte[])signature, (int)257, (int)6) && ArchiveUtils.matchAsciiBuffer((String)"\u0000\u0000", (byte[])signature, (int)263, (int)2);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archive";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveStream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/util/impl/TarArchiveExtractor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createReader";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "postProcessEntry";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "chmodFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

