/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.impl;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import jetbrains.buildServer.serverSide.BasePropertiesModel;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.Predicate;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.TimePrinter;
import org.jetbrains.annotations.NotNull;

public class XmlParsingDebug {
    private static long parsingNanos = 0L;
    private static boolean debug = false;
    private static String suffix = ".xml";
    private static boolean validate = true;
    private static boolean useBufferedIS = true;
    private static int errors = 0;
    private static int totalParsed = 0;

    public static void main(String[] args) throws Exception {
        new TeamCityProperties(){
            {
                1.setModel((TeamCityProperties.Model)new BasePropertiesModel());
            }
        };
        if (args.length < 1) {
            System.err.println("Expecting one or more parameters");
            System.out.println("Parses XML from the file passed as the parameter or all .xml files recursively in the directory passed as the parameter");
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            String parameter = args[i];
            if ("-debug".equals(parameter)) {
                debug = true;
                continue;
            }
            if ("-suffix".equalsIgnoreCase(parameter)) {
                if (i + 1 == args.length) {
                    System.err.println("Wrong usage: no argument after \"-suffix\"");
                    System.exit(-2);
                }
                suffix = args[++i];
                continue;
            }
            if ("-validate".equalsIgnoreCase(parameter)) {
                if (i + 1 == args.length) {
                    System.err.println("Wrong usage: no argument after \"-validate\"");
                    System.exit(-2);
                }
                validate = Boolean.parseBoolean(args[++i]);
                continue;
            }
            if ("-bufferedIS".equalsIgnoreCase(parameter)) {
                if (i + 1 == args.length) {
                    System.err.println("Wrong usage: no argument after \"-bufferedIS\"");
                    System.exit(-2);
                }
                useBufferedIS = Boolean.parseBoolean(args[++i]);
                continue;
            }
            File initialFile = new File(parameter);
            if (!initialFile.isDirectory()) {
                XmlParsingDebug.parseFile(initialFile);
                continue;
            }
            final String finalSuffix = suffix;
            ArrayList allFiles = (ArrayList)FileUtil.listFilesRecursively((File)initialFile, (String)"", (boolean)false, (int)Integer.MAX_VALUE, (Predicate)new Predicate<File>(){

                public boolean apply(File item) {
                    return item.isDirectory() || item.getName().endsWith(finalSuffix);
                }
            }, new ArrayList());
            System.out.println("Found " + StringUtil.withPlural((long)allFiles.size(), (String)(suffix + " file")) + " in directory " + initialFile.getAbsolutePath());
            for (String fileName : allFiles) {
                File file = new File(initialFile, fileName);
                XmlParsingDebug.parseFile(file);
            }
        }
        System.out.println();
        System.out.println("Parsed " + StringUtil.withPlural((long)totalParsed, (String)"file") + ", " + errors + " with errors");
        System.out.println("Parsing time: " + TimePrinter.createMillisecondsFormatter().formatTime(TimeUnit.MILLISECONDS.convert(parsingNanos, TimeUnit.NANOSECONDS)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseFile(@NotNull File file) {
        block7: {
            if (file == null) {
                XmlParsingDebug.$$$reportNull$$$0(0);
            }
            try {
                ++totalParsed;
                System.out.println("Parsing " + file.getAbsolutePath());
                long start = System.nanoTime();
                InputStream is = XmlParsingDebug.getIS(file);
                try {
                    FileUtil.parseDocument((InputStream)is, (boolean)validate);
                }
                finally {
                    FileUtil.close((Closeable)is);
                }
                parsingNanos += System.nanoTime() - start;
            }
            catch (Exception e) {
                ++errors;
                System.err.println("Error while processing file \"" + file.getAbsolutePath() + "\": " + e.toString());
                if (!debug) break block7;
                e.printStackTrace();
            }
        }
    }

    @NotNull
    private static InputStream getIS(@NotNull File file) throws FileNotFoundException {
        if (file == null) {
            XmlParsingDebug.$$$reportNull$$$0(1);
        }
        FileInputStream is = new FileInputStream(file);
        if (useBufferedIS) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(is);
            if (bufferedInputStream == null) {
                XmlParsingDebug.$$$reportNull$$$0(2);
            }
            return bufferedInputStream;
        }
        FileInputStream fileInputStream = is;
        if (fileInputStream == null) {
            XmlParsingDebug.$$$reportNull$$$0(3);
        }
        return fileInputStream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/impl/XmlParsingDebug";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/impl/XmlParsingDebug";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIS";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getIS";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

