/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.StreamUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import jetbrains.buildServer.util.ApacheZipSlipAwareZipFile;
import jetbrains.buildServer.util.ArchiveExtractor;
import jetbrains.buildServer.util.ArchiveFileSelector;
import jetbrains.buildServer.util.FileUtil;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.jetbrains.annotations.NotNull;

public class ZipArchiveExtractor
implements ArchiveExtractor {
    private static final Logger LOG = Logger.getInstance((String)ZipArchiveExtractor.class.getName());
    private String myEncoding = "cp437";
    private static final int FILE_MODE_ANY_EXECUTABLE_BIT_MASK = 73;

    public void setEncoding(@NotNull String encoding) {
        if (encoding == null) {
            ZipArchiveExtractor.$$$reportNull$$$0(0);
        }
        this.myEncoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSupported(@NotNull File archive) {
        boolean bl;
        if (archive == null) {
            ZipArchiveExtractor.$$$reportNull$$$0(1);
        }
        FileInputStream archiveStream = new FileInputStream(archive);
        try {
            byte[] signature = new byte[12];
            int signatureLength = archiveStream.read(signature);
            bl = ZipArchiveInputStream.matches((byte[])signature, (int)signatureLength);
        }
        catch (Throwable throwable) {
            try {
                archiveStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        archiveStream.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractFiles(@NotNull File archive, @NotNull ArchiveFileSelector selector) throws IOException {
        if (archive == null) {
            ZipArchiveExtractor.$$$reportNull$$$0(2);
        }
        if (selector == null) {
            ZipArchiveExtractor.$$$reportNull$$$0(3);
        }
        try (ApacheZipSlipAwareZipFile file = new ApacheZipSlipAwareZipFile(archive, this.myEncoding, true);){
            Enumeration enumeration = file.getEntriesInPhysicalOrder();
            while (enumeration.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)enumeration.nextElement();
                File destinationFile = selector.getDestinationFile(entry.getName());
                if (destinationFile == null) continue;
                if (entry.isDirectory()) {
                    destinationFile.mkdirs();
                    this.postProcessEntry((ArchiveEntry)entry, destinationFile);
                    continue;
                }
                File parentDir = destinationFile.getParentFile();
                if (parentDir != null) {
                    parentDir.mkdirs();
                }
                FileOutputStream writer = new FileOutputStream(destinationFile);
                try {
                    StreamUtil.copyStreamContent((InputStream)file.getInputStream(entry), (OutputStream)writer);
                }
                finally {
                    FileUtil.close((Closeable)writer);
                }
                this.postProcessEntry((ArchiveEntry)entry, destinationFile);
            }
        }
    }

    private void postProcessEntry(@NotNull ArchiveEntry entry, @NotNull File file) {
        if (entry == null) {
            ZipArchiveExtractor.$$$reportNull$$$0(4);
        }
        if (file == null) {
            ZipArchiveExtractor.$$$reportNull$$$0(5);
        }
        file.setLastModified(entry.getLastModifiedDate().getTime());
        if (SystemInfo.isUnix && !entry.isDirectory() && ZipArchiveExtractor.hasExecutableBit(entry)) {
            try {
                FileUtil.setExectuableAttribute((String)file.getAbsolutePath(), (boolean)true);
            }
            catch (IOException e) {
                LOG.warn("Failed to set executable flag for: [" + file + "]");
            }
        }
    }

    private static boolean hasExecutableBit(ArchiveEntry archiveEntry) {
        if (archiveEntry instanceof ZipArchiveEntry) {
            int fileMode = ((ZipArchiveEntry)archiveEntry).getUnixMode();
            return (fileMode & 0x49) != 0;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archive";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/util/impl/ZipArchiveExtractor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setEncoding";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "extractFiles";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "postProcessEntry";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

